/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.app;

import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.overlay.Overlay;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.ARGBPlane;
import org.scijava.ui.UserInterface;

@Plugin(type=Command.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Copy To System", weight=12.0)}, attrs={@Attr(name="no-legacy")})
public class CopyToSystem
extends ContextCommand {
    @Parameter
    private UserInterface ui;
    @Parameter
    private OverlayService overlayService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private StatusService statusService;
    @Parameter
    private ImageDisplay display;

    public void run() {
        ARGBPlane pixels = this.getARGBPixels();
        if (pixels == null) {
            return;
        }
        this.ui.getSystemClipboard().pixelsToSystemClipboard(pixels);
        String notice = pixels.getWidth() + "x" + pixels.getHeight() + " image copied to system clipboard";
        this.statusService.showStatus(notice);
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    private ARGBPlane getARGBPixels() {
        int h;
        int w;
        int y;
        int x;
        DatasetView view = this.imageDisplayService.getActiveDatasetView(this.display);
        if (view == null) {
            return null;
        }
        Overlay overlay = this.overlayService.getActiveOverlay(this.display);
        int imageWidth = (int)this.display.dimension(0);
        int imageHeight = (int)this.display.dimension(1);
        int[] argbPixels = view.getScreenImage().getData();
        if (overlay == null) {
            x = 0;
            y = 0;
            w = imageWidth;
            h = imageHeight;
        } else {
            int ovrMinX = (int)overlay.realMin(0);
            int ovrMinY = (int)overlay.realMin(1);
            int ovrMaxX = (int)overlay.realMax(0);
            int ovrMaxY = (int)overlay.realMax(1);
            x = Math.max(0, ovrMinX);
            y = Math.max(0, ovrMinY);
            w = Math.min(imageWidth, ovrMaxX) - x + 1;
            h = Math.min(imageHeight, ovrMaxY) - y + 1;
        }
        ARGBPlane plane = new ARGBPlane(w, h);
        for (int u = 0; u < w; ++u) {
            for (int v = 0; v < h; ++v) {
                int argbLoc = (y + v) * imageWidth + (x + u);
                int argb = argbPixels[argbLoc];
                plane.setARGB(u, v, argb);
            }
        }
        return plane;
    }
}

