/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign;

import net.imagej.Dataset;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.overlay.Overlay;
import net.imagej.plugins.commands.assign.InplaceUnaryTransform;
import net.imglib2.ops.operation.complex.unary.ComplexUnaryOperation;
import net.imglib2.ops.operation.real.unary.RealExp;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Math", mnemonic=109), @Menu(label="Exp...", weight=14.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class ExpDataValues<T extends RealType<T>>
extends ContextCommand {
    @Parameter
    private OverlayService overlayService;
    @Parameter
    private ImageDisplayService imgDispService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter(label="Apply to all planes")
    private boolean allPlanes;

    public void run() {
        Dataset dataset = this.imgDispService.getActiveDataset(this.display);
        Overlay overlay = this.overlayService.getActiveOverlay(this.display);
        DatasetView view = this.imgDispService.getActiveDatasetView(this.display);
        RealExp op = new RealExp();
        InplaceUnaryTransform transform = this.allPlanes ? new InplaceUnaryTransform((ComplexUnaryOperation<DoubleType, DoubleType>)op, new DoubleType(), dataset, overlay) : new InplaceUnaryTransform((ComplexUnaryOperation<DoubleType, DoubleType>)op, new DoubleType(), dataset, overlay, view.getPlanePosition());
        transform.run();
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    public boolean isAllPlanes() {
        return this.allPlanes;
    }

    public void setAllPlanes(boolean value) {
        this.allPlanes = value;
    }
}

