/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.debug;

import java.util.Arrays;
import java.util.List;
import net.imagej.ChannelCollection;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.DrawingTool;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.render.RenderingService;
import net.imagej.render.TextRenderer;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>Sandbox>Multidimensional Test Image", attrs={@Attr(name="no-legacy")})
public class MultidimImage
implements Command {
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private RenderingService renderingService;
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset ds;

    public void run() {
        long[] dims = new long[]{90L, 35L, 4L, 5L, 6L, 7L};
        String name = "Multidimensional Example";
        AxisType[] axes = new AxisType[]{Axes.X, Axes.Y, Axes.CHANNEL, Axes.get((String)"frequency"), Axes.Z, Axes.TIME};
        int bitsPerPixel = 8;
        boolean signed = false;
        boolean floating = false;
        this.ds = this.datasetService.create(dims, "Multidimensional Example", axes, 8, false, false);
        long[] pos = new long[dims.length];
        DrawingTool tool = new DrawingTool(this.ds, this.renderingService);
        List<Double> values = Arrays.asList(255.0, 255.0, 255.0, 255.0);
        ChannelCollection channels = new ChannelCollection(values);
        tool.setChannels(channels);
        int c = 0;
        while ((long)c < dims[2]) {
            int f = 0;
            while ((long)f < dims[3]) {
                int z = 0;
                while ((long)z < dims[4]) {
                    int t = 0;
                    while ((long)t < dims[5]) {
                        pos[2] = c;
                        pos[3] = f;
                        pos[4] = z;
                        pos[5] = t;
                        tool.setPosition(pos);
                        tool.setPreferredChannel((long)c);
                        String label = "c " + c + " f " + f + " z " + z + " t " + t;
                        tool.drawText(5L, 20L, label, TextRenderer.TextJustification.LEFT);
                        ++t;
                    }
                    ++z;
                }
                ++f;
            }
            ++c;
        }
    }
}

