/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.tiff;

import java.io.IOException;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;

public class OnDemandLongArray {
    private DataHandle<Location> stream;
    private int size;
    private long start;

    public OnDemandLongArray(DataHandle<Location> in) throws IOException {
        this.stream = in;
        this.start = this.stream.offset();
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long get(int index) throws IOException {
        long fp = this.stream.offset();
        this.stream.seek(this.start + (long)(index * 8));
        long value = this.stream.readLong();
        this.stream.seek(fp);
        return value;
    }

    public long size() {
        return this.size;
    }

    public void close() throws IOException {
        this.stream.close();
        this.stream = null;
        this.size = 0;
        this.start = 0L;
    }
}

