/*
 * Decompiled with CFR 0.152.
 */
package stitching;

import stitching.FloatArray;

public class FloatArray2D
extends FloatArray {
    public int width = 0;
    public int height = 0;

    public FloatArray2D(int width, int height) {
        this.data = new float[width * height];
        this.width = width;
        this.height = height;
    }

    public FloatArray2D(float[] data, int width, int height) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    @Override
    public FloatArray2D clone() {
        FloatArray2D clone = new FloatArray2D(this.width, this.height);
        System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
        return clone;
    }

    public int getPos(int x, int y) {
        return x + this.width * y;
    }

    public float get(int x, int y) {
        return this.data[this.getPos(x, y)];
    }

    public float getMirror(int x, int y) {
        int dir;
        int tmp;
        if (x >= this.width) {
            x = this.width - (x - this.width + 2);
        }
        if (y >= this.height) {
            y = this.height - (y - this.height + 2);
        }
        if (x < 0) {
            tmp = 0;
            dir = 1;
            while (x < 0) {
                if ((tmp += dir) == this.width - 1 || tmp == 0) {
                    dir *= -1;
                }
                ++x;
            }
            x = tmp;
        }
        if (y < 0) {
            tmp = 0;
            dir = 1;
            while (y < 0) {
                if ((tmp += dir) == this.height - 1 || tmp == 0) {
                    dir *= -1;
                }
                ++y;
            }
            y = tmp;
        }
        return this.data[this.getPos(x, y)];
    }

    public float getZero(int x, int y) {
        if (x >= this.width) {
            return 0.0f;
        }
        if (y >= this.height) {
            return 0.0f;
        }
        if (x < 0) {
            return 0.0f;
        }
        if (y < 0) {
            return 0.0f;
        }
        return this.data[this.getPos(x, y)];
    }

    public float getZero(double x, double y) {
        if (x >= (double)this.width) {
            return 0.0f;
        }
        if (y >= (double)this.height) {
            return 0.0f;
        }
        if (x < 0.0) {
            return 0.0f;
        }
        if (y < 0.0) {
            return 0.0f;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        float lowerLeft = this.getZero(xbase, ybase);
        float lowerRight = this.getZero(xbase + 1, ybase);
        float upperRight = this.getZero(xbase + 1, ybase + 1);
        float upperLeft = this.getZero(xbase, ybase + 1);
        double upperAverage = (double)upperLeft + xFraction * (double)(upperRight - upperLeft);
        double lowerAverage = (double)lowerLeft + xFraction * (double)(lowerRight - lowerLeft);
        return (float)(lowerAverage + yFraction * (upperAverage - lowerAverage));
    }

    public void set(float value, int x, int y) {
        this.data[this.getPos((int)x, (int)y)] = value;
    }
}

