/*
 * Decompiled with CFR 0.152.
 */
package stitching.model;

import java.util.ArrayList;
import java.util.Collection;
import stitching.OverlapProperties;
import stitching.model.Model;
import stitching.model.Point;

public class PointMatch {
    public OverlapProperties o = null;
    private final Point p1;
    private final Point p2;
    protected float[] weights;
    protected float weight;
    protected float strength = 1.0f;
    private float distance;

    public final Point getP1() {
        return this.p1;
    }

    public final Point getP2() {
        return this.p2;
    }

    public final float[] getWeights() {
        return this.weights;
    }

    public final void setWeights(float[] weights) {
        this.weights = (float[])weights.clone();
        this.calculateWeight();
    }

    public final float getWeight() {
        return this.weight;
    }

    public final void setWeight(int index, float weight) {
        this.weights[index] = weight;
        this.calculateWeight();
    }

    protected final void calculateWeight() {
        this.weight = 1.0f;
        for (float wi : this.weights) {
            this.weight *= wi;
        }
    }

    public final float getDistance() {
        return this.distance;
    }

    public PointMatch(Point p1, Point p2, float[] weights, float strength) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = (float[])weights.clone();
        this.calculateWeight();
        this.strength = strength;
        this.distance = Point.distance(p1, p2);
    }

    public PointMatch(Point p1, Point p2, float[] weights) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = (float[])weights.clone();
        this.calculateWeight();
        this.distance = Point.distance(p1, p2);
    }

    public PointMatch(Point p1, Point p2, float weight) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = new float[]{weight};
        this.weight = weight;
        this.distance = Point.distance(p1, p2);
    }

    public PointMatch(Point p1, Point p2, float weight, OverlapProperties o) {
        this.p1 = p1;
        this.p2 = p2;
        this.o = o;
        this.weights = new float[]{weight};
        this.weight = weight;
        this.distance = Point.distance(p1, p2);
    }

    public PointMatch(Point p1, Point p2, float weight, float strength) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = new float[]{weight};
        this.weight = weight;
        this.strength = strength;
        this.distance = Point.distance(p1, p2);
    }

    public PointMatch(Point p1, Point p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.weight = 1.0f;
        this.distance = Point.distance(p1, p2);
    }

    public final void apply(Model model) {
        this.p1.apply(model);
        this.distance = Point.distance(this.p1, this.p2);
    }

    public final void applyByStrength(Model model, float amount) {
        this.p1.apply(model, this.strength * amount);
        this.distance = Point.distance(this.p1, this.p2);
    }

    public static final ArrayList<PointMatch> flip(Collection<PointMatch> matches) {
        ArrayList<PointMatch> list = new ArrayList<PointMatch>();
        for (PointMatch match : matches) {
            list.add(new PointMatch(match.p2, match.p1, match.weights));
        }
        return list;
    }
}

