/*
 * Decompiled with CFR 0.152.
 */
package stitching.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import stitching.model.ErrorStatistic;
import stitching.model.NotEnoughDataPointsException;
import stitching.model.Tile;
import stitching.utils.Log;

public class TileConfiguration {
    private static final DecimalFormat decimalFormat = new DecimalFormat();
    private static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    private final ArrayList<Tile> tiles = new ArrayList();
    private final ArrayList<Tile> fixedTiles = new ArrayList();
    private double minError = Double.MAX_VALUE;
    private double maxError = 0.0;
    private double error = Double.MAX_VALUE;
    private Tile worstTile = null;

    public final ArrayList<Tile> getTiles() {
        return this.tiles;
    }

    public final ArrayList<Tile> getFixedTiles() {
        return this.fixedTiles;
    }

    public TileConfiguration() {
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
    }

    public final double getMinError() {
        return this.minError;
    }

    public final double getMaxError() {
        return this.maxError;
    }

    public final Tile getWorstError() {
        return this.worstTile;
    }

    public final double getAvgError() {
        return this.error;
    }

    public final void addTile(Tile t) {
        this.tiles.add(t);
    }

    public final void addTiles(Collection<Tile> t) {
        this.tiles.addAll(t);
    }

    public final void fixTile(Tile t) {
        this.fixedTiles.add(t);
    }

    private final void update() {
        double cd = 0.0;
        this.minError = Double.MAX_VALUE;
        this.maxError = 0.0;
        for (Tile t : this.tiles) {
            t.update();
            double d = t.getDistance();
            if (d < this.minError) {
                this.minError = d;
            }
            if (d > this.maxError) {
                this.maxError = d;
                this.worstTile = t;
            }
            cd += d;
        }
        this.error = cd /= (double)this.tiles.size();
    }

    public void optimize(float maxAllowedError, int maxIterations, int maxPlateauwidth) throws NotEnoughDataPointsException {
        int i;
        ErrorStatistic observer = new ErrorStatistic();
        for (i = 0; i < maxIterations; ++i) {
            for (Tile tile : this.tiles) {
                if (this.fixedTiles.contains(tile)) continue;
                tile.update();
                tile.fitModel();
                tile.update();
            }
            this.update();
            observer.add(this.error);
            if (i >= maxPlateauwidth && this.error < (double)maxAllowedError && Math.abs(observer.getWideSlope(maxPlateauwidth)) <= 1.0E-4 && Math.abs(observer.getWideSlope(maxPlateauwidth / 2)) <= 1.0E-4) break;
        }
        Log.info("Successfully optimized configuration of " + this.tiles.size() + " tiles after " + i + " iterations:");
        Log.info("  average displacement: " + decimalFormat.format(this.error) + "px");
        Log.info("  minimal displacement: " + decimalFormat.format(this.minError) + "px");
        Log.info("  maximal displacement: " + decimalFormat.format(this.maxError) + "px");
    }
}

