/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import ij.IJ;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.TwinCursor;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.Algorithm;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.results.ResultHandler;

public class InputCheck<T extends RealType<T>>
extends Algorithm<T> {
    protected final double maxZeroZeroRatio = 0.1f;
    protected final double maxSaturatedRatio = 0.1f;
    double zeroZeroPixelRatio;
    double saturatedRatioCh1;
    double saturatedRatioCh2;
    String colocJobName;
    double ch1Max;
    double ch2Max;
    double ch1Min;
    double ch2Min;
    double ch1Mean;
    double ch2Mean;
    double ch1Integral;
    double ch2Integral;
    DataContainer.MaskType maskType;
    double maskID;

    public InputCheck() {
        super("input data check");
    }

    @Override
    public void execute(DataContainer<T> container) throws MissingPreconditionException {
        RandomAccessibleInterval<T> img1 = container.getSourceImage1();
        RandomAccessibleInterval<T> img2 = container.getSourceImage2();
        RandomAccessibleInterval<BitType> mask = container.getMask();
        TwinCursor cursor = new TwinCursor(img1.randomAccess(), img2.randomAccess(), (Cursor<BitType>)Views.iterable(mask).cursor());
        this.ch1Max = container.getMaxCh1();
        this.ch2Max = container.getMaxCh2();
        this.ch1Min = container.getMinCh1();
        this.ch2Min = container.getMinCh2();
        this.ch1Mean = container.getMeanCh1();
        this.ch2Mean = container.getMeanCh2();
        this.ch1Integral = container.getIntegralCh1();
        this.ch2Integral = container.getIntegralCh2();
        this.maskType = container.getMaskType();
        this.maskID = container.getMaskID();
        long N = 0L;
        long Nzero = 0L;
        long NsaturatedCh1 = 0L;
        long NsaturatedCh2 = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            double ch1 = ((RealType)cursor.getFirst()).getRealDouble();
            double ch2 = ((RealType)cursor.getSecond()).getRealDouble();
            if (Math.abs(ch1 + ch2) < 1.0E-5) {
                ++Nzero;
            }
            if (Math.abs(this.ch1Max - ch1) < 1.0E-5) {
                ++NsaturatedCh1;
            }
            if (Math.abs(this.ch2Max - ch2) < 1.0E-5) {
                ++NsaturatedCh2;
            }
            ++N;
        }
        double zeroZeroRatio = (double)Nzero / (double)N;
        double ch1SaturatedRatio = (double)NsaturatedCh1 / ((double)N * 0.5);
        double ch2SaturatedRatio = (double)NsaturatedCh2 / ((double)N * 0.5);
        this.zeroZeroPixelRatio = zeroZeroRatio * 100.0;
        this.saturatedRatioCh1 = ch1SaturatedRatio * 100.0;
        this.saturatedRatioCh2 = ch2SaturatedRatio * 100.0;
        this.colocJobName = container.getJobName();
        if (this.ch1Min < 0.0 || this.ch2Min < 0.0) {
            this.addWarning("Negative minimum pixel value found.", "The minimum pixel value in at least one of the channels is negative. Negative values might break the logic of some analysis methods by breaking a basic basic assumption: The pixel value is assumed to be proportional to the number of photons detected in a pixel. Negative photon counts make no physical sense. Set negative pixel values to zero, or shift pixel intensities higher so there are no negative pixel values.");
        }
        if (Math.abs(zeroZeroRatio) > (double)0.1f) {
            this.addWarning("Zero-zero ratio too high", "The ratio between zero-zero pixels and other pixels is large: " + IJ.d2s((double)zeroZeroRatio, (int)2) + ". Maybe you should use a ROI.");
        }
        if (Math.abs(ch1SaturatedRatio) > (double)0.1f) {
            this.addWarning("Saturated ch1 ratio too high", "The ratio between saturated pixels and other pixels in channel one is large: " + IJ.d2s((double)0.1f, (int)2) + ". Maybe you should use a ROI.");
        }
        if (Math.abs(ch1SaturatedRatio) > (double)0.1f) {
            this.addWarning("Saturated ch2 ratio too high", "The ratio between saturated pixels and other pixels in channel two is large: " + IJ.d2s((double)0.1f, (int)2) + ". Maybe you should use a ROI.");
        }
    }

    @Override
    public void processResults(ResultHandler<T> handler) {
        super.processResults(handler);
        handler.handleValue("Coloc_Job_Name", this.colocJobName);
        handler.handleValue("% zero-zero pixels", this.zeroZeroPixelRatio, 2);
        handler.handleValue("% saturated ch1 pixels", this.saturatedRatioCh1, 2);
        handler.handleValue("% saturated ch2 pixels", this.saturatedRatioCh2, 2);
        handler.handleValue("Channel 1 Max", this.ch1Max, 3);
        handler.handleValue("Channel 2 Max", this.ch2Max, 3);
        handler.handleValue("Channel 1 Min", this.ch1Min, 3);
        handler.handleValue("Channel 2 Min", this.ch2Min, 3);
        handler.handleValue("Channel 1 Mean", this.ch1Mean, 3);
        handler.handleValue("Channel 2 Mean", this.ch2Mean, 3);
        handler.handleValue("Channel 1 Integrated (Sum) Intensity", this.ch1Integral, 3);
        handler.handleValue("Channel 2 Integrated (Sum) Intensity", this.ch2Integral, 3);
        handler.handleValue("Mask Type Used", this.maskType.label());
        handler.handleValue("Mask ID Used", this.maskID, 0);
    }
}

