/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.ShaderAttributeObject;
import org.jogamp.java3d.ShaderAttributeValueRetained;

public class ShaderAttributeValue
extends ShaderAttributeObject {
    public ShaderAttributeValue(String attrName, Object value) {
        super(attrName, value);
    }

    @Override
    public Object getValue() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeObject0"));
        }
        return ((ShaderAttributeValueRetained)this.retained).getValue();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeObject1"));
        }
        if (this.isLive()) {
            ((ShaderAttributeValueRetained)this.retained).setValue(value);
        } else {
            ((ShaderAttributeValueRetained)this.retained).initValue(value);
        }
    }

    @Override
    void createRetained() {
        this.retained = new ShaderAttributeValueRetained();
        this.retained.setSource(this);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof ShaderAttributeValue) {
            ShaderAttributeValue anotherShaderAttributeValue = (ShaderAttributeValue)anObject;
            if (this.getAttributeName().equals(anotherShaderAttributeValue.getAttributeName())) {
                Object value = ((ShaderAttributeValueRetained)this.retained).getValue();
                Object otherValue = ((ShaderAttributeValueRetained)anotherShaderAttributeValue.retained).getValue();
                return value.equals(otherValue);
            }
        }
        return false;
    }
}

