/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import net.imagej.display.ImageDisplay;
import org.scijava.display.Display;
import org.scijava.display.event.input.KyPressedEvent;
import org.scijava.display.event.input.MsDraggedEvent;
import org.scijava.display.event.input.MsPressedEvent;
import org.scijava.display.event.input.MsWheelEvent;
import org.scijava.input.MouseCursor;
import org.scijava.plugin.Plugin;
import org.scijava.tool.AbstractTool;
import org.scijava.tool.Tool;
import org.scijava.util.IntCoords;

@Plugin(type=Tool.class, name="Pan", description="Scrolling tool (or press space bar and drag)", iconPath="/icons/tools/pan.png", priority=-201.0)
public class PanTool
extends AbstractTool {
    public static final double PRIORITY = -201.0;
    private static final int PAN_AMOUNT = 10;
    private int lastX;
    private int lastY;

    public void onKeyDown(KyPressedEvent evt) {
        int panY;
        int panX;
        Display display = evt.getDisplay();
        if (!(display instanceof ImageDisplay)) {
            return;
        }
        ImageDisplay imageDisplay = (ImageDisplay)display;
        switch (evt.getCode()) {
            case UP: {
                panX = 0;
                panY = -10;
                break;
            }
            case DOWN: {
                panX = 0;
                panY = 10;
                break;
            }
            case LEFT: {
                panX = -10;
                panY = 0;
                break;
            }
            case RIGHT: {
                panX = 10;
                panY = 0;
                break;
            }
            default: {
                panY = 0;
                panX = 0;
            }
        }
        if (panX == 0 && panY == 0) {
            return;
        }
        imageDisplay.getCanvas().pan(new IntCoords(panX, panY));
        evt.consume();
    }

    public void onMouseDown(MsPressedEvent evt) {
        if (evt.getButton() != 0) {
            return;
        }
        this.lastX = evt.getX();
        this.lastY = evt.getY();
        evt.consume();
    }

    public void onMouseDrag(MsDraggedEvent evt) {
        if (evt.getButton() != 0) {
            return;
        }
        Display display = evt.getDisplay();
        if (!(display instanceof ImageDisplay)) {
            return;
        }
        ImageDisplay imageDisplay = (ImageDisplay)display;
        int xDelta = this.lastX - evt.getX();
        int yDelta = this.lastY - evt.getY();
        imageDisplay.getCanvas().pan(new IntCoords(xDelta, yDelta));
        this.lastX = evt.getX();
        this.lastY = evt.getY();
        evt.consume();
    }

    public void onMouseWheel(MsWheelEvent evt) {
        Display display = evt.getDisplay();
        if (!(display instanceof ImageDisplay)) {
            return;
        }
        ImageDisplay imageDisplay = (ImageDisplay)display;
        int rotation = evt.getWheelRotation();
        imageDisplay.getCanvas().pan(new IntCoords(0, rotation * 10));
        evt.consume();
    }

    public MouseCursor getCursor() {
        return MouseCursor.HAND;
    }
}

