/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.SwingUtilities;

public class mxSelectionCellsHandler
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -882368002120921842L;
    public static int DEFAULT_MAX_HANDLERS = 100;
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected Rectangle bounds = null;
    protected int maxHandlers = DEFAULT_MAX_HANDLERS;
    protected transient LinkedHashMap<Object, mxCellHandler> handlers = new LinkedHashMap();
    protected transient mxEventSource.mxIEventListener refreshHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object source, mxEventObject evt) {
            if (mxSelectionCellsHandler.this.isEnabled()) {
                mxSelectionCellsHandler.this.refresh();
            }
        }
    };
    protected transient PropertyChangeListener labelMoveHandler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("vertexLabelsMovable") || evt.getPropertyName().equals("edgeLabelsMovable")) {
                mxSelectionCellsHandler.this.refresh();
            }
        }
    };

    public mxSelectionCellsHandler(mxGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        graphComponent.getGraphControl().addMouseListener(this);
        graphComponent.getGraphControl().addMouseMotionListener(this);
        this.addGraphListeners(graphComponent.getGraph());
        graphComponent.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("graph")) {
                    mxSelectionCellsHandler.this.removeGraphListeners((mxGraph)evt.getOldValue());
                    mxSelectionCellsHandler.this.addGraphListeners((mxGraph)evt.getNewValue());
                }
            }
        });
        graphComponent.addListener("paint", new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object sender, mxEventObject evt) {
                Graphics g = (Graphics)evt.getProperty("g");
                mxSelectionCellsHandler.this.paintHandles(g);
            }
        });
    }

    protected void addGraphListeners(mxGraph graph) {
        if (graph != null) {
            graph.getSelectionModel().addListener("change", this.refreshHandler);
            graph.getModel().addListener("change", this.refreshHandler);
            graph.getView().addListener("scale", this.refreshHandler);
            graph.getView().addListener("translate", this.refreshHandler);
            graph.getView().addListener("scaleAndTranslate", this.refreshHandler);
            graph.getView().addListener("down", this.refreshHandler);
            graph.getView().addListener("up", this.refreshHandler);
            graph.addPropertyChangeListener(this.labelMoveHandler);
        }
    }

    protected void removeGraphListeners(mxGraph graph) {
        if (graph != null) {
            graph.getSelectionModel().removeListener(this.refreshHandler, "change");
            graph.getModel().removeListener(this.refreshHandler, "change");
            graph.getView().removeListener(this.refreshHandler, "scale");
            graph.getView().removeListener(this.refreshHandler, "translate");
            graph.getView().removeListener(this.refreshHandler, "scaleAndTranslate");
            graph.getView().removeListener(this.refreshHandler, "down");
            graph.getView().removeListener(this.refreshHandler, "up");
            graph.removePropertyChangeListener(this.labelMoveHandler);
        }
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public int getMaxHandlers() {
        return this.maxHandlers;
    }

    public void setMaxHandlers(int value) {
        this.maxHandlers = value;
    }

    public mxCellHandler getHandler(Object cell) {
        return this.handlers.get(cell);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.graphComponent.isEnabled() && !this.graphComponent.isForceMarqueeEvent(e) && this.isEnabled()) {
            Iterator<mxCellHandler> it = this.handlers.values().iterator();
            while (it.hasNext() && !e.isConsumed()) {
                it.next().mousePressed(e);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> it = this.handlers.values().iterator();
            while (it.hasNext() && !e.isConsumed()) {
                it.next().mouseMoved(e);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> it = this.handlers.values().iterator();
            while (it.hasNext() && !e.isConsumed()) {
                it.next().mouseDragged(e);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> it = this.handlers.values().iterator();
            while (it.hasNext() && !e.isConsumed()) {
                it.next().mouseReleased(e);
            }
        }
        this.reset();
    }

    public String getToolTipText(MouseEvent e) {
        MouseEvent tmp = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.graphComponent.getGraphControl());
        Iterator<mxCellHandler> it = this.handlers.values().iterator();
        String tip = null;
        while (it.hasNext() && tip == null) {
            tip = it.next().getToolTipText(tmp);
        }
        return tip;
    }

    public void reset() {
        Iterator<mxCellHandler> it = this.handlers.values().iterator();
        while (it.hasNext()) {
            it.next().reset();
        }
    }

    public void refresh() {
        mxGraph graph = this.graphComponent.getGraph();
        LinkedHashMap<Object, mxCellHandler> oldHandlers = this.handlers;
        this.handlers = new LinkedHashMap();
        Object[] tmp = graph.getSelectionCells();
        boolean handlesVisible = tmp.length <= this.getMaxHandlers();
        Rectangle handleBounds = null;
        for (int i = 0; i < tmp.length; ++i) {
            mxCellState state = graph.getView().getState(tmp[i]);
            if (state == null || state.getCell() == graph.getView().getCurrentRoot()) continue;
            mxCellHandler handler = (mxCellHandler)oldHandlers.remove(tmp[i]);
            if (handler != null) {
                handler.refresh(state);
            } else {
                handler = this.graphComponent.createHandler(state);
            }
            if (handler == null) continue;
            handler.setHandlesVisible(handlesVisible);
            this.handlers.put(tmp[i], handler);
            Rectangle bounds = handler.getBounds();
            Stroke stroke = handler.getSelectionStroke();
            if (stroke != null) {
                bounds = stroke.createStrokedShape(bounds).getBounds();
            }
            if (handleBounds == null) {
                handleBounds = bounds;
                continue;
            }
            handleBounds.add(bounds);
        }
        for (mxCellHandler handler : oldHandlers.values()) {
            handler.destroy();
        }
        Rectangle dirty = this.bounds;
        if (handleBounds != null) {
            if (dirty != null) {
                dirty.add(handleBounds);
            } else {
                dirty = handleBounds;
            }
        }
        if (dirty != null) {
            this.graphComponent.getGraphControl().repaint(dirty);
        }
        this.bounds = handleBounds;
    }

    public void paintHandles(Graphics g) {
        Iterator<mxCellHandler> it = this.handlers.values().iterator();
        while (it.hasNext()) {
            it.next().paint(g);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }
}

