/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.ImagePlus;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;

public class Plot_Dots
implements PlugIn,
MouseMotionListener {
    public double[] x = new double[]{0.0, 5.0, 10.0};
    public double[] y = new double[]{0.0, 5.0, 10.0};
    public String[] labels = new String[]{"p1", "p2", "p3"};
    public static final int size = 300;
    public String xLabel = "xLabel";
    public String yLabel = "yLabel";
    public static final Font FONT = new Font("SansSerif", 0, 10);
    public static final DecimalFormat DF = new DecimalFormat("#####.000");
    public static final int INDENT = 40;
    public static final int CTRL_HEIGHT = 100;
    public static boolean drawLabels = true;
    private ImageProcessor ip;
    private double xmin;
    private double ymin;
    private double xmax;
    private double ymax;
    private double xdiff;
    private double ydiff;
    private double factor;
    private int w;
    private int h;
    private ImagePlus imp;
    int previous = 0;

    public void run(String arg) {
    }

    public void create() {
        this.xmin = this.min(this.x);
        this.ymin = this.min(this.y);
        this.xmax = this.max(this.x);
        this.ymax = this.max(this.y);
        this.xdiff = this.xmax - this.xmin;
        this.ydiff = this.ymax - this.ymin;
        this.factor = this.xdiff > this.ydiff ? 300.0 / this.xdiff : 300.0 / this.ydiff;
        this.w = (int)(this.xdiff * this.factor);
        this.h = (int)(this.ydiff * this.factor);
        this.ip = new ByteProcessor(this.w + 80, this.h + 120 + 100);
        this.ip.setColor(255);
        this.ip.fill();
        this.drawAxis();
        this.drawPoints();
        this.imp = new ImagePlus("lkdjf", this.ip);
        this.imp.show();
        this.imp.getCanvas().addMouseMotionListener((MouseMotionListener)this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        double x = (double)(e.getX() - 40) / this.factor + this.xmin;
        double y = (double)(this.h + 40 - e.getY()) / this.factor + this.ymin;
        this.drawPos(x, y);
        this.drawNearestPoint(x, y);
        this.imp.updateAndDraw();
    }

    public int getNearestPoint(double xi, double yi) {
        double min = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < this.x.length; ++i) {
            double d = Math.abs(xi - this.x[i]) + Math.abs(yi - this.y[i]);
            if (!(d < min)) continue;
            min = d;
            index = i;
        }
        return index;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouxeExited(MouseEvent e) {
    }

    public void drawAxis() {
        this.ip.setColor(0);
        this.ip.setFont(FONT);
        this.ip.drawLine(40, this.h + 40, this.w + 40, this.h + 40);
        this.ip.drawLine(40, this.h + 40, 40, 40);
        this.ip.setJustification(1);
        this.ip.drawString(this.xLabel, this.w / 2 + 40, this.h + 80 - 3);
        ByteProcessor tmp = new ByteProcessor(this.h + 80, 12);
        tmp.setColor(255);
        tmp.fill();
        tmp.setFont(FONT);
        tmp.setJustification(1);
        tmp.setColor(0);
        tmp.drawString(this.yLabel, this.h / 2 + 40, 12);
        tmp = tmp.rotateLeft();
        this.ip.insert((ImageProcessor)tmp, 0, 0);
        this.drawXMarker(this.xmin);
        this.drawXMarker(this.xmax);
        this.drawXMarker(this.xmin + (this.xmax - this.xmin) / 2.0);
        this.drawYMarker(this.ymin);
        this.drawYMarker(this.ymax);
        this.drawYMarker(this.ymin + (this.ymax - this.ymin) / 2.0);
    }

    public void drawPos(double x, double y) {
        this.ip.setColor(255);
        this.ip.setRoi(40, this.h + 80, this.w, 100);
        this.ip.fill();
        this.ip.resetRoi();
        this.ip.setColor(0);
        this.ip.setFont(new Font("SansSerif", 0, 12));
        this.ip.drawString("X pos: " + DF.format(x), 40, this.h + 80 + 20);
        this.ip.drawString("Y pos: " + DF.format(y), 40, this.h + 80 + 35);
    }

    public void drawNearestPoint(double xi, double yi) {
        this.ip.setFont(new Font("SansSerif", 1, 12));
        this.ip.drawString("Nearest point:", 40, this.h + 80 + 55);
        this.drawPoint(this.previous, 0);
        int i = this.getNearestPoint(xi, yi);
        this.ip.setFont(new Font("SansSerif", 0, 12));
        this.ip.drawString("Point: " + this.labels[i], 40, this.h + 80 + 70);
        this.ip.drawString(this.xLabel + ": " + DF.format(this.x[i]), 40, this.h + 80 + 85);
        this.ip.drawString(this.yLabel + ": " + DF.format(this.y[i]), 40, this.h + 80 + 100);
        this.drawPoint(i, 100);
        this.previous = i;
    }

    public void drawXMarker(double x) {
        int xp = (int)(this.factor * (x - this.xmin)) + 40;
        this.ip.drawLine(xp, this.h + 40 - 2, xp, this.h + 40 + 2);
        this.ip.setJustification(1);
        this.ip.drawString(DF.format(x), xp, this.h + 80 - 20);
    }

    public void drawYMarker(double y) {
        int yp = this.h + 40 - (int)(this.factor * (y - this.ymin));
        this.ip.drawLine(38, yp, 42, yp);
        this.ip.setJustification(1);
        this.ip.drawString(DF.format(y), 20, yp);
    }

    public void drawPoint(int i, int c) {
        int xp = (int)(this.factor * (this.x[i] - this.xmin)) + 40;
        int yp = this.h + 40 - (int)(this.factor * (this.y[i] - this.ymin));
        this.ip.setColor(c);
        this.ip.setFont(FONT);
        this.ip.drawLine(xp - 3, yp - 3, xp + 3, yp + 3);
        this.ip.setLineWidth(2);
        this.ip.drawLine(xp - 3, yp + 3, xp + 3, yp - 3);
        if (drawLabels) {
            this.ip.drawString(this.labels[i], xp + 4, yp + 4);
        }
    }

    public void drawPoints() {
        this.ip.setJustification(0);
        for (int i = 0; i < this.x.length; ++i) {
            this.drawPoint(i, 0);
        }
    }

    public double max(double[] values) {
        double max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    public double min(double[] values) {
        double min = values[0];
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }
}

