/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import util.RGB_to_Luminance;
import vib.TransformedImage;

public class Exposure_Blend_Two_Stacks
implements PlugIn {
    public void run(String arg0) {
        int i;
        String none;
        int maxCountsAllowed = 10000;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error((String)"No images are open.");
            return;
        }
        String[] titles = new String[wList.length + 1];
        for (int i2 = 0; i2 < wList.length; ++i2) {
            ImagePlus imp = WindowManager.getImage((int)wList[i2]);
            titles[i2] = imp != null ? imp.getTitle() : "";
        }
        titles[wList.length] = none = "*None*";
        GenericDialog gd = new GenericDialog("Exposure Blend");
        gd.addChoice("Stack with detail in dark regions (appears brighter):", titles, titles[0]);
        gd.addChoice("Stack with detail in bright regions (appears darker):", titles, titles[1]);
        gd.addCheckbox("Keep source images", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int imagesToBlend = 2;
        int[] index = new int[imagesToBlend];
        index[0] = gd.getNextChoiceIndex();
        index[1] = gd.getNextChoiceIndex();
        ImagePlus[] sourceImages = new ImagePlus[imagesToBlend];
        sourceImages[0] = WindowManager.getImage((int)wList[index[0]]);
        sourceImages[1] = WindowManager.getImage((int)wList[index[1]]);
        int width = sourceImages[0].getWidth();
        int height = sourceImages[0].getHeight();
        int depth = sourceImages[0].getStackSize();
        for (i = 1; i < imagesToBlend; ++i) {
            if (width == sourceImages[i].getWidth() && height == sourceImages[i].getHeight() && depth == sourceImages[i].getStackSize()) continue;
            IJ.error((String)("The dimensions of image stack " + sourceImages[i].getTitle() + " do not match those of " + sourceImages[0].getTitle()));
            return;
        }
        int type0 = sourceImages[0].getType();
        for (i = 1; i < imagesToBlend; ++i) {
            if (type0 != sourceImages[i].getType()) {
                IJ.error((String)"Can't exposure blend images of different types.");
                return;
            }
            int bitDepth = sourceImages[0].getBitDepth();
            System.out.println("bitDepth: " + bitDepth);
            if (bitDepth != 8 && bitDepth != 16 && bitDepth != 24) {
                IJ.error((String)"Images must be 8-bit, 16-bit or RGB");
                return;
            }
            if (bitDepth == 24) {
                for (i = 0; i < imagesToBlend; ++i) {
                    sourceImages[i] = RGB_to_Luminance.convertToLuminance((ImagePlus)sourceImages[i]);
                    sourceImages[i].show();
                }
                type0 = sourceImages[0].getType();
                bitDepth = sourceImages[0].getBitDepth();
            }
            ImageStack[] stacks = new ImageStack[imagesToBlend];
            for (i = 0; i < imagesToBlend; ++i) {
                stacks[i] = sourceImages[i].getStack();
            }
            TransformedImage ti = new TransformedImage(sourceImages[0], sourceImages[1]);
            float[] range = ti.getValuesRange();
            IJ.error((String)"FIXME: deliberately broken for the moment...");
        }
    }
}

