/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Conv;
import edu.mines.jtk.dsp.KaiserWindow;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class HilbertTransformFilter {
    private static final int NMAX_DEFAULT = 100000;
    private static final float EMAX_DEFAULT = 0.01f;
    private static final float FMIN_DEFAULT = 0.025f;
    private static final float FMAX_DEFAULT = 0.475f;
    private float[] _filter;

    public HilbertTransformFilter() {
        this._filter = HilbertTransformFilter.design(100000, 0.01f, 0.025f, 0.475f);
    }

    public HilbertTransformFilter(int nmax, float emax, float fmin, float fmax) {
        this._filter = HilbertTransformFilter.design(nmax, emax, fmin, fmax);
    }

    public void apply(int n, float[] x, float[] y) {
        Conv.conv(this._filter.length, -(this._filter.length - 1) / 2, this._filter, n, 0, x, n, 0, y);
    }

    public int length() {
        return this._filter.length;
    }

    private static float idealFilter(float x) {
        if (x == 0.0f) {
            return 0.0f;
        }
        float y = 1.5707964f * x;
        float s = ArrayMath.sin(y);
        return -s * s / y;
    }

    private static float[] design() {
        return HilbertTransformFilter.design(100000, 0.01f, 0.025f, 0.475f);
    }

    private static float[] design(int nmax, float emax, float fmin, float fmax) {
        float width;
        float emaxWindow;
        KaiserWindow kw;
        int n;
        Check.argument(nmax > 0, "nmax>0");
        Check.argument(emax > 0.0f, "emax>0.0f");
        Check.argument(fmin > 0.0f, "fmin>0.0f");
        Check.argument(fmax < 0.5f, "fmax<0.5f");
        Check.argument(fmin < fmax, "fmin<fmax");
        if (fmin < 0.5f - fmax) {
            fmax = 0.5f - fmin;
        }
        if ((n = 1 + (int)ArrayMath.ceil((kw = KaiserWindow.fromErrorAndWidth(emaxWindow = 0.5f * emax, width = 2.0f * (0.5f - fmax))).getLength())) % 2 == 0) {
            ++n;
        }
        if (n > nmax) {
            n = nmax;
        }
        if (n % 2 == 0) {
            --n;
        }
        float length = n;
        kw = KaiserWindow.fromWidthAndLength(width, length);
        float[] f = new float[n];
        int k = (n - 1) / 2;
        int i = 0;
        int j = n - 1;
        while (i < k) {
            float x = i - k;
            float fideal = HilbertTransformFilter.idealFilter(x);
            float window = (float)kw.evaluate(x);
            f[i] = fideal * window;
            f[j] = -f[i];
            ++i;
            --j;
        }
        f[k] = 0.0f;
        return f;
    }
}

