/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.SymmetricTridiagonalFilter;
import edu.mines.jtk.util.ArrayMath;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SymmetricTridiagonalFilterTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(SymmetricTridiagonalFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void test1Simple() {
        int n = 5;
        double al = 0.75;
        double af = 0.75;
        double ai = 0.5;
        double b = 0.25;
        SymmetricTridiagonalFilter f = new SymmetricTridiagonalFilter(af, ai, al, b);
        float[] x = ArrayMath.zerofloat(n);
        float[] y = ArrayMath.zerofloat(n);
        float[] z = ArrayMath.zerofloat(n);
        ArrayMath.fill(1.0f, x);
        f.apply(x, y);
        f.applyInverse(y, z);
        SymmetricTridiagonalFilterTest.assertEqual(x, z);
    }

    public void test2Simple() {
        int n1 = 5;
        int n2 = 4;
        double al = 0.75;
        double af = 0.75;
        double ai = 0.5;
        double b = 0.25;
        SymmetricTridiagonalFilter f = new SymmetricTridiagonalFilter(af, ai, al, b);
        float[][] x = ArrayMath.zerofloat(n1, n2);
        float[][] y = ArrayMath.zerofloat(n1, n2);
        float[][] z = ArrayMath.zerofloat(n1, n2);
        ArrayMath.fill(1.0f, x);
        f.apply1(x, y);
        f.apply2(y, y);
        f.applyInverse1(y, z);
        f.applyInverse2(z, z);
        SymmetricTridiagonalFilterTest.assertEqual(x, z);
    }

    public void test3Simple() {
        int n1 = 11;
        int n2 = 12;
        int n3 = 13;
        float[][][] r = ArrayMath.randfloat(n1, n2, n3);
        float[][][] x = ArrayMath.copy(r);
        float[][][] y = ArrayMath.copy(r);
        SymmetricTridiagonalFilter stf = new SymmetricTridiagonalFilter(2.6, 2.5, 2.7, 1.2);
        stf.apply1(x, x);
        stf.apply2(x, x);
        stf.apply3(x, x);
        stf.apply1(y, y);
        y = SymmetricTridiagonalFilterTest.transpose12(y);
        stf.apply1(y, y);
        y = SymmetricTridiagonalFilterTest.transpose12(y);
        y = SymmetricTridiagonalFilterTest.transpose23(y);
        stf.apply2(y, y);
        y = SymmetricTridiagonalFilterTest.transpose23(y);
        SymmetricTridiagonalFilterTest.assertEqual(x, y);
    }

    public void test2Transpose() {
        int n1 = 4;
        int n2 = 5;
        double al = 0.76;
        double af = 0.76;
        double ai = 0.52;
        double b = 0.24;
        SymmetricTridiagonalFilter f = new SymmetricTridiagonalFilter(af, ai, al, b);
        float[][] x = ArrayMath.randfloat(n1, n2);
        float[][] y = ArrayMath.zerofloat(n1, n2);
        float[][] z = ArrayMath.zerofloat(n2, n1);
        f.apply1(x, y);
        x = ArrayMath.transpose(x);
        f.apply2(x, z);
        z = ArrayMath.transpose(z);
        SymmetricTridiagonalFilterTest.assertEqual(y, z);
    }

    public void test1Random() {
        Random r = new Random();
        int ntest = 1000;
        for (int itest = 0; itest < ntest; ++itest) {
            SymmetricTridiagonalFilter stf = SymmetricTridiagonalFilterTest.makeRandomFilter();
            boolean inplace = r.nextBoolean();
            int n = 2 + r.nextInt(10);
            float[] t = ArrayMath.randfloat(r, n);
            float[] x = ArrayMath.copy(t);
            float[] y = inplace ? x : ArrayMath.zerofloat(n);
            float[] z = inplace ? x : ArrayMath.zerofloat(n);
            stf.apply(x, y);
            stf.applyInverse(y, z);
            SymmetricTridiagonalFilterTest.assertEqual(t, x);
            SymmetricTridiagonalFilterTest.assertEqual(t, z);
        }
    }

    public void test2Random() {
        Random r = new Random();
        int ntest = 1000;
        for (int itest = 0; itest < ntest; ++itest) {
            SymmetricTridiagonalFilter stf = SymmetricTridiagonalFilterTest.makeRandomFilter();
            boolean inplace = r.nextBoolean();
            int n1 = 2 + r.nextInt(11);
            int n2 = 2 + r.nextInt(12);
            float[][] t = ArrayMath.randfloat(r, n1, n2);
            float[][] x = ArrayMath.copy(t);
            float[][] y = inplace ? x : ArrayMath.zerofloat(n1, n2);
            float[][] z = inplace ? x : ArrayMath.zerofloat(n1, n2);
            stf.apply1(x, y);
            stf.applyInverse1(y, z);
            SymmetricTridiagonalFilterTest.assertEqual(t, x);
            SymmetricTridiagonalFilterTest.assertEqual(t, z);
            stf.apply2(x, y);
            stf.applyInverse2(y, z);
            SymmetricTridiagonalFilterTest.assertEqual(t, x);
            SymmetricTridiagonalFilterTest.assertEqual(t, z);
        }
    }

    public void test3Random() {
        Random r = new Random();
        int ntest = 1000;
        for (int itest = 0; itest < ntest; ++itest) {
            SymmetricTridiagonalFilter stf = SymmetricTridiagonalFilterTest.makeRandomFilter();
            boolean inplace = r.nextBoolean();
            int n1 = 2 + r.nextInt(11);
            int n2 = 2 + r.nextInt(12);
            int n3 = 2 + r.nextInt(13);
            float[][][] t = ArrayMath.randfloat(r, n1, n2, n3);
            float[][][] x = ArrayMath.copy(t);
            float[][][] y = inplace ? x : ArrayMath.zerofloat(n1, n2, n3);
            float[][][] z = inplace ? x : ArrayMath.zerofloat(n1, n2, n3);
            stf.apply1(x, y);
            stf.applyInverse1(y, z);
            SymmetricTridiagonalFilterTest.assertEqual(t, x);
            SymmetricTridiagonalFilterTest.assertEqual(t, z);
            stf.apply2(x, y);
            stf.applyInverse2(y, z);
            SymmetricTridiagonalFilterTest.assertEqual(t, x);
            SymmetricTridiagonalFilterTest.assertEqual(t, z);
            stf.apply3(x, y);
            stf.applyInverse3(y, z);
            SymmetricTridiagonalFilterTest.assertEqual(t, x);
            SymmetricTridiagonalFilterTest.assertEqual(t, z);
        }
    }

    private static SymmetricTridiagonalFilter makeRandomFilter() {
        Random r = new Random();
        boolean aeq2b = r.nextBoolean();
        boolean abneg = r.nextBoolean();
        boolean afzs = r.nextBoolean();
        boolean alzs = r.nextBoolean();
        if (aeq2b && afzs && alzs) {
            if (r.nextBoolean()) {
                afzs = false;
            } else {
                alzs = false;
            }
        }
        float b = r.nextFloat();
        float ai = 2.0f * b;
        if (!aeq2b) {
            ai = (float)((double)ai + ArrayMath.max(0.001, (double)r.nextFloat()) * (double)b);
        }
        if (abneg) {
            ai = -ai;
        }
        float af = ai;
        float al = ai;
        if (afzs) {
            af = ai + b;
        }
        if (alzs) {
            al = ai + b;
        }
        return new SymmetricTridiagonalFilter(af, ai, al, b);
    }

    private static float[][][] transpose12(float[][][] x) {
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        float[][][] y = new float[n3][n1][n2];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    y[i3][i1][i2] = x[i3][i2][i1];
                }
            }
        }
        return y;
    }

    private static float[][][] transpose23(float[][][] x) {
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        float[][][] y = new float[n2][n3][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    y[i2][i3][i1] = x[i3][i2][i1];
                }
            }
        }
        return y;
    }

    private static void assertEqual(float[] e, float[] a) {
        float tol = 0.001f * ArrayMath.max(ArrayMath.abs(e));
        SymmetricTridiagonalFilterTest.assertEqual(e, a, tol);
    }

    private static void assertEqual(float[][] e, float[][] a) {
        float tol = 0.001f * ArrayMath.max(ArrayMath.abs(e));
        SymmetricTridiagonalFilterTest.assertEqual(e, a, tol);
    }

    private static void assertEqual(float[][][] e, float[][][] a) {
        float tol = 0.001f * ArrayMath.max(ArrayMath.abs(e));
        SymmetricTridiagonalFilterTest.assertEqual(e, a, tol);
    }

    private static void assertEqual(float[] e, float[] a, float tol) {
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            SymmetricTridiagonalFilterTest.assertEquals((float)e[i], (float)a[i], (float)tol);
        }
    }

    private static void assertEqual(float[][] e, float[][] a, float tol) {
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            SymmetricTridiagonalFilterTest.assertEqual(e[i], a[i], tol);
        }
    }

    private static void assertEqual(float[][][] e, float[][][] a, float tol) {
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            SymmetricTridiagonalFilterTest.assertEqual(e[i], a[i], tol);
        }
    }
}

