/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.Gridder3;
import edu.mines.jtk.util.ArrayMath;

public class DiscreteSibsonGridder3
implements Gridder3 {
    private int _n;
    private float[] _f;
    private float[] _x1;
    private float[] _x2;
    private float[] _x3;
    private int _nsmooth;

    public DiscreteSibsonGridder3(float[] f, float[] x1, float[] x2, float[] x3) {
        this.setScattered(f, x1, x2, x3);
    }

    private void setSmooth(int nsmooth) {
        this._nsmooth = nsmooth;
    }

    @Override
    public void setScattered(float[] f, float[] x1, float[] x2, float[] x3) {
        this._n = f.length;
        this._f = f;
        this._x1 = x1;
        this._x2 = x2;
        this._x3 = x3;
    }

    @Override
    public float[][][] grid(Sampling s1, Sampling s2, Sampling s3) {
        int i2;
        int i3;
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int n3 = s3.getCount();
        float fx1 = (float)s1.getFirst();
        float fx2 = (float)s2.getFirst();
        float fx3 = (float)s3.getFirst();
        float lx1 = (float)s1.getLast();
        float lx2 = (float)s2.getLast();
        float lx3 = (float)s3.getLast();
        float dx1 = (float)s1.getDelta();
        float dx2 = (float)s2.getDelta();
        float dx3 = (float)s3.getDelta();
        float od1 = 1.0f / dx1;
        float od2 = 1.0f / dx2;
        float od3 = 1.0f / dx3;
        float[][][] g = new float[n3][n2][n1];
        float[][][] c = new float[n3][n2][n1];
        for (int i = 0; i < this._n; ++i) {
            float x1i = this._x1[i];
            float x2i = this._x2[i];
            float x3i = this._x3[i];
            if (x1i < fx1 || x1i > lx1 || x2i < fx2 || x2i > lx2 || x3i < fx3 || x3i > lx3) continue;
            int i1 = (int)(0.5f + (x1i - fx1) * od1);
            int i22 = (int)(0.5f + (x2i - fx2) * od2);
            int i32 = (int)(0.5f + (x3i - fx3) * od3);
            float[] fArray = c[i32][i22];
            int n = i1;
            fArray[n] = fArray[n] + 1.0f;
            float[] fArray2 = g[i32][i22];
            int n4 = i1;
            fArray2[n4] = fArray2[n4] + this._f[i];
        }
        for (int i33 = 0; i33 < n3; ++i33) {
            for (int i23 = 0; i23 < n2; ++i23) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    if (!(c[i33][i23][i1] > 0.0f)) continue;
                    float[] fArray = g[i33][i23];
                    int n = i1;
                    fArray[n] = fArray[n] / c[i33][i23][i1];
                    c[i33][i23][i1] = -c[i33][i23][i1];
                }
            }
        }
        int nk = n1 * n2 * n3;
        int[] kk = new int[nk];
        float[] ds = new float[nk];
        int k = 0;
        for (i3 = 0; i3 < n3; ++i3) {
            double x3 = (float)i3 * dx3;
            for (int i24 = 0; i24 < n2; ++i24) {
                double x2 = (float)i24 * dx2;
                int i1 = 0;
                while (i1 < n1) {
                    double x1 = (float)i1 * dx1;
                    ds[k] = (float)(x1 * x1 + x2 * x2 + x3 * x3);
                    kk[k] = k;
                    ++i1;
                    ++k;
                }
            }
        }
        ArrayMath.quickIndexSort(ds, kk);
        for (i3 = 0; i3 < n3; ++i3) {
            for (i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    int m1;
                    int j1;
                    int m2;
                    int j2;
                    int m3;
                    int j3;
                    int k3;
                    int k2;
                    int k1;
                    int ik;
                    int kn = -1;
                    float fn = 0.0f;
                    for (int k4 = 0; k4 < nk && kn < 0; ++k4) {
                        ik = kk[k4];
                        k1 = ik % n1;
                        k2 = (ik /= n1) % n2;
                        k3 = ik /= n2;
                        j3 = i3 - k3;
                        for (m3 = 0; m3 < 3; ++m3) {
                            if ((j3 != i3 || m3 <= 0) && j3 >= 0 && j3 < n3) {
                                j2 = i2 - k2;
                                for (m2 = 0; m2 < 2; ++m2) {
                                    if ((j2 != i2 || m2 <= 0) && j2 >= 0 && j2 < n2) {
                                        j1 = i1 - k1;
                                        for (m1 = 0; m1 < 2; ++m1) {
                                            if ((j1 != i1 || m1 <= 0) && j1 >= 0 && j1 < n1 && c[j3][j2][j1] < 0.0f) {
                                                kn = k4;
                                                fn = g[j3][j2][j1];
                                            }
                                            j1 = i1 + k1;
                                        }
                                    }
                                    j2 = i2 + k2;
                                }
                            }
                            j3 = i3 + k3;
                        }
                    }
                    float dsk = ds[kk[kn]];
                    while (kn + 1 < nk && dsk == ds[kk[kn + 1]]) {
                        ++kn;
                    }
                    for (int k5 = 0; k5 <= kn; ++k5) {
                        ik = kk[k5];
                        k1 = ik % n1;
                        k2 = (ik /= n1) % n2;
                        k3 = ik /= n2;
                        j3 = i3 - k3;
                        for (m3 = 0; m3 < 2; ++m3) {
                            if ((j3 != i3 || m3 <= 0) && j3 >= 0 && j3 < n3) {
                                j2 = i2 - k2;
                                for (m2 = 0; m2 < 2; ++m2) {
                                    if ((j2 != i2 || m2 <= 0) && j2 >= 0 && j2 < n2) {
                                        j1 = i1 - k1;
                                        for (m1 = 0; m1 < 2; ++m1) {
                                            if ((j1 != i1 || m1 <= 0) && j1 >= 0 && j1 < n1 && c[j3][j2][j1] >= 0.0f) {
                                                float[] fArray = g[j3][j2];
                                                int n = j1;
                                                fArray[n] = fArray[n] + fn;
                                                float[] fArray3 = c[j3][j2];
                                                int n5 = j1;
                                                fArray3[n5] = fArray3[n5] + 1.0f;
                                            }
                                            j1 = i1 + k1;
                                        }
                                    }
                                    j2 = i2 + k2;
                                }
                            }
                            j3 = i3 + k3;
                        }
                    }
                }
            }
        }
        for (i3 = 0; i3 < n3; ++i3) {
            for (i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    if (!(c[i3][i2][i1] > 0.0f)) continue;
                    float[] fArray = g[i3][i2];
                    int n = i1;
                    fArray[n] = fArray[n] / c[i3][i2][i1];
                }
            }
        }
        return g;
    }
}

