/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.LinearTransform;
import edu.mines.jtk.opt.LinearTransformWrapper;
import edu.mines.jtk.opt.Quadratic;
import edu.mines.jtk.opt.TransformQuadratic;
import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import edu.mines.jtk.util.Monitor;
import java.util.logging.Logger;

public class QuadraticSolver {
    private Quadratic _quadratic = null;
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");

    public QuadraticSolver(Quadratic quadratic) {
        this._quadratic = quadratic;
    }

    public Vect solve(int numberIterations, Monitor monitor) {
        if (monitor == null) {
            monitor = Monitor.NULL_MONITOR;
        }
        monitor.report(0.0);
        Vect b = this._quadratic.getB();
        monitor.report(1.0 / ((double)numberIterations + 2.0));
        double bb = b.dot(b);
        QuadraticSolver.checkNaN(bb);
        if (Almost.FLOAT.zero(bb)) {
            LOG.fine("Gradient of quadratic is negligible.  Not solving");
            Vect result = VectUtil.cloneZero(b);
            monitor.report(1.0);
            return result;
        }
        Vect g = b;
        b = null;
        Vect x = VectUtil.cloneZero(g);
        Vect p = x.clone();
        Vect u = x.clone();
        double pu = 0.0;
        Vect qa = g.clone();
        for (int iter = 0; iter < numberIterations && !monitor.isCanceled(); ++iter) {
            double beta = 0.0;
            Vect q = qa;
            VectUtil.copy(q, g);
            this._quadratic.inverseHessian(q);
            q.postCondition();
            this._quadratic.multiplyHessian(q);
            monitor.report(((double)iter + 2.0) / ((double)numberIterations + 2.0));
            if (iter > 0) {
                double pq = p.dot(q);
                QuadraticSolver.checkNaN(pq);
                beta = Almost.FLOAT.divide(pq, pu, 0.0);
                if (beta < -5.0) {
                    beta = -5.0;
                }
                if (beta > 5.0) {
                    beta = 5.0;
                }
            }
            u.add(beta, -1.0, q);
            Vect a = qa;
            VectUtil.copy(a, g);
            this._quadratic.inverseHessian(a);
            a.postCondition();
            p.add(beta, -1.0, a);
            double pg = p.dot(g);
            QuadraticSolver.checkNaN(pg);
            pu = p.dot(u);
            QuadraticSolver.checkNaN(pu);
            if (Almost.FLOAT.zero(pg) || Almost.FLOAT.zero(pu)) break;
            double scalar = -pg / pu;
            x.add(1.0, scalar, p);
            if (iter == numberIterations - 1) break;
            g.add(1.0, scalar, u);
        }
        p.dispose();
        u.dispose();
        g.dispose();
        qa.dispose();
        monitor.report(1.0);
        return x;
    }

    public static Vect solve(VectConst data, VectConst referenceModel, LinearTransform linearTransform, boolean dampOnlyPerturbation, int conjugateGradIterations, Monitor monitor) {
        LinearTransformWrapper transform = new LinearTransformWrapper(linearTransform);
        VectConst perturbModel = null;
        TransformQuadratic transformQuadratic = new TransformQuadratic(data, referenceModel, perturbModel, transform, dampOnlyPerturbation);
        QuadraticSolver quadraticSolver = new QuadraticSolver(transformQuadratic);
        Vect result = quadraticSolver.solve(conjugateGradIterations, monitor);
        transformQuadratic.dispose();
        result.add(1.0, 1.0, referenceModel);
        return result;
    }

    private static void checkNaN(double value) {
        if (value * 0.0 != 0.0) {
            throw new IllegalStateException("Value is a NaN");
        }
    }
}

