/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.ArrayVect1;
import edu.mines.jtk.opt.Quadratic;
import edu.mines.jtk.opt.QuadraticSolver;
import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.util.Almost;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QuadraticSolverTest
extends TestCase {
    private static final String NL = System.getProperty("line.separator");

    public void testQS() {
        Quadratic q = new Quadratic(){

            @Override
            public void multiplyHessian(Vect x) {
                double[] data = ((ArrayVect1)x).getData();
                double[] newData = new double[data.length];
                newData[0] = 2.0 * data[0] + 4.0 * data[1];
                newData[1] = 4.0 * data[0] + 11.0 * data[1];
                data[0] = newData[0];
                data[1] = newData[1];
            }

            @Override
            public void inverseHessian(Vect x) {
            }

            @Override
            public Vect getB() {
                return new TestVect(new double[]{2.0, 1.0}, 1.0);
            }
        };
        QuadraticSolver qs = new QuadraticSolver(q);
        ArrayVect1 result = (ArrayVect1)qs.solve(1, null);
        assert (!Almost.FLOAT.equal(-3.0, result.getData()[0])) : "result=" + result;
        assert (!Almost.FLOAT.equal(1.0, result.getData()[1])) : "result=" + result;
        result.dispose();
        result = (ArrayVect1)qs.solve(2, null);
        assert (Almost.FLOAT.equal(-3.0, result.getData()[0])) : "result=" + result;
        assert (Almost.FLOAT.equal(1.0, result.getData()[1])) : "result=" + result;
        result.dispose();
        result = (ArrayVect1)qs.solve(20, null);
        assert (Almost.FLOAT.equal(-3.0, result.getData()[0])) : "result=" + result;
        assert (Almost.FLOAT.equal(1.0, result.getData()[1])) : "result=" + result;
        result.dispose();
        assert (TestVect.undisposed.size() == 0) : TestVect.getTraces();
        assert (TestVect.max <= 5) : "max number of model vectors (" + TestVect.max + ") should be less than 5";
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public QuadraticSolverTest(String name) {
        super(name);
    }

    public static Test suite() {
        try {
            assert (false);
            throw new IllegalStateException("need -ea");
        }
        catch (AssertionError assertionError) {
            return new TestSuite(QuadraticSolverTest.class);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)QuadraticSolverTest.suite());
    }

    private static class TestVect
    extends ArrayVect1 {
        private static final long serialVersionUID = 1L;
        public static int max = 0;
        public static Map<Object, String> undisposed = Collections.synchronizedMap(new HashMap());

        public TestVect(double[] data, double variance) {
            super(data, variance);
            this.remember(this);
        }

        @Override
        public TestVect clone() {
            TestVect result = (TestVect)super.clone();
            this.remember(result);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remember(Object tv) {
            Map<Object, String> map = undisposed;
            synchronized (map) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                new Exception("This vector was never disposed").printStackTrace(pw);
                pw.flush();
                undisposed.put(tv, sw.toString());
                max = Math.max(max, undisposed.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            Map<Object, String> map = undisposed;
            synchronized (map) {
                super.dispose();
                undisposed.remove(this);
            }
        }

        public static String getTraces() {
            StringBuilder sb = new StringBuilder();
            for (String s : undisposed.values()) {
                sb.append(s);
                sb.append(NL);
            }
            return sb.toString();
        }
    }
}

