/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.AxisTics;
import edu.mines.jtk.util.MathPlus;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AxisTicsTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(AxisTicsTest.class);
        TestRunner.run((Test)suite);
    }

    public void test180() {
        this.check(-180.0, 180.0, 4, 3, 100.0, -100.0, 37, 10.0, -180.0);
        this.check(-180.0, 180.0, 5, 3, 100.0, -100.0, 37, 10.0, -180.0);
        this.check(-180.0, 180.0, 6, 3, 100.0, -100.0, 37, 10.0, -180.0);
        this.check(-180.0, 180.0, 7, 7, 50.0, -150.0, 37, 10.0, -180.0);
        this.check(-180.0, 180.0, 8, 7, 50.0, -150.0, 37, 10.0, -180.0);
        this.check(-180.0, 180.0, 9, 7, 50.0, -150.0, 37, 10.0, -180.0);
    }

    public void testAll() {
        this.check(0.0, 10.0, 1.0, 11, 1.0, 0.0, 101, 0.1, 0.0);
        this.check(0.0, 10.0, 11, 11, 1.0, 0.0, 101, 0.1, 0.0);
        this.check(0.0, -10.0, 1.0, 11, 1.0, -10.0, 101, 0.1, -10.0);
        this.check(0.0, -10.0, 11, 11, 1.0, -10.0, 101, 0.1, -10.0);
        this.check(1.0, 10.0, 1.0, 10, 1.0, 1.0, 91, 0.1, 1.0);
        this.check(1.0, 10.0, 10, 10, 1.0, 1.0, 91, 0.1, 1.0);
        this.check(1.0, 10.0, 2.0, 5, 2.0, 2.0, 10, 1.0, 1.0);
        this.check(1.0, 10.0, 9, 5, 2.0, 2.0, 10, 1.0, 1.0);
        this.check(0.9, 10.1, 2.0, 5, 2.0, 2.0, 10, 1.0, 1.0);
        this.check(0.9, 10.1, 9, 5, 2.0, 2.0, 10, 1.0, 1.0);
    }

    private void check(double xmin, double xmax, double dtic, int nmajor, double dmajor, double fmajor, int nminor, double dminor, double fminor) {
        this.check(new AxisTics(xmin, xmax, dtic), nmajor, dmajor, fmajor, nminor, dminor, fminor);
    }

    private void check(double xmin, double xmax, int ntic, int nmajor, double dmajor, double fmajor, int nminor, double dminor, double fminor) {
        this.check(new AxisTics(xmin, xmax, ntic), nmajor, dmajor, fmajor, nminor, dminor, fminor);
    }

    private void check(AxisTics at, int nmajor, double dmajor, double fmajor, int nminor, double dminor, double fminor) {
        AxisTicsTest.assertEquals((int)nmajor, (int)at.getCountMajor());
        this.assertEquals(dmajor, at.getDeltaMajor());
        this.assertEquals(fmajor, at.getFirstMajor());
        AxisTicsTest.assertEquals((int)nminor, (int)at.getCountMinor());
        this.assertEquals(dminor, at.getDeltaMinor());
        this.assertEquals(fminor, at.getFirstMinor());
    }

    private void assertEquals(double e, double a) {
        double tiny = MathPlus.max(MathPlus.abs(e), MathPlus.abs(a)) * 100.0 * 2.220446049250313E-16;
        AxisTicsTest.assertEquals((double)e, (double)a, (double)tiny);
    }
}

