/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.Localize;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalizeTest
extends TestCase {
    private static final Logger LOG = Logger.getLogger(LocalizeTest.class.getName());

    public static void testLocalize() {
        Localize dfault = new Localize(LocalizeTest.class);
        String sDefault = dfault.format("msg1", 3.14, 42);
        assert ("A number 3.14000 here, and another #42".equals(sDefault)) : sDefault;
        Localize fr = new Localize(LocalizeTest.class, null, Locale.FRENCH);
        int i = 42;
        String sFr = fr.format("msg1", 3.14, 42);
        assert ("Un nombre 3,14000 ici, et un autre #42".equals(sFr) || "Un nombre 3.14000 ici, et un autre #42".equals(sFr)) : sFr;
        Localize alt = new Localize(LocalizeTest.class, "LocalizeTestAlt");
        String s = alt.format("msg1", 3.14, 42);
        assert ("A custom file with number 3.14000, and another #42".equals(s)) : s;
        alt = new Localize(LocalizeTest.class, "LocalizeTestAlt");
        s = alt.format("No property just a format with number %g.", 3.14);
        assert ("No property just a format with number 3.14000.".equals(s)) : s;
        alt = new Localize(LocalizeTest.class, "DoesNotExist");
        s = alt.format("A number %g.", 3.14);
        assert ("A number 3.14000.".equals(s)) : s;
        alt = new Localize(LocalizeTest.class);
        s = alt.format("Ignored number.", 3.14);
        assert ("Ignored number.".equals(s));
    }

    public static void testLocale() {
        assert (!Locale.getDefault().equals(Locale.FRANCE)) : "The testLocalize unit test does not work in France";
    }

    public static void testLocalizeThrowable() {
        IOException ioException = new IOException("ioe");
        assert ("ioe".equals(Localize.getMessage(ioException)));
        IllegalArgumentException e = new IllegalArgumentException(ioException);
        assert ("ioe".equals(Localize.getMessage(e)));
        String better = "Bad argument: " + ioException.getLocalizedMessage();
        IllegalArgumentException e2 = new IllegalArgumentException(better, ioException);
        assert (better.equals(Localize.getMessage(e2))) : Localize.getMessage(e2);
        e = new IllegalArgumentException(null, ioException);
        assert ("ioe".equals(Localize.getMessage(e)));
        e = new IllegalArgumentException("foo", ioException);
        assert ("foo".equals(Localize.getMessage(e)));
        e = new IllegalArgumentException("foo", null);
        assert ("foo".equals(Localize.getMessage(e)));
        e = new IllegalArgumentException();
        assert ("java.lang.IllegalArgumentException".equals(Localize.getMessage(e))) : Localize.getMessage(e);
        e = new IllegalArgumentException(null, null);
        assert ("java.lang.IllegalArgumentException".equals(Localize.getMessage(e))) : Localize.getMessage(e);
    }

    public static void testLocalizeOld() throws Exception {
        long seconds = 569L;
        String words = Localize.timeWords(seconds);
        assert (words.equals("9 minutes 29 seconds")) : words;
        seconds = 629L;
        words = Localize.timeWords(seconds);
        assert (words.equals("10 minutes")) : words;
        seconds = 630L;
        words = Localize.timeWords(seconds);
        assert (words.equals("11 minutes")) : words;
        seconds = 34169L;
        words = Localize.timeWords(seconds);
        assert (words.equals("9 hours 29 minutes")) : words;
        seconds = 34230L;
        words = Localize.timeWords(seconds);
        assert (words.equals("9 hours 31 minutes")) : words;
        seconds = 37830L;
        words = Localize.timeWords(seconds);
        assert (words.equals("11 hours")) : words;
        seconds = 819030L;
        words = Localize.timeWords(seconds);
        assert (words.equals("9 days 12 hours")) : words;
        seconds = 905430L;
        words = Localize.timeWords(seconds);
        assert (words.equals("10 days")) : words;
        seconds = 907200L;
        words = Localize.timeWords(seconds);
        assert (words.equals("11 days")) : words;
        seconds = 7200L;
        words = Localize.timeWords(seconds);
        assert (words.equals("2 hours")) : words;
        seconds = 7199L;
        words = Localize.timeWords(seconds);
        assert (words.equals("2 hours")) : words;
        seconds = 172800L;
        words = Localize.timeWords(seconds);
        assert (words.equals("2 days")) : words;
        seconds = 172799L;
        words = Localize.timeWords(seconds);
        assert (words.equals("2 days")) : words;
    }

    public LocalizeTest(String name) {
        super(name);
    }

    public static Test suite() {
        try {
            assert (false);
            throw new IllegalStateException("need -ea");
        }
        catch (AssertionError assertionError) {
            return new TestSuite(LocalizeTest.class);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LocalizeTest.suite());
    }
}

