/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.Parameter;
import edu.mines.jtk.util.ParameterSet;
import edu.mines.jtk.util.ParameterSetFormatException;
import edu.mines.jtk.util.StringParser;
import java.io.CharArrayWriter;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ParameterSetParser
extends DefaultHandler {
    private SAXParser _parser = null;
    private ParameterSet _ps_root = null;
    private ParameterSet _ps = null;
    private Parameter _p = null;
    private int _ptype = 0;
    private CharArrayWriter _pdata = new CharArrayWriter(256);

    public ParameterSetParser() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            this._parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("cannot create XML parser: " + e);
        }
        catch (SAXException e) {
            throw new RuntimeException("cannot create XML parser: " + e);
        }
    }

    public void parse(Reader reader, ParameterSet ps) throws ParameterSetFormatException {
        this._ps_root = ps;
        this._ps = null;
        this._p = null;
        this._ptype = 0;
        this._pdata.reset();
        try {
            this._parser.parse(new InputSource(reader), (DefaultHandler)this);
        }
        catch (ParameterSetFormatException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new ParameterSetFormatException("ParameterSetParser.parse: unknown error: " + e.getMessage() + ":" + e.toString());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws ParameterSetFormatException {
        if (qName.equals("parset")) {
            this.startParameterSet(attributes);
        } else if (qName.equals("par")) {
            this.startParameter(attributes);
        } else {
            throw new ParameterSetFormatException("ParameterSetParser.startElement: unrecognized XML element \"" + qName + "\"" + ".");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws ParameterSetFormatException {
        if (qName.equals("parset")) {
            this.endParameterSet();
        } else if (qName.equals("par")) {
            this.endParameter();
        } else {
            throw new ParameterSetFormatException("ParameterSetParser.endElement: unrecognized XML element \"" + qName + "\"" + ".");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this._p == null) {
            return;
        }
        this._pdata.write(ch, start, length);
    }

    @Override
    public void error(SAXParseException e) throws ParameterSetFormatException {
        String message = e.getMessage();
        int line = e.getLineNumber();
        int column = e.getColumnNumber();
        throw new ParameterSetFormatException("ParameterSetParser.error: " + message + " at line " + line + ", column " + column + ".");
    }

    private void startParameter(Attributes attributes) throws ParameterSetFormatException {
        String name = attributes.getValue("name");
        if (name == null) {
            throw new ParameterSetFormatException("parameter with no name");
        }
        if (this._ps == null) {
            throw new ParameterSetFormatException("<par name=\"" + name + "\" ...>" + " must be specified inside a parameter set.");
        }
        this._p = this._ps.addParameter(name);
        String units = attributes.getValue("units");
        this._p.setUnits(units);
        String type = attributes.getValue("type");
        this._ptype = type != null ? (type.equals("boolean") ? 1 : (type.equals("int") ? 2 : (type.equals("long") ? 3 : (type.equals("float") ? 4 : (type.equals("double") ? 5 : (type.equals("string") ? 6 : 6)))))) : 6;
    }

    private void endParameter() {
        this._p.setStrings(this.parseValues());
        this._p.setType(this._ptype);
        this._p = null;
        this._ptype = 0;
        this._pdata.reset();
    }

    private void startParameterSet(Attributes attributes) {
        String name = attributes.getValue("name");
        if (name == null) {
            throw new ParameterSetFormatException("parameter set with no name");
        }
        if (this._ps == null) {
            this._ps_root.setName(name);
            this._ps = this._ps_root;
        } else {
            this._ps = this._ps.addParameterSet(name);
        }
    }

    private void endParameterSet() {
        if (this._ps != this._ps_root) {
            this._ps = this._ps.getParent();
        }
    }

    private String[] parseValues() {
        StringParser sp = new StringParser(this._pdata.toString());
        ArrayList<String> vtemp = new ArrayList<String>(8);
        while (sp.hasMoreStrings()) {
            vtemp.add(sp.nextString());
        }
        String[] values = new String[vtemp.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (String)vtemp.get(i);
        }
        return values;
    }
}

