/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.Context;
import org.scijava.java3d.GeometryAtom;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.NodeComponentRetained;
import org.scijava.java3d.Pipeline;
import org.scijava.java3d.Shape3DRetained;
import org.scijava.java3d.VirtualUniverse;

class LineAttributesRetained
extends NodeComponentRetained {
    static final int LINE_WIDTH_CHANGED = 1;
    static final int LINE_PATTERN_CHANGED = 2;
    static final int LINE_AA_CHANGED = 4;
    static final int LINE_PATTERN_MASK_CHANGED = 8;
    static final int LINE_PATTERN_SCALEFACTOR_CHANGED = 16;
    float lineWidth = 1.0f;
    int linePattern = 0;
    boolean lineAntialiasing = false;
    int linePatternMask = 65535;
    int linePatternScaleFactor = 1;

    LineAttributesRetained() {
    }

    final void initLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    final void setLineWidth(float lineWidth) {
        this.initLineWidth(lineWidth);
        this.sendMessage(1, new Float(lineWidth));
    }

    final float getLineWidth() {
        return this.lineWidth;
    }

    final void initLinePattern(int linePattern) {
        this.linePattern = linePattern;
    }

    final void setLinePattern(int linePattern) {
        this.initLinePattern(linePattern);
        this.sendMessage(2, new Integer(linePattern));
    }

    final int getLinePattern() {
        return this.linePattern;
    }

    final void initLineAntialiasingEnable(boolean state) {
        this.lineAntialiasing = state;
    }

    final void setLineAntialiasingEnable(boolean state) {
        this.initLineAntialiasingEnable(state);
        this.sendMessage(4, state ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getLineAntialiasingEnable() {
        return this.lineAntialiasing;
    }

    final void initPatternMask(int mask) {
        this.linePatternMask = mask;
    }

    final void setPatternMask(int mask) {
        this.initPatternMask(mask);
        this.sendMessage(8, new Integer(mask));
    }

    final int getPatternMask() {
        return this.linePatternMask;
    }

    final void initPatternScaleFactor(int scaleFactor) {
        if (scaleFactor < 1) {
            scaleFactor = 1;
        } else if (scaleFactor > 15) {
            scaleFactor = 15;
        }
        this.linePatternScaleFactor = scaleFactor;
    }

    final void setPatternScaleFactor(int scaleFactor) {
        this.initPatternScaleFactor(scaleFactor);
        this.sendMessage(16, new Integer(scaleFactor));
    }

    final int getPatternScaleFactor() {
        return this.linePatternScaleFactor;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                LineAttributesRetained mirrorLa = new LineAttributesRetained();
                mirrorLa.source = this.source;
                mirrorLa.set(this);
                this.mirror = mirrorLa;
            }
        } else {
            ((LineAttributesRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context ctx) {
        Pipeline.getPipeline().updateLineAttributes(ctx, this.lineWidth, this.linePattern, this.linePatternMask, this.linePatternScaleFactor, this.lineAntialiasing);
    }

    @Override
    synchronized void initMirrorObject() {
        ((LineAttributesRetained)this.mirror).set(this);
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        LineAttributesRetained mirrorLa = (LineAttributesRetained)this.mirror;
        if ((component & 1) != 0) {
            mirrorLa.lineWidth = ((Float)value).floatValue();
        } else if ((component & 2) != 0) {
            mirrorLa.linePattern = (Integer)value;
        } else if ((component & 4) != 0) {
            mirrorLa.lineAntialiasing = (Boolean)value;
        } else if ((component & 8) != 0) {
            mirrorLa.linePatternMask = (Integer)value;
        } else if ((component & 0x10) != 0) {
            mirrorLa.linePatternScaleFactor = (Integer)value;
        }
    }

    boolean equivalent(LineAttributesRetained lr) {
        return lr != null && this.lineWidth == lr.lineWidth && this.linePattern == lr.linePattern && this.lineAntialiasing == lr.lineAntialiasing && this.linePatternMask == lr.linePatternMask && this.linePatternScaleFactor == lr.linePatternScaleFactor;
    }

    protected void set(LineAttributesRetained lr) {
        super.set(lr);
        this.lineWidth = lr.lineWidth;
        this.linePattern = lr.linePattern;
        this.linePatternScaleFactor = lr.linePatternScaleFactor;
        this.linePatternMask = lr.linePatternMask;
        this.lineAntialiasing = lr.lineAntialiasing;
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 7;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i = 0; i < univList.size(); ++i) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 7;
            createMessage.universe = univList.get(i);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 1 || bit == 3 || bit == 5) {
            this.setFrequencyChangeMask(bit, 1);
        }
    }
}

