/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.BoundingPolytope;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.GeometryRetained;
import org.scijava.java3d.GeometryStripArrayRetained;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.PickBounds;
import org.scijava.java3d.PickCone;
import org.scijava.java3d.PickCylinder;
import org.scijava.java3d.PickInfo;
import org.scijava.java3d.PickRay;
import org.scijava.java3d.PickSegment;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.Transform3D;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Tuple3d;
import org.scijava.vecmath.Vector3d;

class LineStripArrayRetained
extends GeometryStripArrayRetained {
    LineStripArrayRetained() {
        this.geoType = 7;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Point3d[] pnts = new Point3d[2];
        double[] sdist = new double[1];
        double minDist = Double.MAX_VALUE;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i = 0;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        int[] vtxIndexArr = new int[2];
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    vtxIndexArr[0] = j;
                    this.getVertexData(j++, pnts[0]);
                    while (j < end) {
                        vtxIndexArr[1] = j;
                        this.getVertexData(j++, pnts[1]);
                        if (this.intersectLineAndRay(pnts[0], pnts[1], pickRay.origin, pickRay.direction, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set((Tuple3d)pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                Vector3d dir = new Vector3d(pickSegment.end.x - pickSegment.start.x, pickSegment.end.y - pickSegment.start.y, pickSegment.end.z - pickSegment.start.z);
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    vtxIndexArr[0] = j;
                    this.getVertexData(j++, pnts[0]);
                    while (j < end) {
                        vtxIndexArr[1] = j;
                        this.getVertexData(j++, pnts[1]);
                        if (this.intersectLineAndRay(pnts[0], pnts[1], pickSegment.start, dir, sdist, iPnt) && sdist[0] <= 1.0) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set((Tuple3d)pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 6: {
                BoundingBox bbox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    vtxIndexArr[0] = j;
                    this.getVertexData(j++, pnts[0]);
                    while (j < end) {
                        vtxIndexArr[1] = j;
                        this.getVertexData(j++, pnts[1]);
                        if (this.intersectBoundingBox(pnts, bbox, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set((Tuple3d)pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    vtxIndexArr[0] = j;
                    this.getVertexData(j++, pnts[0]);
                    while (j < end) {
                        vtxIndexArr[1] = j;
                        this.getVertexData(j++, pnts[1]);
                        if (this.intersectBoundingSphere(pnts, bsphere, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set((Tuple3d)pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    vtxIndexArr[0] = j;
                    this.getVertexData(j++, pnts[0]);
                    while (j < end) {
                        vtxIndexArr[1] = j;
                        this.getVertexData(j++, pnts[1]);
                        if (this.intersectBoundingPolytope(pnts, bpolytope, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set((Tuple3d)pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    vtxIndexArr[0] = j;
                    this.getVertexData(j++, pnts[0]);
                    while (j < end) {
                        vtxIndexArr[1] = j;
                        this.getVertexData(j++, pnts[1]);
                        if (this.intersectCylinder(pnts, pickCylinder, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set((Tuple3d)pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    vtxIndexArr[0] = j;
                    this.getVertexData(j++, pnts[0]);
                    while (j < end) {
                        vtxIndexArr[1] = j;
                        this.getVertexData(j++, pnts[1]);
                        if (this.intersectCone(pnts, pickCone, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set((Tuple3d)pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("LineStripArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (minDist < Double.MAX_VALUE) {
            iPnt.x = x;
            iPnt.y = y;
            iPnt.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Point3d[] points = new Point3d[2];
        double[] dist = new double[1];
        int i = 0;
        points[0] = new Point3d();
        points[1] = new Point3d();
        switch (pnts.length) {
            case 3: 
            case 4: {
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, points[0]);
                    while (j < end) {
                        this.getVertexData(j++, points[1]);
                        if (this.intersectSegment(pnts, points[0], points[1], dist, null)) {
                            return true;
                        }
                        points[0].set((Tuple3d)points[1]);
                    }
                }
                break;
            }
            case 2: {
                Vector3d dir = new Vector3d();
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, points[0]);
                    while (j < end) {
                        this.getVertexData(j++, points[1]);
                        dir.x = points[1].x - points[0].x;
                        dir.y = points[1].y - points[0].y;
                        dir.z = points[1].z - points[0].z;
                        if (this.intersectLineAndRay(pnts[0], pnts[1], points[0], dir, dist, null) && dist[0] <= 1.0) {
                            return true;
                        }
                        points[0].set((Tuple3d)points[1]);
                    }
                }
                break;
            }
            case 1: {
                Vector3d dir = new Vector3d();
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, points[0]);
                    while (j < end) {
                        this.getVertexData(j++, points[1]);
                        dir.x = points[1].x - points[0].x;
                        dir.y = points[1].y - points[0].y;
                        dir.z = points[1].z - points[0].z;
                        if (this.intersectPntAndRay(pnts[0], points[0], dir, dist) && dist[0] <= 1.0) {
                            return true;
                        }
                        points[0].set((Tuple3d)points[1]);
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        int i = 0;
        Point3d[] pnts = new Point3d[]{new Point3d(), new Point3d()};
        while (i < this.stripVertexCounts.length) {
            int j = this.stripStartVertexIndices[i];
            int end = j + this.stripVertexCounts[i++];
            this.getVertexData(j++, pnts[0]);
            thisToOtherVworld.transform(pnts[0]);
            while (j < end) {
                this.getVertexData(j++, pnts[1]);
                thisToOtherVworld.transform(pnts[1]);
                if (geom.intersect(pnts)) {
                    return true;
                }
                pnts[0].set((Tuple3d)pnts[1]);
            }
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        int i = 0;
        Point3d[] pnts = new Point3d[]{new Point3d(), new Point3d()};
        switch (targetBound.getPickType()) {
            case 6: {
                BoundingBox box = (BoundingBox)targetBound;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, pnts[0]);
                    while (j < end) {
                        this.getVertexData(j++, pnts[1]);
                        if (this.intersectBoundingBox(pnts, box, null, null)) {
                            return true;
                        }
                        pnts[0].set((Tuple3d)pnts[1]);
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)targetBound;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, pnts[0]);
                    while (j < end) {
                        this.getVertexData(j++, pnts[1]);
                        if (this.intersectBoundingSphere(pnts, bsphere, null, null)) {
                            return true;
                        }
                        pnts[0].set((Tuple3d)pnts[1]);
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)targetBound;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, pnts[0]);
                    while (j < end) {
                        this.getVertexData(j++, pnts[1]);
                        if (this.intersectBoundingPolytope(pnts, bpolytope, null, null)) {
                            return true;
                        }
                        pnts[0].set((Tuple3d)pnts[1]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + targetBound);
            }
        }
        return false;
    }

    @Override
    void computeCentroid() {
        double length;
        int i = 0;
        double totallength = 0.0;
        Point3d pnt0 = new Point3d();
        Point3d pnt1 = new Point3d();
        this.centroid.x = 0.0;
        this.centroid.y = 0.0;
        this.centroid.z = 0.0;
        while (i < this.stripVertexCounts.length) {
            int j = this.stripStartVertexIndices[i];
            int end = j + this.stripVertexCounts[i++];
            this.getVertexData(j++, pnt0);
            boolean replaceVertex1 = true;
            while (j < end) {
                if (replaceVertex1) {
                    this.getVertexData(j++, pnt1);
                    replaceVertex1 = false;
                } else {
                    this.getVertexData(j++, pnt0);
                    replaceVertex1 = true;
                }
                length = pnt0.distance(pnt1);
                this.centroid.x += (pnt0.x + pnt1.x) * length;
                this.centroid.y += (pnt0.y + pnt1.y) * length;
                this.centroid.z += (pnt0.z + pnt1.z) * length;
                totallength += length;
            }
        }
        if (totallength != 0.0) {
            length = 1.0 / (2.0 * totallength);
            this.centroid.x *= length;
            this.centroid.y *= length;
            this.centroid.z *= length;
        }
    }

    @Override
    int getClassType() {
        return 2;
    }
}

