/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.Container;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mpicbg.models.AbstractModel;
import mpicbg.models.RigidModel3D;
import mpicbg.models.TranslationModel3D;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.interestpointregistration.InterestPointRegistration;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;
import spim.process.interestpointregistration.ChannelProcess;
import spim.process.interestpointregistration.centerofmass.CenterOfMass;
import spim.process.interestpointregistration.geometricdescriptor.RGLDM;
import spim.process.interestpointregistration.geometrichashing.GeometricHashing;
import spim.process.interestpointregistration.icp.IterativeClosestPoint;
import spim.process.interestpointregistration.optimizationtypes.AllToAllRegistration;
import spim.process.interestpointregistration.optimizationtypes.AllToAllRegistrationWithRange;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationSubset;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationType;
import spim.process.interestpointregistration.optimizationtypes.IndividualTimepointRegistration;
import spim.process.interestpointregistration.optimizationtypes.ReferenceTimepointRegistration;
import spim.process.interestpointregistration.registrationstatistics.RegistrationStatistics;
import spim.process.interestpointregistration.registrationstatistics.TimeLapseDisplay;

public class Interest_Point_Registration
implements PlugIn {
    public static ArrayList<InterestPointRegistration> staticAlgorithms = new ArrayList();
    public static String[] registrationTypes = new String[]{"Register timepoints individually", "Match against one reference timepoint (no global optimization)", "All-to-all timepoints matching (global optimization)", "All-to-all timepoints matching with range ('reasonable' global optimization)"};
    public static String[] fixTilesChoice = new String[]{"Fix first tile", "Select fixed tile", "Do not fix tiles"};
    public static String[] mapBackChoice = new String[]{"Do not map back (use this if tiles are fixed)", "Map back to first tile using translation model", "Map back to first tile using rigid model", "Map back to user defined tile using translation model", "Map back to user defined tile using rigid model"};
    public static int defaultAlgorithm = 0;
    public static int defaultRegistrationType = 0;
    public static int[] defaultChannelLabels = null;
    public static int defaultRange = 5;
    public static int defaultReferenceTimepointIndex = -1;
    public static boolean defaultConsiderTimepointAsUnit = false;
    public static int defaultFixTiles = 0;
    public static int defaultMapBack = 0;
    public static boolean defaultSameFixedViews = true;
    public static boolean defaultSameReferenceView = true;
    public static boolean[] defaultFixedTiles = null;
    public static int defaultReferenceTile = 0;
    public static boolean defaultShowStatistics = true;
    public static final String warningLabel = " (WARNING: Only available for ";

    public void run(String arg) {
        LoadParseQueryXML result = new LoadParseQueryXML();
        if (!result.queryXML("for performing interest point registration", true, false, true, true)) {
            return;
        }
        this.register((SpimData2)((Object)result.getData()), SpimData2.getAllViewIdsSorted((SpimData)result.getData(), result.getViewSetupsToProcess(), result.getTimePointsToProcess()), result.getClusterExtension(), result.getXMLFileName(), true);
    }

    public boolean register(SpimData2 data, List<ViewId> viewIds) {
        return this.register(data, viewIds, "", null, false);
    }

    public boolean register(SpimData2 data, List<ViewId> viewIds, String xmlFileName, boolean saveXML) {
        return this.register(data, viewIds, "", xmlFileName, saveXML);
    }

    public boolean register(SpimData2 data, List<ViewId> viewIds, String clusterExtension, String xmlFileName, boolean saveXML) {
        boolean showStatistics;
        int mapBack;
        int fixTiles;
        RegistrationType registrationType;
        int globalAmountTimepoints;
        String[] descriptions = new String[staticAlgorithms.size()];
        for (int i = 0; i < staticAlgorithms.size(); ++i) {
            descriptions[i] = staticAlgorithms.get(i).getDescription();
        }
        if (defaultAlgorithm >= descriptions.length) {
            defaultAlgorithm = 0;
        }
        ArrayList<TimePoint> timepointToProcess = SpimData2.getAllTimePointsSorted(data, viewIds);
        ArrayList<Channel> channels = SpimData2.getAllChannelsSorted(data, viewIds);
        int nAllChannels = ((SequenceDescription)data.getSequenceDescription()).getAllChannelsOrdered().size();
        GenericDialog gd = new GenericDialog("Basic Registration Parameters");
        gd.addChoice("Registration_algorithm", descriptions, descriptions[defaultAlgorithm]);
        String[] choicesGlobal = timepointToProcess.size() > 1 ? (String[])registrationTypes.clone() : ((globalAmountTimepoints = ((SequenceDescription)data.getSequenceDescription()).getTimePoints().size()) > 1 ? new String[]{registrationTypes[0], registrationTypes[1]} : new String[]{registrationTypes[0]});
        if (defaultRegistrationType >= choicesGlobal.length) {
            defaultRegistrationType = 0;
        }
        gd.addChoice("Type_of_registration", choicesGlobal, choicesGlobal[defaultRegistrationType]);
        if (defaultChannelLabels == null || defaultChannelLabels.length != nAllChannels) {
            defaultChannelLabels = new int[nAllChannels];
        }
        ArrayList<String[]> channelLabels = new ArrayList<String[]>();
        int i = 0;
        for (Channel channel : channels) {
            String[] labels = Interest_Point_Registration.getAllInterestPointLabelsForChannel(data, viewIds, channel, "register");
            if (defaultChannelLabels[channel.getId()] >= labels.length) {
                Interest_Point_Registration.defaultChannelLabels[channel.getId()] = 0;
            }
            gd.addChoice("Interest_points_channel_" + channel.getName(), labels, labels[defaultChannelLabels[i++]]);
            channelLabels.add(labels);
        }
        HashMap<String, Integer> names = GUIHelper.assembleRegistrationNames(data, viewIds);
        gd.addMessage("");
        GUIHelper.displayRegistrationNames(gd, names);
        gd.addMessage("");
        GUIHelper.addWebsite(gd);
        if (names.keySet().size() > 5) {
            GUIHelper.addScrollBars((Container)gd);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int algorithm = defaultAlgorithm = gd.getNextChoiceIndex();
        defaultRegistrationType = gd.getNextChoiceIndex();
        switch (defaultRegistrationType) {
            case 0: {
                registrationType = RegistrationType.TIMEPOINTS_INDIVIDUALLY;
                break;
            }
            case 1: {
                registrationType = RegistrationType.TO_REFERENCE_TIMEPOINT;
                break;
            }
            case 2: {
                registrationType = RegistrationType.ALL_TO_ALL;
                break;
            }
            case 3: {
                registrationType = RegistrationType.ALL_TO_ALL_WITH_RANGE;
                break;
            }
            default: {
                return false;
            }
        }
        ArrayList<ChannelProcess> channelsToProcess = new ArrayList<ChannelProcess>();
        i = 0;
        for (Channel channel : channels) {
            Interest_Point_Registration.defaultChannelLabels[channel.getId()] = gd.getNextChoiceIndex();
            int channelChoice = Interest_Point_Registration.defaultChannelLabels[channel.getId()];
            if (channelChoice < ((String[])channelLabels.get(i)).length - 1) {
                String label = ((String[])channelLabels.get(i))[channelChoice];
                if (label.contains(warningLabel)) {
                    label = label.substring(0, label.indexOf(warningLabel));
                }
                channelsToProcess.add(new ChannelProcess(channel, label));
            }
            ++i;
        }
        if (channelsToProcess.size() == 0) {
            IOFunctions.println("No channels selected. Quitting.");
            return false;
        }
        for (ChannelProcess c : channelsToProcess) {
            IOFunctions.println("registering channel: " + c.getChannel().getId() + " label: '" + c.getLabel() + "'");
        }
        InterestPointRegistration ipr = staticAlgorithms.get(algorithm).newInstance(data, viewIds, channelsToProcess);
        IOFunctions.println("Registration algorithm: " + ipr.getDescription());
        IOFunctions.println("Registration type: " + registrationType.name());
        IOFunctions.println("Channels to process: " + channelsToProcess.size());
        GenericDialog gd2 = new GenericDialog("Register: " + registrationTypes[registrationType.ordinal()]);
        if (registrationType == RegistrationType.TO_REFERENCE_TIMEPOINT) {
            String[] tpList = Interest_Point_Registration.assembleTimepoints(((SequenceDescription)data.getSequenceDescription()).getTimePoints());
            if (defaultReferenceTimepointIndex < 0 || defaultReferenceTimepointIndex >= tpList.length) {
                defaultReferenceTimepointIndex = 0;
            }
            gd2.addChoice("Reference timepoint", tpList, tpList[defaultReferenceTimepointIndex]);
            gd2.addMessage("");
        } else if (registrationType == RegistrationType.ALL_TO_ALL_WITH_RANGE) {
            gd2.addSlider("Range for all-to-all timepoint matching", 2.0, 10.0, (double)defaultRange);
        }
        if (registrationType != RegistrationType.TIMEPOINTS_INDIVIDUALLY) {
            gd2.addCheckbox("Consider_each_timepoint_as_rigid_unit", defaultConsiderTimepointAsUnit);
            gd2.addMessage("Note: This option applies the same transformation model to all views of one timepoint. This makes for example\nsense if all timepoints are individually pre-registered using an affine transformation model, and for the timeseries\nstabilization a translation model should be used.\n ", GUIHelper.smallStatusFont);
        }
        if (registrationType != RegistrationType.TO_REFERENCE_TIMEPOINT) {
            gd2.addChoice("Fix_tiles", fixTilesChoice, fixTilesChoice[defaultFixTiles]);
            gd2.addChoice("Map_back_tiles", mapBackChoice, mapBackChoice[defaultMapBack]);
        }
        gd2.addMessage("");
        gd2.addMessage("Algorithm parameters [" + ipr.getDescription() + "]", new Font("SansSerif", 1, 12));
        gd2.addMessage("");
        ipr.addQuery(gd2, registrationType);
        if (timepointToProcess.size() > 1) {
            gd2.addCheckbox("Show_timeseries_statistics", defaultShowStatistics);
        }
        gd2.showDialog();
        if (gd2.wasCanceled()) {
            return false;
        }
        int referenceTimePoint = ((TimePoint)((SequenceDescription)data.getSequenceDescription()).getTimePoints().getTimePointsOrdered().get(0)).getId();
        int range = defaultRange;
        if (registrationType == RegistrationType.TO_REFERENCE_TIMEPOINT) {
            defaultReferenceTimepointIndex = gd2.getNextChoiceIndex();
            referenceTimePoint = ((TimePoint)((SequenceDescription)data.getSequenceDescription()).getTimePoints().getTimePointsOrdered().get(defaultReferenceTimepointIndex)).getId();
            boolean contains = false;
            for (ViewId viewId : viewIds) {
                if (viewId.getTimePointId() != referenceTimePoint) continue;
                contains = true;
            }
            if (!contains) {
                IOFunctions.println("No views of the reference timepoint are part of the registration.");
                IOFunctions.println("Please re-run and select the corresponding views that should be used as reference.");
                return false;
            }
        }
        if (registrationType == RegistrationType.ALL_TO_ALL_WITH_RANGE) {
            range = defaultRange = (int)Math.round(gd2.getNextNumber());
        }
        boolean considerTimepointsAsUnit = registrationType != RegistrationType.TIMEPOINTS_INDIVIDUALLY ? (defaultConsiderTimepointAsUnit = gd2.getNextBoolean()) : false;
        if (registrationType != RegistrationType.TO_REFERENCE_TIMEPOINT) {
            fixTiles = defaultFixTiles = gd2.getNextChoiceIndex();
            mapBack = defaultMapBack = gd2.getNextChoiceIndex();
        } else {
            mapBack = -1;
            fixTiles = -1;
        }
        if (!ipr.parseDialog(gd2, registrationType)) {
            return false;
        }
        if (timepointToProcess.size() > 1) {
            defaultShowStatistics = showStatistics = gd2.getNextBoolean();
        } else {
            showStatistics = false;
        }
        GlobalOptimizationType type = registrationType == RegistrationType.TIMEPOINTS_INDIVIDUALLY ? new IndividualTimepointRegistration(data, viewIds, channelsToProcess) : (registrationType == RegistrationType.TO_REFERENCE_TIMEPOINT ? new ReferenceTimepointRegistration(data, viewIds, channelsToProcess, (TimePoint)((SequenceDescription)data.getSequenceDescription()).getTimePoints().getTimePoints().get(referenceTimePoint), considerTimepointsAsUnit) : (registrationType == RegistrationType.ALL_TO_ALL ? new AllToAllRegistration(data, viewIds, channelsToProcess, considerTimepointsAsUnit) : (registrationType == RegistrationType.ALL_TO_ALL_WITH_RANGE ? new AllToAllRegistrationWithRange(data, viewIds, channelsToProcess, range, considerTimepointsAsUnit) : null)));
        if (!this.setFixedTilesAndReference(fixTiles, mapBack, type)) {
            return false;
        }
        if (!ipr.register(type, saveXML, showStatistics)) {
            return false;
        }
        if (saveXML) {
            SpimData2.saveXML(data, xmlFileName, clusterExtension);
        }
        if (showStatistics) {
            ArrayList<RegistrationStatistics> rsData = new ArrayList<RegistrationStatistics>();
            for (TimePoint t : timepointToProcess) {
                rsData.add(new RegistrationStatistics(t.getId(), ipr.getStatistics()));
            }
            TimeLapseDisplay.plotData(((SequenceDescription)data.getSequenceDescription()).getTimePoints(), rsData, TimeLapseDisplay.getOptimalTimePoint(rsData), true);
        }
        return true;
    }

    public boolean setFixedTilesAndReference(int fixTilesIndex, int mapBackIndex, GlobalOptimizationType type) {
        GenericDialog gd2;
        ArrayList<ViewSetup> setupList;
        Object gd1;
        List<GlobalOptimizationSubset> subsets = type.getAllViewPairs();
        HashSet<ViewId> fixedTiles = new HashSet<ViewId>();
        if (fixTilesIndex == 0) {
            for (GlobalOptimizationSubset subset : subsets) {
                if (subset.getViews().size() == 0) {
                    IOFunctions.println("Nothing to do for: " + subset.getDescription() + ". No tiles fixed.");
                    continue;
                }
                fixedTiles.add(subset.getViews().get(0));
            }
        } else if (fixTilesIndex == 1) {
            if (subsets.size() > 1) {
                gd1 = new GenericDialog("Type of manual choice");
                gd1.addCheckbox("Same_fixed_view(s) for each timepoint", defaultSameFixedViews);
                gd1.showDialog();
                if (gd1.wasCanceled()) {
                    return false;
                }
                defaultSameFixedViews = gd1.getNextBoolean();
                if (defaultSameFixedViews) {
                    int i;
                    setupList = this.getListOfViewSetupPresentInAllSubsets(subsets, type);
                    if (setupList.size() == 0) {
                        IOFunctions.println("No Viewsetup is available in all Timepoints.");
                        return false;
                    }
                    if (defaultFixedTiles == null || defaultFixedTiles.length != setupList.size()) {
                        defaultFixedTiles = new boolean[setupList.size()];
                    }
                    gd2 = new GenericDialog("Select ViewSetups to be fixed for each of the timepoints");
                    for (i = 0; i < setupList.size(); ++i) {
                        ViewSetup vs = (ViewSetup)setupList.get(i);
                        gd2.addCheckbox("Angle_" + vs.getAngle().getName() + "_Channel_" + vs.getChannel().getName() + "_Illum_" + vs.getIllumination().getName(), defaultFixedTiles[i]);
                    }
                    GUIHelper.addScrollBars((Container)gd2);
                    gd2.showDialog();
                    if (gd2.wasCanceled()) {
                        return false;
                    }
                    for (i = 0; i < setupList.size(); ++i) {
                        Interest_Point_Registration.defaultFixedTiles[i] = gd2.getNextBoolean();
                        if (!Interest_Point_Registration.defaultFixedTiles[i]) continue;
                        for (GlobalOptimizationSubset subset : subsets) {
                            fixedTiles.add(new ViewId(subset.getViews().get(0).getTimePointId(), ((ViewSetup)setupList.get(i)).getId()));
                        }
                    }
                } else {
                    for (GlobalOptimizationSubset subset : subsets) {
                        if (this.askForFixedTiles(subset, type, fixedTiles, "Select fixed ViewIds for timepoint " + subset.getViews().get(0).getTimePointId())) continue;
                        return false;
                    }
                }
            } else if (!this.askForFixedTiles(subsets.get(0), type, fixedTiles, "Select fixed ViewIds")) {
                return false;
            }
        }
        if (fixTilesIndex >= 0) {
            type.setFixedTiles(fixedTiles);
        }
        IOFunctions.println("Following tiles are fixed:");
        for (ViewId id : type.getFixedTiles()) {
            ViewDescription vd = ((SequenceDescription)type.getSpimData().getSequenceDescription()).getViewDescription(id);
            ViewSetup vs = (ViewSetup)vd.getViewSetup();
            IOFunctions.println("Angle:" + vs.getAngle().getName() + " Channel:" + vs.getChannel().getName() + " Illum:" + vs.getIllumination().getName() + " TimePoint:" + vd.getTimePoint().getId());
        }
        if (mapBackIndex == 0) {
            type.setMapBackModel(null);
            type.setMapBackReferenceTiles(new HashMap<GlobalOptimizationSubset, ViewId>());
        } else if (mapBackIndex == 1 || mapBackIndex == 3) {
            type.setMapBackModel((AbstractModel<?>)new TranslationModel3D());
        } else {
            type.setMapBackModel((AbstractModel<?>)new RigidModel3D());
        }
        if (mapBackIndex == 1 || mapBackIndex == 2) {
            for (GlobalOptimizationSubset subset : subsets) {
                type.setMapBackReferenceTile(subset, subset.getViews().get(0));
            }
        } else if (mapBackIndex == 3 || mapBackIndex == 4) {
            if (subsets.size() > 1) {
                gd1 = new GenericDialog("Type of manual choice");
                gd1.addCheckbox("Same_reference_view(s) for each timepoint", defaultSameReferenceView);
                gd1.showDialog();
                if (gd1.wasCanceled()) {
                    return false;
                }
                defaultSameReferenceView = gd1.getNextBoolean();
                if (defaultSameReferenceView) {
                    setupList = this.getListOfViewSetupPresentInAllSubsets(subsets, type);
                    if (setupList.size() == 0) {
                        IOFunctions.println("No Viewsetup is available in all Timepoints.");
                        return false;
                    }
                    gd2 = new GenericDialog("Select Reference ViewSetup each of the timepoints");
                    String[] choices = new String[setupList.size()];
                    for (int i = 0; i < setupList.size(); ++i) {
                        ViewSetup vs = (ViewSetup)setupList.get(i);
                        choices[i] = "Angle_" + vs.getAngle().getName() + "_Channel_" + vs.getChannel().getName() + "_Illum_" + vs.getIllumination().getName();
                    }
                    if (defaultReferenceTile >= choices.length) {
                        defaultReferenceTile = 0;
                    }
                    gd2.addChoice("Select_Reference_ViewSetup", choices, choices[defaultReferenceTile]);
                    gd2.showDialog();
                    if (gd2.wasCanceled()) {
                        return false;
                    }
                    int index = defaultReferenceTile = gd2.getNextChoiceIndex();
                    for (GlobalOptimizationSubset subset : subsets) {
                        type.setMapBackReferenceTile(subset, new ViewId(subset.getViews().get(0).getTimePointId(), ((ViewSetup)setupList.get(index)).getId()));
                    }
                } else {
                    for (GlobalOptimizationSubset subset : subsets) {
                        if (this.askForReferenceTile(subset, type, "Select Reference Views")) continue;
                        return false;
                    }
                }
            } else if (!this.askForReferenceTile(subsets.get(0), type, "Select Reference View")) {
                return false;
            }
        }
        IOFunctions.println("Following tiles are reference tiles (for mapping back if there are no fixed tiles):");
        for (GlobalOptimizationSubset subset : subsets) {
            ViewId id = type.getMapBackReferenceTile(subset);
            if (id == null) continue;
            ViewDescription vd = ((SequenceDescription)type.getSpimData().getSequenceDescription()).getViewDescription(id);
            ViewSetup vs = (ViewSetup)vd.getViewSetup();
            IOFunctions.println("Angle:" + vs.getAngle().getName() + " Channel:" + vs.getChannel().getName() + " Illum:" + vs.getIllumination().getName() + " TimePoint:" + vd.getTimePoint().getId());
        }
        return true;
    }

    protected boolean askForReferenceTile(GlobalOptimizationSubset subset, GlobalOptimizationType type, String title) {
        GenericDialog gd = new GenericDialog(title);
        String[] choice = new String[subset.getViews().size()];
        for (int i = 0; i < choice.length; ++i) {
            ViewSetup vs = (ViewSetup)((SequenceDescription)type.getSpimData().getSequenceDescription()).getViewDescription(subset.getViews().get(i)).getViewSetup();
            choice[i] = "Angle:" + vs.getAngle().getName() + " Channel:" + vs.getChannel().getName() + " Illum:" + vs.getIllumination().getName() + " Timepoint:" + subset.getViews().get(i).getTimePointId();
        }
        if (defaultReferenceTile >= choice.length) {
            defaultReferenceTile = 0;
        }
        gd.addChoice(title.replace(" ", "_"), choice, choice[defaultReferenceTile]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        defaultReferenceTile = gd.getNextChoiceIndex();
        type.setMapBackReferenceTile(subset, subset.getViews().get(defaultReferenceTile));
        return true;
    }

    protected boolean askForFixedTiles(GlobalOptimizationSubset subset, GlobalOptimizationType type, Set<ViewId> fixedTiles, String title) {
        int i;
        GenericDialog gd = new GenericDialog(title);
        if (defaultFixedTiles == null || defaultFixedTiles.length != subset.getViews().size()) {
            defaultFixedTiles = new boolean[subset.getViews().size()];
        }
        for (i = 0; i < subset.getViews().size(); ++i) {
            ViewId viewId = subset.getViews().get(i);
            ViewSetup vs = (ViewSetup)((SequenceDescription)type.getSpimData().getSequenceDescription()).getViewDescription(viewId).getViewSetup();
            gd.addCheckbox("Angle_" + vs.getAngle().getName() + "_Channel_" + vs.getChannel().getName() + "_Illum_" + vs.getIllumination().getName() + "_Timepoint_" + viewId.getTimePointId(), defaultFixedTiles[i]);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        for (i = 0; i < subset.getViews().size(); ++i) {
            Interest_Point_Registration.defaultFixedTiles[i] = gd.getNextBoolean();
            if (!Interest_Point_Registration.defaultFixedTiles[i]) continue;
            fixedTiles.add(subset.getViews().get(i));
        }
        return true;
    }

    protected ArrayList<ViewSetup> getListOfViewSetupPresentInAllSubsets(List<GlobalOptimizationSubset> subsets, GlobalOptimizationType type) {
        HashMap<Integer, Integer> viewsetups = new HashMap<Integer, Integer>();
        for (GlobalOptimizationSubset subset : subsets) {
            for (ViewId viewId : subset.getViews()) {
                if (viewsetups.containsKey(viewId.getViewSetupId())) {
                    viewsetups.put(viewId.getViewSetupId(), (Integer)viewsetups.get(viewId.getViewSetupId()) + 1);
                    continue;
                }
                viewsetups.put(viewId.getViewSetupId(), 1);
            }
        }
        ArrayList<ViewSetup> setupList = new ArrayList<ViewSetup>();
        Iterator iterator = viewsetups.keySet().iterator();
        while (iterator.hasNext()) {
            int viewSetupId = (Integer)iterator.next();
            if (((Integer)viewsetups.get(viewSetupId)).intValue() != subsets.size()) continue;
            setupList.add((ViewSetup)((SequenceDescription)type.getSpimData().getSequenceDescription()).getViewSetups().get(viewSetupId));
        }
        Collections.sort(setupList);
        return setupList;
    }

    public static String[] getAllInterestPointLabelsForChannel(SpimData2 spimData, List<ViewId> viewIdsToProcess, Channel channel) {
        return Interest_Point_Registration.getAllInterestPointLabelsForChannel(spimData, viewIdsToProcess, channel, null);
    }

    public static String[] getAllInterestPointLabelsForChannel(SpimData2 spimData, List<ViewId> viewIdsToProcess, Channel channel, String doWhat) {
        ViewInterestPoints interestPoints = spimData.getViewInterestPoints();
        HashMap<String, Integer> labels = new HashMap<String, Integer>();
        int countViewDescriptions = 0;
        for (ViewId viewId : viewIdsToProcess) {
            ViewDescription viewDescription = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(viewId.getTimePointId(), viewId.getViewSetupId());
            if (!viewDescription.isPresent() || ((ViewSetup)viewDescription.getViewSetup()).getChannel().getId() != channel.getId()) continue;
            ViewInterestPointLists lists = interestPoints.getViewInterestPointLists(viewId);
            for (String label : lists.getHashMap().keySet()) {
                int count = 1;
                if (labels.containsKey(label)) {
                    count += ((Integer)labels.get(label)).intValue();
                }
                labels.put(label, count);
            }
            ++countViewDescriptions;
        }
        String[] allLabels = doWhat == null ? new String[labels.keySet().size()] : new String[labels.keySet().size() + 1];
        int i = 0;
        Iterator iterator = labels.keySet().iterator();
        while (iterator.hasNext()) {
            String label;
            allLabels[i] = label = (String)iterator.next();
            if ((Integer)labels.get(label) != countViewDescriptions) {
                int n = i;
                allLabels[n] = allLabels[n] + warningLabel + labels.get(label) + "/" + countViewDescriptions + " Views!)";
            }
            ++i;
        }
        if (doWhat != null) {
            allLabels[i] = "(DO NOT " + doWhat + " this channel)";
        }
        return allLabels;
    }

    protected static String[] assembleTimepoints(TimePoints timepoints) {
        String[] tps = new String[timepoints.size()];
        for (int t = 0; t < tps.length; ++t) {
            tps[t] = ((TimePoint)timepoints.getTimePointsOrdered().get(t)).getName();
        }
        return tps;
    }

    public static void main(String[] args) {
        LoadParseQueryXML.defaultXMLfilename = "/Users/preibischs/Downloads/worm7bugtester/worm7.xml";
        new ImageJ();
        new Interest_Point_Registration().run(null);
    }

    static {
        IOFunctions.printIJLog = true;
        staticAlgorithms.add(new GeometricHashing(null, null, null));
        staticAlgorithms.add(new RGLDM(null, null, null));
        staticAlgorithms.add(new CenterOfMass(null, null, null));
        staticAlgorithms.add(new IterativeClosestPoint(null, null, null));
    }

    public static enum RegistrationType {
        TIMEPOINTS_INDIVIDUALLY,
        TO_REFERENCE_TIMEPOINT,
        ALL_TO_ALL,
        ALL_TO_ALL_WITH_RANGE;

    }
}

