/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import fiji.util.gui.GenericDialogPlus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.util.ArrayList;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.cluster.MergeClusterJobs;
import spim.fiji.plugin.queryXML.GenericLoadParseQueryXML;
import spim.fiji.plugin.util.GUIHelper;

public class Merge_Cluster_Jobs
implements PlugIn {
    public static String defaultContains1 = "job_";
    public static String defaultContains2 = ".xml";
    public static String defaultNewXML = "dataset_merged.xml";
    public static String defaultMergeXMLDir = null;
    public static boolean defaultDeleteXMLs = false;
    public static boolean defaultDisplayXMLs = true;
    public static boolean ignoreTileFiles = true;
    Color color = GUIHelper.neutral;
    String message = "---";
    ArrayList<File> xmls = new ArrayList();

    public void run(String arg0) {
        GenericDialogPlus gd = new GenericDialogPlus("Select XML's to Merge");
        if (defaultMergeXMLDir == null) {
            defaultMergeXMLDir = new File(GenericLoadParseQueryXML.defaultXMLfilename).getParent();
        }
        gd.addDirectoryField("Directory", defaultMergeXMLDir, 50);
        gd.addStringField("Filename_contains", defaultContains1);
        gd.addStringField("Filename_also_contains", defaultContains2);
        TextField directory = (TextField)gd.getStringFields().firstElement();
        TextField contains1 = (TextField)gd.getStringFields().get(1);
        TextField contains2 = (TextField)gd.getStringFields().get(2);
        gd.addStringField("Merged_XML", defaultNewXML, 50);
        gd.addCheckbox("Display currently selected XML's in log window", defaultDisplayXMLs);
        Checkbox display = (Checkbox)gd.getCheckboxes().firstElement();
        gd.addCheckbox("Delete_XML's after successful merge", defaultDeleteXMLs);
        this.findFiles(new File(directory.getText()), contains1.getText(), contains2.getText(), defaultDisplayXMLs);
        gd.addMessage("");
        gd.addMessage(this.message, GUIHelper.largestatusfont, this.color);
        Label target = (Label)gd.getMessage();
        this.addListeners((GenericDialog)gd, directory, contains1, contains2, display, target);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String dir = defaultMergeXMLDir = gd.getNextString();
        String cont1 = defaultContains1 = gd.getNextString();
        String cont2 = defaultContains2 = gd.getNextString();
        defaultDisplayXMLs = gd.getNextBoolean();
        boolean delete = defaultDeleteXMLs = gd.getNextBoolean();
        defaultNewXML = gd.getNextString();
        File newXML = new File(dir, defaultNewXML);
        IOFunctions.println("Attempting to merge the following XML's in directory '" + dir + "':");
        this.findFiles(new File(dir), cont1, cont2, false);
        for (File f : this.xmls) {
            IOFunctions.println("  " + f.getAbsolutePath());
        }
        try {
            MergeClusterJobs.merge(this.xmls, newXML);
            IOFunctions.println("Successfully merged all XML's into one new XML: " + newXML.getAbsolutePath());
            if (delete) {
                IOFunctions.println("Deleting all input XML's.");
                for (File f : this.xmls) {
                    f.delete();
                }
                IOFunctions.println("Done.");
            }
        }
        catch (SpimDataException e) {
            IOFunctions.println("Failed to merge XML's: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    protected void addListeners(GenericDialog gd, final TextField directory, final TextField contains1, final TextField contains2, final Checkbox display, final Label label) {
        directory.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent t) {
                if (t.getID() == 900) {
                    Merge_Cluster_Jobs.this.findFiles(new File(directory.getText()), contains1.getText(), contains2.getText(), display.getState());
                    Merge_Cluster_Jobs.this.update(label);
                }
            }
        });
        contains1.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent t) {
                if (t.getID() == 900) {
                    Merge_Cluster_Jobs.this.findFiles(new File(directory.getText()), contains1.getText(), contains2.getText(), display.getState());
                    Merge_Cluster_Jobs.this.update(label);
                }
            }
        });
        contains2.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent t) {
                if (t.getID() == 900) {
                    Merge_Cluster_Jobs.this.findFiles(new File(directory.getText()), contains1.getText(), contains2.getText(), display.getState());
                    Merge_Cluster_Jobs.this.update(label);
                }
            }
        });
        display.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent i) {
                if (i.getID() == 701) {
                    Merge_Cluster_Jobs.this.findFiles(new File(directory.getText()), contains1.getText(), contains2.getText(), display.getState());
                    Merge_Cluster_Jobs.this.update(label);
                }
            }
        });
    }

    protected void update(Label label) {
        label.setText(this.message);
        label.setForeground(this.color);
    }

    protected void findFiles(File dir, String contains1, String contains2, boolean display) {
        this.xmls.clear();
        if (!dir.isDirectory()) {
            this.message = "Path provided is not a directory.";
            this.color = GUIHelper.error;
        } else {
            for (String file : dir.list()) {
                if (ignoreTileFiles) {
                    if (!file.contains(contains1) || !file.contains(contains2) || file.contains("~")) continue;
                    this.xmls.add(new File(dir, file));
                    continue;
                }
                if (!file.contains(contains1) || !file.contains(contains2)) continue;
                this.xmls.add(new File(dir, file));
            }
            if (this.xmls.size() == 0) {
                this.message = "No files found that match the name pattern.";
                this.color = GUIHelper.warning;
            } else {
                this.message = "Found " + this.xmls.size() + " files that match the name pattern.";
                this.color = GUIHelper.good;
                if (display) {
                    IOFunctions.println("Currently selected XML's: ");
                    for (File f : this.xmls) {
                        IOFunctions.println("  " + f.getAbsolutePath());
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        new Merge_Cluster_Jobs().run(null);
    }
}

