/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.lut;

import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.transform.InvertibleTransform;
import org.janelia.thickness.lut.AbstractPerumtationTransform;

public class PermutationTransform
extends AbstractPerumtationTransform {
    protected final int numSourceDimensions;
    protected final int numTargetDimensions;

    public PermutationTransform(int[] lut, int numSourceDimensions, int numTargetDimensions) {
        super(lut);
        this.numSourceDimensions = numSourceDimensions;
        this.numTargetDimensions = numTargetDimensions;
    }

    public int numSourceDimensions() {
        return this.numSourceDimensions;
    }

    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }

    public void apply(long[] source, long[] target) {
        assert (source.length >= this.numTargetDimensions && target.length >= this.numTargetDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = this.apply((int)source[d]);
        }
    }

    public void apply(int[] source, int[] target) {
        assert (source.length >= this.numTargetDimensions && target.length >= this.numTargetDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = this.apply(this.lut[source[d]]);
        }
    }

    public void apply(Localizable source, Positionable target) {
        assert (source.numDimensions() >= this.numTargetDimensions && target.numDimensions() >= this.numTargetDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target.setPosition(this.apply(source.getIntPosition(d)), d);
        }
    }

    public void applyInverse(long[] source, long[] target) {
        assert (source.length >= this.numSourceDimensions && target.length >= this.numSourceDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numSourceDimensions; ++d) {
            source[d] = this.applyInverse((int)target[d]);
        }
    }

    public void applyInverse(int[] source, int[] target) {
        assert (source.length >= this.numSourceDimensions && target.length >= this.numSourceDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numSourceDimensions; ++d) {
            source[d] = this.applyInverse(target[d]);
        }
    }

    public void applyInverse(Positionable source, Localizable target) {
        assert (source.numDimensions() >= this.numSourceDimensions && target.numDimensions() >= this.numSourceDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numSourceDimensions; ++d) {
            source.setPosition(this.applyInverse(target.getIntPosition(d)), d);
        }
    }

    public InvertibleTransform inverse() {
        return new PermutationTransform(this.inverseLut, this.numTargetDimensions, this.numSourceDimensions);
    }

    public PermutationTransform copyToDimension(int numSourceDimensions, int numTargetDimensions) {
        return new PermutationTransform(this.inverseLut, numSourceDimensions, numTargetDimensions);
    }
}

