/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.DefaultTranslator;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Translator;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.MinimalTIFFFormat;
import io.scif.services.FormatService;
import io.scif.services.TranslatorService;
import io.scif.util.FormatTools;
import io.scif.xml.BaseHandler;
import io.scif.xml.XMLService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BrowsableLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

@Plugin(type=Format.class, name="Micro-Manager")
public class MicromanagerFormat
extends AbstractFormat {
    private static final String METADATA = "metadata.txt";
    private static final String XML = "Acqusition.xml";

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"tif", "tiff", "txt", "xml"};
    }

    private static class Index {
        public int z;
        public int c;
        public int t;
        public static final List<CalibratedAxis> expectedAxes = Arrays.asList(new DefaultLinearAxis(Axes.Z), new DefaultLinearAxis(Axes.CHANNEL), new DefaultLinearAxis(Axes.TIME));

        public Index(int[] zct) {
            this.z = zct[0];
            this.c = zct[1];
            this.t = zct[2];
        }
    }

    public static class Position {
        public Location baseTiff;
        public List<Location> tiffs;
        public Map<Index, Location> locationMap = new HashMap<Index, Location>();
        public BrowsableLocation metadataFile;
        public BrowsableLocation xmlFile;
        public String[] channels;
        public String comment;
        public String time;
        public Double exposureTime;
        public Double sliceThickness;
        public Double pixelSize;
        public Double[] timestamps;
        public int gain;
        public String binning;
        public String detectorID;
        public String detectorModel;
        public String detectorManufacturer;
        public double temperature;
        public List<Double> voltage;
        public String cameraRef;
        public String cameraMode;

        public Location getLocation(Metadata meta, int imageIndex, long planeIndex) {
            long[] zct = FormatTools.rasterToPosition(imageIndex, planeIndex, meta, Index.expectedAxes);
            for (Index key : this.locationMap.keySet()) {
                if ((long)key.z != zct[0] || (long)key.c != zct[1] || (long)key.t != zct[2]) continue;
                Location file = this.locationMap.get(key);
                if (this.tiffs == null) continue;
                for (Location tiff : this.tiffs) {
                    if (!tiff.getName().equals(file.getName())) continue;
                    return tiff;
                }
            }
            return this.locationMap.size() == 0 ? this.tiffs.get((int)planeIndex) : null;
        }
    }

    @Plugin(type=Translator.class, priority=-100.0)
    public static class MicromanagerTranslator
    extends DefaultTranslator {
        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Parameter
        private FormatService formatService;
        @Parameter
        private DataHandleService dataHandleService;
        private MinimalTIFFFormat.Reader<?> tiffReader;

        @Override
        protected String[] createDomainArray() {
            return new String[]{"Light Microscopy"};
        }

        @Override
        public void setMetadata(Metadata meta) throws IOException {
            this.tiffReader = null;
            super.setMetadata(meta);
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            if (this.tiffReader == null) {
                this.tiffReader = (MinimalTIFFFormat.Reader)this.formatService.getFormatFromClass(MinimalTIFFFormat.class).createReader();
            }
            Metadata meta = (Metadata)this.getMetadata();
            byte[] buf = plane.getBytes();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, bounds);
            Location file = meta.getPositions().get(imageIndex).getLocation(meta, imageIndex, planeIndex);
            if (file != null && this.dataHandleService.supports((Object)file) && this.dataHandleService.exists(file)) {
                this.tiffReader.setSource(file, config);
                return this.tiffReader.openPlane(imageIndex, 0L, plane, bounds);
            }
            this.log().warn((Object)("File for image #" + imageIndex + " (" + file + ") is missing or cannot be opened."));
            return plane;
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (this.tiffReader != null) {
                this.tiffReader.close(fileOnly);
            }
        }

        @Override
        public long getOptimalTileWidth(int imageIndex) {
            if (this.tiffReader == null || this.tiffReader.getCurrentLocation() == null) {
                this.setupReader(imageIndex);
            }
            return this.tiffReader.getOptimalTileWidth(imageIndex);
        }

        @Override
        public long getOptimalTileHeight(int imageIndex) {
            if (this.tiffReader == null || this.tiffReader.getCurrentLocation() == null) {
                this.setupReader(imageIndex);
            }
            return this.tiffReader.getOptimalTileHeight(imageIndex);
        }

        @Override
        public boolean hasCompanionFiles() {
            return true;
        }

        private boolean setupReader(int imageIndex) {
            try {
                Location file = ((Metadata)this.getMetadata()).getPositions().get(imageIndex).getLocation((Metadata)this.getMetadata(), imageIndex, 0L);
                if (file != null && this.dataHandleService.supports((Object)file) && this.dataHandleService.exists(file)) {
                    if (this.tiffReader == null) {
                        this.tiffReader = (MinimalTIFFFormat.Reader)this.formatService.getFormatFromClass(MinimalTIFFFormat.class).createReader();
                    }
                    this.tiffReader.setSource(file);
                    return true;
                }
                this.log().warn((Object)("File for image #" + imageIndex + " (" + file + ") is missing or cannot be opened."));
            }
            catch (Exception e) {
                this.log().debug((Object)"", (Throwable)e);
            }
            return false;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        public static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
        @Parameter
        private DataHandleService dataHandleService;
        @Parameter
        private TranslatorService translatorService;
        @Parameter
        private XMLService xmlService;

        public void populateMetadata(String[] jsonData, Metadata source, io.scif.Metadata dest) throws FormatException, IOException {
            source.createImageMetadata(jsonData.length);
            ArrayList<Position> positions = new ArrayList<Position>();
            for (int pos = 0; pos < jsonData.length; ++pos) {
                Position p = new Position();
                positions.add(p);
                this.parsePosition(jsonData[pos], source, pos);
            }
            this.translatorService.translate(source, dest, true);
        }

        @Override
        protected void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            ArrayList<Position> positions = new ArrayList<Position>();
            meta.setPositions(positions);
            this.log().info((Object)"Reading metadata file");
            BrowsableLocation file = this.asBrowsableLocation(stream);
            BrowsableLocation parentFile = file.parent();
            BrowsableLocation metadataFile = file.sibling(MicromanagerFormat.METADATA);
            if (metadataFile == null || parentFile == null) {
                throw new IOException("MicromanagerFormat: No companion metadata file found!");
            }
            if (parentFile.getName().contains("Pos_")) {
                parentFile = parentFile.parent();
                Set dirs = parentFile.children();
                for (BrowsableLocation dir : dirs) {
                    if (!dir.getName().contains("Pos_")) continue;
                    Position pos = new Position();
                    pos.metadataFile = dir.child(MicromanagerFormat.METADATA);
                    positions.add(pos);
                }
            } else {
                Position pos = new Position();
                pos.metadataFile = metadataFile;
                positions.add(pos);
            }
            int imageCount = positions.size();
            meta.createImageMetadata(imageCount);
            for (int i = 0; i < imageCount; ++i) {
                this.parsePosition(meta, i);
            }
        }

        @Override
        public Location[] getImageUsedFiles(int imageIndex, boolean noPixels) {
            FormatTools.assertId(this.getSource(), true, 1);
            ArrayList<Object> files = new ArrayList<Object>();
            for (Position pos : ((Metadata)this.getMetadata()).getPositions()) {
                files.add(pos.metadataFile);
                if (pos.xmlFile != null) {
                    files.add(pos.xmlFile);
                }
                if (noPixels) continue;
                for (Location tiff : pos.tiffs) {
                    try {
                        if (!this.dataHandleService.exists(tiff)) continue;
                        files.add(tiff);
                    }
                    catch (IOException exc) {
                        this.log().error((Object)("Could not check if location: " + tiff.getURI().toString() + " encountered exception: " + exc));
                    }
                }
            }
            return files.toArray(new Location[files.size()]);
        }

        @Override
        public boolean isSingleFile(Location id) {
            return false;
        }

        @Override
        public int fileGroupOption(Location id) {
            return 0;
        }

        @Override
        public boolean hasCompanionFiles() {
            return true;
        }

        private void parsePosition(Metadata meta, int posIndex) throws IOException, FormatException {
            Position pos = meta.getPositions().get(posIndex);
            try (DataHandle handle = (DataHandle)this.dataHandleService.create((Object)pos.metadataFile);){
                long len = handle.length();
                if (len > Integer.MAX_VALUE) {
                    throw new FormatException("MetadataFile at: " + pos.metadataFile.getURI() + " is too large to be parsed!");
                }
                String metaData = handle.readString((int)handle.length());
                this.parsePosition(metaData, meta, posIndex);
                this.buildTIFFList(meta, posIndex);
            }
        }

        private void buildTIFFList(Metadata meta, int posIndex) throws FormatException {
            try {
                Position p = meta.getPositions().get(posIndex);
                ImageMetadata ms = meta.get(posIndex);
                BrowsableLocation parent = p.metadataFile.parent();
                this.log().info((Object)"Finding image file names");
                p.tiffs = new ArrayList<Location>();
                this.buildTIFFList(meta, posIndex, p.baseTiff);
                if (p.tiffs.isEmpty()) {
                    ArrayList<String> uniqueZ = new ArrayList<String>();
                    ArrayList<String> uniqueC = new ArrayList<String>();
                    ArrayList<String> uniqueT = new ArrayList<String>();
                    Set fSet = parent.children();
                    Object[] files = fSet.toArray(new Location[fSet.size()]);
                    Arrays.sort(files);
                    for (Object file : files) {
                        String name = file.getName();
                        if (!FormatTools.checkSuffix(name, "tif") && !FormatTools.checkSuffix(name, "tiff")) continue;
                        String[] blocks = name.split("_");
                        if (!uniqueT.contains(blocks[1])) {
                            uniqueT.add(blocks[1]);
                        }
                        if (!uniqueC.contains(blocks[2])) {
                            uniqueC.add(blocks[2]);
                        }
                        if (!uniqueZ.contains(blocks[3])) {
                            uniqueZ.add(blocks[3]);
                        }
                        p.tiffs.add((Location)file);
                    }
                    ms.setAxisLength(Axes.Z, (long)uniqueZ.size());
                    ms.setAxisLength(Axes.CHANNEL, (long)uniqueC.size());
                    ms.setAxisLength(Axes.TIME, (long)uniqueT.size());
                    if (p.tiffs.isEmpty()) {
                        throw new FormatException("Could not find TIFF files.");
                    }
                }
            }
            catch (IOException e) {
                throw new FormatException("Encountered error when trying to find TIFF files.", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parsePosition(String jsonData, Metadata meta, int posIndex) throws IOException, FormatException {
            Position p = meta.getPositions().get(posIndex);
            ImageMetadata ms = meta.get(posIndex);
            BrowsableLocation metadataFile = p.metadataFile;
            this.log().info((Object)"Populating metadata");
            ArrayList<Double> stamps = new ArrayList<Double>();
            p.voltage = new ArrayList<Double>();
            StringTokenizer st = new StringTokenizer(jsonData, "\n");
            int[] slice = new int[3];
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                boolean open = token.contains("[");
                boolean closed = token.contains("]");
                if (open || !open && !closed && !token.equals("{") && !token.startsWith("}")) {
                    int quote = token.indexOf("\"") + 1;
                    String key = token.substring(quote, token.indexOf("\"", quote));
                    String value = null;
                    if (open == closed) {
                        value = token.substring(token.indexOf(":") + 1);
                    } else if (!closed) {
                        StringBuilder valueBuffer = new StringBuilder();
                        while (!closed) {
                            token = st.nextToken();
                            closed = token.contains("]");
                            valueBuffer.append(token);
                        }
                        value = valueBuffer.toString();
                        value = value.replaceAll("\n", "");
                    }
                    if (value == null) continue;
                    int startIndex = value.indexOf("[");
                    int endIndex = value.indexOf("]");
                    if (endIndex == -1) {
                        endIndex = value.length();
                    }
                    if ((value = value.substring(startIndex + 1, endIndex).trim()).length() == 0) continue;
                    value = value.substring(0, value.length() - 1);
                    if ((value = value.replaceAll("\"", "")).endsWith(",")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    meta.getTable().put(key, value);
                    if (key.equals("Channels")) {
                        ms.setAxisLength(Axes.CHANNEL, (long)Integer.parseInt(value));
                    } else if (key.equals("ChNames")) {
                        p.channels = value.split(",");
                        for (int q = 0; q < p.channels.length; ++q) {
                            p.channels[q] = p.channels[q].replaceAll("\"", "").trim();
                        }
                    } else if (key.equals("Frames")) {
                        ms.setAxisLength(Axes.TIME, (long)Integer.parseInt(value));
                    } else if (key.equals("Slices")) {
                        ms.setAxisLength(Axes.Z, (long)Integer.parseInt(value));
                    } else if (key.equals("PixelSize_um")) {
                        p.pixelSize = new Double(value);
                    } else if (key.equals("z-step_um")) {
                        p.sliceThickness = new Double(value);
                    } else if (key.equals("Time")) {
                        p.time = value;
                    } else if (key.equals("Comment")) {
                        p.comment = value;
                    } else if (key.equals("FileName")) {
                        BrowsableLocation file = metadataFile.sibling(value);
                        p.locationMap.put(new Index(slice), (Location)file);
                        if (p.baseTiff == null) {
                            p.baseTiff = file;
                        }
                    } else if (key.equals("Width")) {
                        ms.setAxisLength(Axes.X, (long)Integer.parseInt(value));
                    } else if (key.equals("Height")) {
                        ms.setAxisLength(Axes.Y, (long)Integer.parseInt(value));
                    } else if (key.equals("IJType")) {
                        int type = Integer.parseInt(value);
                        switch (type) {
                            case 0: {
                                ms.setPixelType(1);
                                break;
                            }
                            case 1: {
                                ms.setPixelType(3);
                                break;
                            }
                            default: {
                                throw new FormatException("Unknown type: " + type);
                            }
                        }
                    }
                }
                if (!token.startsWith("\"FrameKey")) continue;
                int dash = token.indexOf("-") + 1;
                int nextDash = token.indexOf("-", dash);
                slice[2] = Integer.parseInt(token.substring(dash, nextDash));
                dash = nextDash + 1;
                nextDash = token.indexOf("-", dash);
                slice[1] = Integer.parseInt(token.substring(dash, nextDash));
                dash = nextDash + 1;
                slice[0] = Integer.parseInt(token.substring(dash, token.indexOf("\"", dash)));
                token = st.nextToken().trim();
                String key = "";
                String value = "";
                boolean valueArray = false;
                int nestedCount = 0;
                while (!token.startsWith("}") || nestedCount > 0) {
                    block69: {
                        if (token.trim().endsWith("{")) {
                            ++nestedCount;
                            token = st.nextToken().trim();
                            continue;
                        }
                        if (token.trim().startsWith("}")) {
                            --nestedCount;
                            token = st.nextToken().trim();
                            continue;
                        }
                        if (valueArray) {
                            if (token.trim().equals("],")) {
                                valueArray = false;
                                break block69;
                            } else {
                                value = value + token.trim().replaceAll("\"", "");
                                token = st.nextToken().trim();
                                continue;
                            }
                        }
                        int colon = token.indexOf(":");
                        key = token.substring(1, colon).trim();
                        value = token.substring(colon + 1, token.length() - 1).trim();
                        key = key.replaceAll("\"", "");
                        value = value.replaceAll("\"", "");
                        if (token.trim().endsWith("[")) {
                            valueArray = true;
                            token = st.nextToken().trim();
                            continue;
                        }
                    }
                    meta.getTable().put(key, value);
                    if (key.equals("Exposure-ms")) {
                        double t = Double.parseDouble(value);
                        p.exposureTime = new Double(t / 1000.0);
                    } else if (key.equals("ElapsedTime-ms")) {
                        double t = Double.parseDouble(value);
                        stamps.add(new Double(t / 1000.0));
                    } else if (key.equals("Core-Camera")) {
                        p.cameraRef = value;
                    } else if (key.equals(p.cameraRef + "-Binning")) {
                        p.binning = value.contains("x") ? value : value + "x" + value;
                    } else if (key.equals(p.cameraRef + "-CameraID")) {
                        p.detectorID = value;
                    } else if (key.equals(p.cameraRef + "-CameraName")) {
                        p.detectorModel = value;
                    } else if (key.equals(p.cameraRef + "-Gain")) {
                        p.gain = (int)Double.parseDouble(value);
                    } else if (key.equals(p.cameraRef + "-Name")) {
                        p.detectorManufacturer = value;
                    } else if (key.equals(p.cameraRef + "-Temperature")) {
                        p.temperature = Double.parseDouble(value);
                    } else if (key.equals(p.cameraRef + "-CCDMode")) {
                        p.cameraMode = value;
                    } else if (key.startsWith("DAC-") && key.endsWith("-Volts")) {
                        p.voltage.add(new Double(value));
                    } else if (key.equals("FileName")) {
                        BrowsableLocation file = metadataFile.sibling(value);
                        p.locationMap.put(new Index(slice), (Location)file);
                        if (p.baseTiff == null) {
                            p.baseTiff = file;
                        }
                    }
                    token = st.nextToken().trim();
                }
            }
            p.timestamps = stamps.toArray(new Double[stamps.size()]);
            Arrays.sort((Object[])p.timestamps);
            p.xmlFile = p.metadataFile.sibling(MicromanagerFormat.XML);
            if (this.dataHandleService.exists((Location)p.xmlFile)) {
                this.parseXMLFile(meta, posIndex);
            }
        }

        private void buildTIFFList(Metadata meta, int posIndex, Location baseTiff) throws IOException {
            this.log().info((Object)"Building list of TIFFs");
            Position p = meta.getPositions().get(posIndex);
            String[] blocks = baseTiff.getName().split("_");
            StringBuilder filename = new StringBuilder();
            int t = 0;
            while ((long)t < meta.get(posIndex).getAxisLength(Axes.TIME)) {
                int c = 0;
                while ((long)c < meta.get(posIndex).getAxisLength(Axes.CHANNEL)) {
                    int z = 0;
                    while ((long)z < meta.get(posIndex).getAxisLength(Axes.Z)) {
                        filename.append(blocks[0]);
                        filename.append("_");
                        int zeros = blocks[1].length() - String.valueOf(t).length();
                        for (int q = 0; q < zeros; ++q) {
                            filename.append("0");
                        }
                        filename.append(t);
                        filename.append("_");
                        String channel = p.channels[c];
                        if (channel.contains("-")) {
                            channel = channel.substring(0, channel.indexOf("-"));
                        }
                        filename.append(channel);
                        filename.append("_");
                        zeros = blocks[3].length() - String.valueOf(z).length() - 4;
                        for (int q = 0; q < zeros; ++q) {
                            filename.append("0");
                        }
                        filename.append(z);
                        filename.append(".tif");
                        p.tiffs.add((Location)p.metadataFile.sibling(filename.toString()));
                        filename.delete(0, filename.length());
                        ++z;
                    }
                    ++c;
                }
                ++t;
            }
        }

        private void parseXMLFile(Metadata meta, int imageIndex) throws IOException, FormatException {
            Position p = meta.getPositions().get(imageIndex);
            try (DataHandle handle = (DataHandle)this.dataHandleService.create((Object)p.xmlFile);){
                long len = handle.length();
                if (len > Integer.MAX_VALUE) {
                    throw new FormatException("MetadataFile at: " + p.xmlFile.getURI() + " is too large to be parsed!");
                }
                String xmlData = handle.readString((int)handle.length());
                xmlData = this.xmlService.sanitizeXML(xmlData);
                MicromanagerHandler handler = new MicromanagerHandler();
                this.xmlService.parseXML(xmlData, (DefaultHandler)handler);
            }
        }

        private class MicromanagerHandler
        extends BaseHandler {
            public MicromanagerHandler() {
                super(Parser.this.log());
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                if (qName.equals("entry")) {
                    String key = attributes.getValue("key");
                    String value = attributes.getValue("value");
                    ((Metadata)Parser.this.getMetadata()).getTable().put(key, value);
                }
            }
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Parameter
        private FormatService formatService;
        @Parameter
        private DataHandleService dataHandleService;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isFormat(Location location, SCIFIOConfig config) {
            if (!config.checkerIsOpen()) {
                return false;
            }
            try {
                if (this.validMetadataFile(location)) {
                    try (DataHandle handle = (DataHandle)this.dataHandleService.create((Object)location);){
                        boolean bl = this.checkMetadataHandle((DataHandle<Location>)handle);
                        return bl;
                    }
                }
                if (!(location instanceof BrowsableLocation)) {
                    return false;
                }
                try (DataHandle handle = (DataHandle)this.dataHandleService.create((Object)location);){
                    boolean bl = this.checkImageFile((BrowsableLocation)location, config, (DataHandle<Location>)handle);
                    return bl;
                }
            }
            catch (IOException e) {
                this.log().error((Object)("Error when checking format: " + e));
                return false;
            }
        }

        private boolean checkImageFile(BrowsableLocation location, SCIFIOConfig config, DataHandle<Location> handle) {
            try {
                BrowsableLocation metaFile = location.sibling(MicromanagerFormat.METADATA);
                boolean validMetaData = this.isFormat(handle);
                if (!validMetaData) {
                    return false;
                }
                io.scif.Checker checker = this.formatService.getFormatFromClass(MinimalTIFFFormat.class).createChecker();
                boolean validTIFF = checker.isFormat(handle);
                return validTIFF && this.isFormat((Location)metaFile, config);
            }
            catch (FormatException | IOException e) {
                this.log().error((Object)"Error when checking format: ", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isFormat(DataHandle<Location> handle) throws IOException {
            Location location = (Location)handle.get();
            if (this.validMetadataFile(location)) {
                handle.seek(0L);
                return this.checkMetadataHandle(handle);
            }
            return location instanceof BrowsableLocation;
        }

        private boolean validMetadataFile(Location location) {
            if (location == null) {
                return false;
            }
            String name = location.getName();
            return name.equals(MicromanagerFormat.METADATA) || name.endsWith(File.separator + MicromanagerFormat.METADATA) || name.equals(MicromanagerFormat.XML) || name.endsWith(File.separator + MicromanagerFormat.XML);
        }

        private boolean checkMetadataHandle(DataHandle<Location> handle) throws IOException {
            if (!handle.exists()) {
                return false;
            }
            int blockSize = 0x100000;
            long length = handle.length();
            String data = handle.readString((int)Math.min(0x100000L, length));
            return length > 0L && (data.contains("Micro-Manager") || data.contains("micromanager"));
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private List<Position> positions;

        public List<Position> getPositions() {
            return this.positions;
        }

        public void setPositions(List<Position> positions) {
            this.positions = positions;
        }

        @Override
        public void populateImageMetadata() {
            for (int i = 0; i < this.getImageCount(); ++i) {
                ImageMetadata ms = this.get(i);
                ms.setAxisTypes(Axes.X, Axes.Y, Axes.Z, Axes.CHANNEL, Axes.TIME);
                ms.setPlanarAxisCount(2);
                ms.setLittleEndian(false);
                ms.setIndexed(false);
                ms.setFalseColor(false);
                ms.setMetadataComplete(true);
            }
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.positions = null;
            }
        }
    }
}

