/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.converters;

import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.img.ImgUtilityService;
import io.scif.img.converters.AbstractPlaneConverter;
import io.scif.img.converters.PlaneConverter;
import io.scif.util.FormatTools;
import net.imagej.ImgPlus;
import net.imglib2.RandomAccess;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=PlaneConverter.class, name="Default")
public class RandomAccessConverter
extends AbstractPlaneConverter {
    @Parameter
    private ImgUtilityService imgUtilService;

    @Override
    public <T extends RealType<T>> void populatePlane(Reader reader, int imageIndex, int planeIndex, byte[] plane, ImgPlus<T> img, SCIFIOConfig config) {
        Metadata m = reader.getMetadata();
        int pixelType = m.get(imageIndex).getPixelType();
        boolean little = m.get(imageIndex).isLittleEndian();
        long[] dimLengths = this.imgUtilService.getDimLengths(m, imageIndex, config);
        long[] pos = new long[dimLengths.length];
        boolean planeX = false;
        boolean planeY = true;
        this.getPosition(m, imageIndex, planeIndex, pos);
        int sX = (int)img.dimension(0);
        int sY = (int)img.dimension(1);
        RandomAccess randomAccess = img.randomAccess();
        int index = 0;
        for (int y = 0; y < sY; ++y) {
            pos[0] = 0L;
            pos[1] = y;
            randomAccess.setPosition(pos);
            for (int x = 1; x < sX; ++x) {
                ((RealType)randomAccess.get()).setReal(this.imgUtilService.decodeWord(plane, index++, pixelType, little));
                randomAccess.fwd(0);
            }
            ((RealType)randomAccess.get()).setReal(this.imgUtilService.decodeWord(plane, index++, pixelType, little));
        }
    }

    private void getPosition(Metadata m, int imageIndex, int planeIndex, long[] pos) {
        ImageMetadata meta = m.get(imageIndex);
        int offset = meta.getAxes().size() - meta.getAxesNonPlanar().size();
        long[] axesPositions = FormatTools.rasterToPosition(imageIndex, (long)planeIndex, m);
        for (int i = 0; i < axesPositions.length; ++i) {
            pos[i + offset] = axesPositions[i];
        }
    }
}

