/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Indexes;
import org.renjin.primitives.matrix.Matrix;
import org.renjin.primitives.subset.Selection;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class CoordinateMatrixSelection
extends Selection {
    private Matrix coordinateMatrix;
    private int[] sourceDim;

    public static boolean isCoordinateMatrix(SEXP source, SEXP subscript) {
        if (!(subscript instanceof IntVector) && !(subscript instanceof DoubleVector)) {
            return false;
        }
        Vector subscriptDim = subscript.getAttributes().getDim();
        if (subscriptDim.length() != 2) {
            return false;
        }
        SEXP sourceDim = source.getAttribute(Symbols.DIM);
        return sourceDim.length() == subscriptDim.getElementAsInt(1);
    }

    public CoordinateMatrixSelection(SEXP source, SEXP subscript) {
        super(source);
        this.coordinateMatrix = new Matrix((Vector)subscript);
        this.sourceDim = CoordinateMatrixSelection.dimAsIntArray(source);
        if (this.sourceDim.length != this.coordinateMatrix.getNumCols()) {
            throw new EvalException("The number of dimensions in the source (%d) does not match the number of columns in the provided coordinate matrix (%d)", this.sourceDim.length, this.coordinateMatrix.getNumCols());
        }
    }

    @Override
    public int getSourceDimensions() {
        return this.sourceDim.length;
    }

    @Override
    public int getElementCount() {
        return this.coordinateMatrix.getNumRows();
    }

    @Override
    protected AtomicVector getNames(int dimensionIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getSubscriptDimensions() {
        return new int[]{this.getElementCount()};
    }

    private int[] getCoordinate(int row2) {
        int[] coord = new int[this.sourceDim.length];
        for (int i = 0; i != coord.length; ++i) {
            coord[i] = this.coordinateMatrix.getElementAsInt(row2, i) - 1;
        }
        return coord;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new UnmodifiableIterator<Integer>(){
            private int row = 0;

            public boolean hasNext() {
                return this.row < CoordinateMatrixSelection.this.coordinateMatrix.getNumRows();
            }

            public Integer next() {
                return Indexes.arrayIndexToVectorIndex(CoordinateMatrixSelection.this.getCoordinate(this.row++), CoordinateMatrixSelection.this.sourceDim);
            }
        };
    }

    @Override
    public Iterable<Integer> getSelectionAlongDimension(final int dimensionIndex) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new UnmodifiableIterator<Integer>(){
                    int i = 0;

                    public boolean hasNext() {
                        return this.i < CoordinateMatrixSelection.this.coordinateMatrix.getNumRows();
                    }

                    public Integer next() {
                        return CoordinateMatrixSelection.this.coordinateMatrix.getElementAsInt(this.i++, dimensionIndex);
                    }
                };
            }
        };
    }
}

