/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.audioengines.javasound;

import org.jogamp.java3d.PhysicalBody;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import org.jogamp.java3d.audioengines.AuralParameters;
import org.jogamp.java3d.audioengines.javasound.JSSample;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

class JSPositionalSample
extends JSSample {
    float leftGain = 1.0f;
    float rightGain = 1.0f;
    int leftDelay = 0;
    int rightDelay = 0;
    protected static final boolean dopplerFlag = true;
    int secondIndex = -1;
    int reverbIndex = -1;
    Point3f xformLeftEar = new Point3f(-0.09f, -0.03f, 0.095f);
    Point3f xformRightEar = new Point3f(0.09f, -0.03f, 0.095f);
    Vector3f xformHeadZAxis = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f sourceToCenterEar = new Vector3f();
    Vector3f sourceToRightEar = new Vector3f();
    Vector3f sourceToLeftEar = new Vector3f();
    boolean averageDistances = false;
    long deltaTime = 0L;
    double sourcePositionChange = -1.0;
    double headPositionChange = -1.0;
    static int MAX_DISTANCES = 4;
    int numDistances = 0;
    long[] times = new long[MAX_DISTANCES];
    Point3f[] positions = new Point3f[MAX_DISTANCES];
    Point3f[] centerEars = new Point3f[MAX_DISTANCES];
    int firstIndex = 0;
    int lastIndex = 0;
    int currentIndex = 0;
    double lastRequestedDopplerRateRatio = -1.0;
    double lastActualDopplerRateRatio = -1.0;
    static double maxRatio = 256.0;
    static int TOWARDS = 1;
    static int NO_CHANGE = 0;
    static int AWAY = -1;
    boolean filterFlag = false;
    float filterFreq = -1.0f;

    public JSPositionalSample() {
        for (int i = 0; i < MAX_DISTANCES; ++i) {
            this.positions[i] = new Point3f();
            this.centerEars[i] = new Point3f(0.09f, -0.03f, 0.095f);
        }
        this.clear();
    }

    @Override
    boolean getFilterFlag() {
        return this.filterFlag;
    }

    @Override
    float getFilterFreq() {
        return this.filterFreq;
    }

    @Override
    public void clear() {
        super.clear();
        this.leftGain = 1.0f;
        this.rightGain = 1.0f;
        this.leftDelay = 0;
        this.rightDelay = 0;
        this.xformLeftEar.set(-0.09f, -0.03f, 0.095f);
        this.xformRightEar.set(0.09f, -0.03f, 0.095f);
        this.xformHeadZAxis.set(0.0f, 0.0f, -1.0f);
        this.sourceToCenterEar.set(0.0f, 0.0f, 0.0f);
        this.sourceToRightEar.set(0.0f, 0.0f, 0.0f);
        this.sourceToLeftEar.set(0.0f, 0.0f, 0.0f);
        this.reset();
    }

    @Override
    void reset() {
        super.reset();
        this.averageDistances = false;
        this.deltaTime = 0L;
        this.sourcePositionChange = -1.0;
        this.headPositionChange = -1.0;
        this.rateRatio = 1.0f;
        this.numDistances = 0;
        this.averageDistances = false;
    }

    void incrementIndices() {
        int maxIndex = MAX_DISTANCES - 1;
        if (this.numDistances < maxIndex) {
            this.averageDistances = false;
            this.currentIndex = this.numDistances++;
            this.lastIndex = this.currentIndex - 1;
            this.firstIndex = 0;
        } else if (this.numDistances == maxIndex) {
            this.averageDistances = true;
            this.currentIndex = maxIndex;
            this.lastIndex = this.currentIndex - 1;
            this.firstIndex = 0;
            ++this.numDistances;
        } else if (this.numDistances > maxIndex) {
            this.averageDistances = true;
            ++this.currentIndex;
            ++this.lastIndex;
            ++this.firstIndex;
            this.currentIndex %= MAX_DISTANCES;
            this.lastIndex %= MAX_DISTANCES;
            this.firstIndex %= MAX_DISTANCES;
        }
    }

    void setXformedPosition() {
        Point3f newPosition = new Point3f();
        if (this.getVWrldXfrmFlag()) {
            this.vworldXfrm.transform(this.position, newPosition);
        } else {
            newPosition.set((Tuple3f)this.position);
        }
        if (newPosition.x == this.positions[this.currentIndex].x && newPosition.y == this.positions[this.currentIndex].y && newPosition.z == this.positions[this.currentIndex].z) {
            return;
        }
        this.incrementIndices();
        this.times[this.currentIndex] = System.currentTimeMillis();
        this.positions[this.currentIndex].set((Tuple3f)newPosition);
        if (this.numDistances > 1) {
            this.centerEars[this.currentIndex].set((Tuple3f)this.centerEars[this.lastIndex]);
        }
    }

    float calculateDoppler(AuralParameters attribs) {
        double sampleRateRatio = 1.0;
        double headVelocity = 0.0;
        double soundVelocity = 0.0;
        double distanceSourceToHead = 0.0;
        double lastDistanceSourceToHead = 0.0;
        float speedOfSound = 0.344f;
        double numerator = 1.0;
        double denominator = 1.0;
        int direction = NO_CHANGE;
        float averagedSoundDistances = 0.0f;
        float averagedEarsDistances = 0.0f;
        if (!this.averageDistances) {
            this.debugPrint("JSPositionalSample.calculateDoppler - not enough distance data collected, dopplerRatio set to zero");
            return 0.0f;
        }
        Point3f lastXformPosition = this.positions[this.lastIndex];
        Point3f lastXformCenterEar = this.centerEars[this.lastIndex];
        Point3f xformPosition = this.positions[this.currentIndex];
        Point3f xformCenterEar = this.centerEars[this.currentIndex];
        distanceSourceToHead = xformPosition.distance(xformCenterEar);
        lastDistanceSourceToHead = lastXformPosition.distance(lastXformCenterEar);
        this.debugPrint("JSPositionalSample.calculateDoppler - distances: current,last = " + distanceSourceToHead + ", " + lastDistanceSourceToHead);
        this.debugPrint("                                      current position = " + xformPosition.x + ", " + xformPosition.y + ", " + xformPosition.z);
        this.debugPrint("                                      current ear = " + xformCenterEar.x + ", " + xformCenterEar.y + ", " + xformCenterEar.z);
        this.debugPrint("                                      last position = " + lastXformPosition.x + ", " + lastXformPosition.y + ", " + lastXformPosition.z);
        this.debugPrint("                                      last ear = " + lastXformCenterEar.x + ", " + lastXformCenterEar.y + ", " + lastXformCenterEar.z);
        if (distanceSourceToHead == lastDistanceSourceToHead) {
            this.debugPrint("JSPositionalSample.calculateDoppler - distance diff = 0, dopplerRatio set to zero");
            return 0.0f;
        }
        this.deltaTime = this.times[this.currentIndex] - this.times[this.firstIndex];
        for (int i = 0; i < MAX_DISTANCES - 1; ++i) {
            averagedSoundDistances += this.positions[i + 1].distance(this.positions[i]);
            averagedEarsDistances += this.centerEars[i + 1].distance(this.centerEars[i]);
        }
        soundVelocity = (averagedSoundDistances /= (float)(MAX_DISTANCES - 1)) / (float)this.deltaTime;
        headVelocity = (averagedEarsDistances /= (float)(MAX_DISTANCES - 1)) / (float)this.deltaTime;
        this.debugPrint("                                      delta time = " + this.deltaTime);
        this.debugPrint("                                      soundPosition delta = " + xformPosition.distance(lastXformPosition));
        this.debugPrint("                                      soundVelocity = " + soundVelocity);
        this.debugPrint("                                      headPosition delta = " + xformCenterEar.distance(lastXformCenterEar));
        this.debugPrint("                                      headVelocity = " + headVelocity);
        if (attribs != null) {
            float rolloff = attribs.rolloff;
            float velocityScaleFactor = attribs.velocityScaleFactor;
            if (rolloff != 1.0f) {
                speedOfSound *= rolloff;
                this.debugPrint("                                      attrib rollof = " + rolloff);
            }
            if (velocityScaleFactor != 1.0f) {
                this.debugPrint("                                      attrib velocity scale factor = " + velocityScaleFactor);
                this.debugPrint("                                      new soundVelocity = " + (soundVelocity *= (double)velocityScaleFactor));
                this.debugPrint("                                      new headVelocity = " + (headVelocity *= (double)velocityScaleFactor));
            }
        }
        if (distanceSourceToHead < lastDistanceSourceToHead) {
            this.debugPrint("                                      moving towards...");
            direction = TOWARDS;
            numerator = (double)speedOfSound + headVelocity;
            denominator = (double)speedOfSound - soundVelocity;
        } else {
            this.debugPrint("                                      moving away...");
            direction = AWAY;
            numerator = (double)speedOfSound - headVelocity;
            denominator = (double)speedOfSound + soundVelocity;
        }
        if (numerator <= 0.0) {
            this.debugPrint("JSPositionalSample.calculateDoppler: BOOM!! - velocity of head > speed of sound");
            return -1.0f;
        }
        if (denominator <= 0.0) {
            this.debugPrint("JSPositionalSample.calculateDoppler: BOOM!! - velocity of sound source negative");
            return -1.0f;
        }
        this.debugPrint("JSPositionalSample.calculateDoppler: numerator = " + numerator + ", denominator = " + denominator);
        sampleRateRatio = numerator / denominator;
        return (float)sampleRateRatio;
    }

    void updateEar(int dirtyFlags, View view) {
        Point3f xformCenterEar = new Point3f();
        if (!this.calculateNewEar(dirtyFlags, view, xformCenterEar)) {
            return;
        }
        if (xformCenterEar.x == this.centerEars[this.currentIndex].x && xformCenterEar.y == this.centerEars[this.currentIndex].y && xformCenterEar.z == this.centerEars[this.currentIndex].z) {
            return;
        }
        this.incrementIndices();
        this.times[this.currentIndex] = System.currentTimeMillis();
        this.centerEars[this.currentIndex].set((Tuple3f)xformCenterEar);
        if (this.numDistances > 1) {
            this.positions[this.currentIndex].set((Tuple3f)this.positions[this.lastIndex]);
        }
    }

    boolean calculateNewEar(int dirtyFlags, View view, Point3f xformCenterEar) {
        PhysicalBody body;
        Point3d earPosition = new Point3d();
        boolean earsXformed = false;
        if (!earsXformed && view != null && (body = view.getPhysicalBody()) != null) {
            Transform3D headToVwrld = new Transform3D();
            view.getUserHeadToVworld(headToVwrld);
            body.getLeftEarPosition(earPosition);
            this.xformLeftEar.x = (float)earPosition.x;
            this.xformLeftEar.y = (float)earPosition.y;
            this.xformLeftEar.z = (float)earPosition.z;
            body.getRightEarPosition(earPosition);
            this.xformRightEar.x = (float)earPosition.x;
            this.xformRightEar.y = (float)earPosition.y;
            this.xformRightEar.z = (float)earPosition.z;
            headToVwrld.transform(this.xformRightEar);
            headToVwrld.transform(this.xformLeftEar);
            this.xformHeadZAxis.set(0.0f, 0.0f, -1.0f);
            headToVwrld.transform(this.xformHeadZAxis);
            xformCenterEar.x = this.xformLeftEar.x + (this.xformRightEar.x - this.xformLeftEar.x) * 0.5f;
            xformCenterEar.y = this.xformLeftEar.y + (this.xformRightEar.y - this.xformLeftEar.y) * 0.5f;
            xformCenterEar.z = this.xformLeftEar.z + (this.xformRightEar.z - this.xformLeftEar.z) * 0.5f;
            earsXformed = true;
        }
        if (!earsXformed) {
            // empty if block
        }
        return earsXformed;
    }

    @Override
    public void render(int dirtyFlags, View view, AuralParameters attribs) {
        this.updateEar(dirtyFlags, view);
        float dopplerRatio = 1.0f;
        if (attribs != null) {
            float rolloff = attribs.rolloff;
            float frequencyScaleFactor = attribs.frequencyScaleFactor;
            float velocityScaleFactor = attribs.velocityScaleFactor;
            this.debugPrint("JSPositionalSample: attribs NOT null");
            if (!(rolloff <= 0.0f) && !(frequencyScaleFactor <= 0.0f)) {
                if (velocityScaleFactor > 0.0f) {
                    this.debugPrint("    velocityScaleFactor = " + velocityScaleFactor);
                    dopplerRatio = this.calculateDoppler(attribs);
                    if (dopplerRatio != 0.0f && dopplerRatio != -1.0f && dopplerRatio > 0.0f) {
                        this.rateRatio = dopplerRatio * frequencyScaleFactor * this.getRateScaleFactor();
                    }
                } else {
                    this.rateRatio = frequencyScaleFactor * this.getRateScaleFactor();
                }
            }
        } else {
            this.debugPrint("JSPositionalSample: attribs null");
            this.rateRatio = 1.0f;
        }
        this.panSample(attribs);
    }

    float calculateAngularGain() {
        return 1.0f;
    }

    void calculateFilter(float distance, AuralParameters attribs) {
        float distanceFilter = 44100.0f;
        float angularFilter = 44100.0f;
        int arrayLength = attribs.getDistanceFilterLength();
        int filterType = attribs.getDistanceFilterType();
        boolean distanceFilterFound = false;
        boolean angularFilterFound = false;
        if (filterType != -1 && arrayLength > 0) {
            double[] distanceArray = new double[arrayLength];
            float[] cutoffArray = new float[arrayLength];
            attribs.getDistanceFilter(distanceArray, cutoffArray);
            distanceFilter = this.findFactor(distance, distanceArray, cutoffArray);
            distanceFilterFound = !(distanceFilter < 0.0f);
        } else {
            distanceFilterFound = false;
            distanceFilter = -1.0f;
        }
        angularFilterFound = false;
        angularFilter = -1.0f;
        this.filterFlag = distanceFilterFound || angularFilterFound;
        this.filterFreq = distanceFilter;
    }

    float findFactor(double distance, double[] distanceArray, float[] factorArray) {
        if (distanceArray == null || factorArray == null) {
            return -1.0f;
        }
        int arrayLength = distanceArray.length;
        if (arrayLength < 2) {
            return -1.0f;
        }
        int largestIndex = arrayLength - 1;
        if (distance >= distanceArray[largestIndex]) {
            return factorArray[largestIndex];
        }
        if (distance <= distanceArray[0]) {
            return factorArray[0];
        }
        int lowIndex = 0;
        int highIndex = largestIndex;
        while (lowIndex < highIndex - 1) {
            if (distanceArray[lowIndex] >= distance) {
                if (distance < distanceArray[lowIndex]) {
                    // empty if block
                }
                return factorArray[lowIndex];
            }
            if (distanceArray[highIndex] <= distance) {
                if (distance > distanceArray[highIndex]) {
                    // empty if block
                }
                return factorArray[highIndex];
            }
            if (!(distance > distanceArray[lowIndex]) || !(distance < distanceArray[highIndex])) continue;
            int indexMid = lowIndex + (highIndex - lowIndex) / 2;
            if (distance <= distanceArray[indexMid]) {
                highIndex = indexMid;
                continue;
            }
            lowIndex = indexMid;
        }
        float outputFactor = (float)((distance - distanceArray[lowIndex]) / (distanceArray[highIndex] - distanceArray[lowIndex])) * (factorArray[highIndex] - factorArray[lowIndex]) + factorArray[lowIndex];
        return outputFactor;
    }

    float calculateDistanceAttenuation(float distance) {
        float factor = 1.0f;
        factor = this.findFactor(distance, this.attenuationDistance, this.attenuationGain);
        if ((double)factor >= 0.0) {
            return factor;
        }
        return 1.0f;
    }

    void panSample(AuralParameters attribs) {
        int quadrant = 1;
        float intensityHigh = 1.0f;
        float intensityLow = 0.125f;
        float intensityDifference = intensityHigh - intensityLow;
        float nearZero = 1.0E-6f;
        float nearOne = 0.999999f;
        float nearNegativeOne = -nearOne;
        float halfPi = 1.5707964f;
        float distanceSourceToCenterEar = 0.0f;
        float lastDistanceSourceToCenterEar = 0.0f;
        float distanceSourceToRightEar = 0.0f;
        float distanceSourceToLeftEar = 0.0f;
        float distanceBetweenEars = 0.18f;
        float radiusOfHead = 0.0f;
        float radiusOverDistanceToSource = 0.0f;
        float alpha = 0.0f;
        float sinAlpha = 0.0f;
        float gamma = 0.0f;
        float speedOfSound = 0.344f;
        float invSpeedOfSound = 1.0f / 0.344f;
        float sampleRate = 44.1f;
        boolean rightEarClosest = false;
        boolean soundFromBehind = false;
        float distanceGain = 1.0f;
        float allGains = this.gain;
        Point3f workingPosition = new Point3f();
        Point3f workingCenterEar = new Point3f();
        Vector3f mixScale = new Vector3f();
        workingPosition.set((Tuple3f)this.positions[this.currentIndex]);
        workingCenterEar.set((Tuple3f)this.centerEars[this.currentIndex]);
        this.sourceToCenterEar.x = workingCenterEar.x - workingPosition.x;
        this.sourceToCenterEar.y = workingCenterEar.y - workingPosition.y;
        this.sourceToCenterEar.z = workingCenterEar.z - workingPosition.z;
        this.sourceToRightEar.x = this.xformRightEar.x - workingPosition.x;
        this.sourceToRightEar.y = this.xformRightEar.y - workingPosition.y;
        this.sourceToRightEar.z = this.xformRightEar.z - workingPosition.z;
        this.sourceToLeftEar.x = this.xformLeftEar.x - workingPosition.x;
        this.sourceToLeftEar.y = this.xformLeftEar.y - workingPosition.y;
        this.sourceToLeftEar.z = this.xformLeftEar.z - workingPosition.z;
        distanceSourceToCenterEar = workingPosition.distance(workingCenterEar);
        distanceSourceToRightEar = workingPosition.distance(this.xformRightEar);
        distanceSourceToLeftEar = workingPosition.distance(this.xformLeftEar);
        distanceBetweenEars = this.xformRightEar.distance(this.xformLeftEar);
        radiusOfHead = distanceBetweenEars * 0.5f;
        radiusOverDistanceToSource = radiusOfHead / distanceSourceToCenterEar;
        double dotProduct = this.sourceToCenterEar.dot(this.xformHeadZAxis) / (this.sourceToCenterEar.length() * this.xformHeadZAxis.length());
        alpha = (float)Math.acos(dotProduct);
        if (alpha > halfPi) {
            soundFromBehind = true;
            alpha = (float)Math.PI - alpha;
        } else {
            soundFromBehind = false;
        }
        gamma = (float)Math.acos(radiusOverDistanceToSource);
        boolean bl = rightEarClosest = !(distanceSourceToRightEar > distanceSourceToLeftEar);
        quadrant = rightEarClosest ? (soundFromBehind ? 4 : 1) : (soundFromBehind ? 3 : 2);
        sinAlpha = (float)Math.sin(alpha);
        if ((double)sinAlpha < 0.0) {
            sinAlpha = -sinAlpha;
        }
        float DISTANCE = (float)Math.sqrt((double)distanceSourceToCenterEar * (double)distanceSourceToCenterEar + (double)(radiusOfHead * radiusOfHead));
        if (rightEarClosest) {
            distanceSourceToLeftEar = DISTANCE + radiusOfHead * (halfPi + alpha - gamma);
        } else {
            distanceSourceToRightEar = DISTANCE + radiusOfHead * (halfPi + alpha - gamma);
        }
        if (sinAlpha < radiusOverDistanceToSource) {
            if (rightEarClosest) {
                distanceSourceToRightEar = DISTANCE + radiusOfHead * (halfPi - alpha - gamma);
            } else {
                distanceSourceToLeftEar = DISTANCE + radiusOfHead * (halfPi - alpha - gamma);
            }
        } else if (rightEarClosest) {
            // empty if block
        }
        sampleRate = this.channel.rateInHz * 0.001f;
        if (rightEarClosest) {
            this.rightDelay = 0;
            this.leftDelay = (int)((distanceSourceToLeftEar - distanceSourceToRightEar) * invSpeedOfSound * sampleRate);
        } else {
            this.leftDelay = 0;
            this.rightDelay = (int)((distanceSourceToRightEar - distanceSourceToLeftEar) * invSpeedOfSound * sampleRate);
        }
        workingPosition.sub((Tuple3f)workingCenterEar);
        workingPosition.scale(1.0f / distanceSourceToCenterEar);
        distanceGain = this.calculateDistanceAttenuation(distanceSourceToCenterEar);
        allGains *= distanceGain;
        allGains *= this.calculateAngularGain();
        float halfX = workingPosition.x / 2.0f;
        float intensityOffset = halfX >= 0.0f ? intensityDifference * (0.5f - halfX) : intensityDifference * (0.5f + halfX);
        switch (quadrant) {
            case 1: 
            case 4: {
                this.rightGain = allGains * (intensityHigh - intensityOffset);
                this.leftGain = allGains * (intensityLow + intensityOffset);
                break;
            }
            case 2: 
            case 3: {
                this.leftGain = allGains * (intensityHigh - intensityOffset);
                this.rightGain = allGains * (intensityLow + intensityOffset);
            }
        }
        this.calculateFilter(distanceSourceToCenterEar, attribs);
    }
}

