/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.ogl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MakeGl {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String[] PROLOG = new String[]{"/****************************************************************************", "Copyright 2006, Colorado School of Mines and others.", "Licensed under the Apache License, Version 2.0 (the \"License\");", "you may not use this file except in compliance with the License.", "You may obtain a copy of the License at", "", "    http://www.apache.org/licenses/LICENSE-2.0", "", "Unless required by applicable law or agreed to in writing, software", "distributed under the License is distributed on an \"AS IS\" BASIS,", "WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.", "See the License for the specific language governing permissions and", "limitations under the License.", "****************************************************************************/", "package edu.mines.jtk.ogl;", "", "import java.nio.*;", "import javax.media.opengl.*;", "import com.jogamp.common.nio.PointerBuffer;", "", "/**", " * OpenGL standard constants and functions.", " * @author Dave Hale, Colorado School of Mines", " * @version 2014.06.10", " */", "@SuppressWarnings(\"deprecation\")", "public class Gl {", ""};
    private static final String[] EPILOG = new String[]{"  public static void setSwapInterval(int interval) {", "    gl().setSwapInterval(interval);", "  }", "", "  private static GL2 gl() {", "    return (GL2)GLContext.getCurrentGL();", "  }", "", "  ///////////////////////////////////////////////////////////////////////////", "  // private", "", "  private Gl() {", "  }", "}"};
    private static final Pattern _conName = Pattern.compile("final&nbsp;int (GL_\\w*)</pre>");
    private static final Pattern _funType = Pattern.compile("(\\w+)(?:</a>)?((?:\\[\\])*)&nbsp;\\w+\\(");
    private static final Pattern _parType = Pattern.compile("(\\w+)(?:</a>)?((?:\\[\\])*)&nbsp;\\w+[,\\)]");
    private static final Pattern _funName = Pattern.compile("&nbsp;(\\w+)\\(");
    private static final Pattern _parName = Pattern.compile("(\\w+)(?:</a>)?((?:\\[\\])*)&nbsp;(\\w+)[,\\)]");

    MakeGl() {
    }

    public static void main(String[] args) {
        String[] inputFileNames = new String[]{"GL.html", "GLBase.html", "GLLightingFunc.html", "GLMatrixFunc.html", "GLPointerFunc.html", "GL2.html", "GL2ES1.html", "GL2ES2.html", "GL2ES3.html", "GL2GL3.html"};
        String outputFileName = "Gl.java";
        HashSet<String> cs = new HashSet<String>();
        HashSet<String> fs = new HashSet<String>();
        try {
            MakeGl.trace("MakeGl begin ...");
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileName));
            for (String line : PROLOG) {
                bw.write(line + NEWLINE);
            }
            for (String inputFileName : inputFileNames) {
                MakeGl.trace("processing " + inputFileName);
                BufferedReader br = new BufferedReader(new FileReader(inputFileName));
                bw.write(NEWLINE + "  // Generated from " + inputFileName + NEWLINE + NEWLINE);
                MakeGl.guts(cs, fs, br, bw);
                br.close();
            }
            for (String line : EPILOG) {
                bw.write(line + NEWLINE);
            }
            bw.close();
            MakeGl.trace("... done");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static boolean hasConstant(String input) {
        return input.contains("static final&nbsp;int GL_");
    }

    private static boolean hasFunction(String input) {
        return input.startsWith("<pre>") && (input.contains("&nbsp;gl") || input.contains("&nbsp;is"));
    }

    private static boolean endFunction(String input) {
        return input.endsWith(")</pre>");
    }

    private static String getConName(String input) {
        Matcher m = _conName.matcher(input);
        return m.find() ? m.group(1) : null;
    }

    private static String getFunType(String input) {
        Matcher m = _funType.matcher(input);
        return m.find() ? m.group(1) + m.group(2) : null;
    }

    private static String getFunName(String input) {
        Matcher m = _funName.matcher(input);
        return m.find() ? m.group(1) : null;
    }

    private static String getParType(String input) {
        Matcher m = _parType.matcher(input);
        return m.find() ? m.group(1) + m.group(2) : null;
    }

    private static String getParName(String input) {
        Matcher m = _parName.matcher(input);
        return m.find() ? m.group(3) : null;
    }

    private static void guts(HashSet<String> cs, HashSet<String> fs, BufferedReader br, BufferedWriter bw) throws IOException {
        ArrayList<String> parList = new ArrayList<String>();
        String input = br.readLine();
        while (input != null) {
            if (MakeGl.hasConstant(input)) {
                String conName = MakeGl.getConName(input);
                if (!cs.add(conName)) {
                    MakeGl.trace("  duplicate: " + conName);
                } else {
                    String output = "  public static final int " + conName + NEWLINE + "    = GL2." + conName + ";" + NEWLINE + NEWLINE;
                    bw.write(output);
                }
            } else if (MakeGl.hasFunction(input)) {
                String funType = MakeGl.getFunType(input);
                String funName = MakeGl.getFunName(input);
                String funHash = funName + "(";
                String output = "  public static " + funType + " " + funName + "(" + NEWLINE + "    ";
                String parType = MakeGl.getParType(input);
                String parName = MakeGl.getParName(input);
                parList.clear();
                if (parType != null && parName != null) {
                    output = output + parType + " " + parName;
                    parList.add(parName);
                }
                while (!MakeGl.endFunction(input)) {
                    output = output + "," + NEWLINE;
                    input = br.readLine();
                    parType = MakeGl.getParType(input);
                    parName = MakeGl.getParName(input);
                    parList.add(parName);
                    funHash = funHash + parType;
                    output = output + "    " + parType + " " + parName;
                }
                output = output + ") {" + NEWLINE;
                if (!fs.add(funHash = funHash + ")")) {
                    MakeGl.trace("  duplicate: " + funHash);
                } else {
                    bw.write(output);
                    output = funType.equals("void") ? "    gl()." + funName + "(" : "    return gl()." + funName + "(";
                    int n = parList.size();
                    if (n == 0) {
                        bw.write(output + ");" + NEWLINE);
                    } else {
                        bw.write(output + NEWLINE);
                        for (int k = 0; k < n; ++k) {
                            output = k < n - 1 ? "      " + (String)parList.get(k) + "," : "      " + (String)parList.get(k) + ");";
                            bw.write(output + NEWLINE);
                        }
                    }
                    bw.write("  }" + NEWLINE + NEWLINE);
                }
            }
            input = br.readLine();
        }
    }

    private static void trace(String s) {
        System.out.println(s);
    }
}

