/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import java.awt.Frame;
import java.util.Arrays;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class IJRoiExporter {
    private final Logger logger;
    private final RoiManager roiManager;
    private final double dx;
    private final double dy;
    private final double dz;
    private final boolean is2D;

    public IJRoiExporter(ImagePlus imp, Logger logger) {
        this.dx = imp.getCalibration().pixelWidth;
        this.dy = imp.getCalibration().pixelHeight;
        this.dz = imp.getCalibration().pixelDepth;
        this.is2D = DetectionUtils.is2D(imp);
        this.logger = logger;
        this.roiManager = RoiManager.getRoiManager();
    }

    public void export(Iterable<Spot> spots) {
        int nspots = IJRoiExporter.count(spots);
        this.logger.log("Exporting " + nspots + " spots to ImageJ ROIs.\n");
        this.logger.setStatus("Exporting");
        int index = 0;
        for (Spot spot : spots) {
            this.export(spot);
            this.logger.setProgress((double)index++ / (double)nspots);
        }
        this.logger.setProgress(1.0);
        this.logger.setStatus("");
        this.logger.log("Done.\n");
    }

    public void export(Spot spot) {
        PolygonRoi roi;
        SpotRoi sroi = spot.getRoi();
        if (sroi != null) {
            double[] xs = sroi.toPolygonX(this.dx, 0.0, spot.getDoublePosition(0), 1.0);
            double[] ys = sroi.toPolygonY(this.dy, 0.0, spot.getDoublePosition(1), 1.0);
            float[] xp = IJRoiExporter.toFloat(xs);
            float[] yp = IJRoiExporter.toFloat(ys);
            roi = new PolygonRoi(xp, yp, 2);
        } else {
            double diameter = 2.0 * spot.getFeature("RADIUS") / this.dx;
            double xs = spot.getDoublePosition(0) / this.dx - diameter / 2.0 + 0.5;
            double ys = spot.getDoublePosition(1) / this.dy - diameter / 2.0 + 0.5;
            roi = new OvalRoi(xs, ys, diameter, diameter);
        }
        int z = this.is2D ? 0 : 1 + (int)Math.round(spot.getDoublePosition(2) / this.dz);
        int frame = 1 + spot.getFeature("FRAME").intValue();
        roi.setPosition(0, z, frame);
        roi.setName(spot.getName());
        this.roiManager.addRoi((Roi)roi);
    }

    private static final float[] toFloat(double[] d) {
        float[] f = new float[d.length];
        for (int i = 0; i < f.length; ++i) {
            f[i] = (float)d[i];
        }
        return f;
    }

    private static final int count(Iterable<Spot> spots) {
        int count = 0;
        for (Spot spot : spots) {
            ++count;
        }
        return count;
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class IJRoiExporterActionFactory
    implements TrackMateActionFactory {
        private static final String INFO_TEXT = "<html>Export the spots to ImageJ ROIs and store them in the ROI manager. <p>Spots with ROIs are exported as polygon-ROIs. Other spots are exported as an oval spot, located in a single Z-plane at the spot center. </html>";
        private static final String NAME = "Export spots to IJ ROIs";
        private static final String KEY = "EXPORT_TO_ROIS";

        @Override
        public String getInfoText() {
            return INFO_TEXT;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public String getKey() {
            return KEY;
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.ORANGE_ASTERISK_ICON;
        }

        @Override
        public TrackMateAction create() {
            return new IJRoiExporterAction();
        }
    }

    public static class IJRoiExporterAction
    extends AbstractTMAction {
        @Override
        public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
            Iterable<Spot> spots;
            GenericDialog dialog = new GenericDialog("Export spots to IJ ROIs", parent);
            dialog.addMessage("Export to IJ ROIs for:");
            String[] choices = new String[]{"All spots", "Selection", "Tracks of selection"};
            dialog.addRadioButtonGroup("Dimensionality:", choices, 2, 1, choices[1]);
            dialog.showDialog();
            if (dialog.wasCanceled()) {
                return;
            }
            int choice = Arrays.asList(choices).indexOf(dialog.getNextRadioButton());
            if (choice == 0) {
                spots = trackmate.getModel().getSpots().iterable(true);
            } else if (choice == 1) {
                spots = selectionModel.getSpotSelection();
            } else {
                selectionModel.selectTrack(selectionModel.getSpotSelection(), selectionModel.getEdgeSelection(), 0);
                spots = selectionModel.getSpotSelection();
            }
            IJRoiExporter exporter = new IJRoiExporter(trackmate.getSettings().imp, this.logger);
            exporter.export(spots);
        }
    }
}

