/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.features.ModelDataset;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.util.LineUtils;
import org.jfree.data.xy.XYDataset;
import org.jgrapht.graph.DefaultWeightedEdge;

public class EdgeCollectionDataset
extends ModelDataset {
    private static final long serialVersionUID = 1L;
    private final List<DefaultWeightedEdge> edges;
    private final Map<Integer, Set<DefaultWeightedEdge>> edgeMap;
    private final Function<DefaultWeightedEdge, String> labelGenerator;

    public EdgeCollectionDataset(Model model, SelectionModel selectionModel, DisplaySettings ds, String xFeature, List<String> yFeatures, List<DefaultWeightedEdge> edges, boolean addLines) {
        super(model, selectionModel, ds, xFeature, yFeatures);
        this.edges = edges;
        this.edgeMap = addLines ? EdgeCollectionDataset.createEdgeMap(edges, model.getTrackModel()) : null;
        this.labelGenerator = edge -> String.format("%s \u2192 %s", model.getTrackModel().getEdgeSource((DefaultWeightedEdge)edge).getName(), model.getTrackModel().getEdgeTarget((DefaultWeightedEdge)edge).getName());
    }

    private static Map<Integer, Set<DefaultWeightedEdge>> createEdgeMap(List<DefaultWeightedEdge> edges, TrackModel trackModel) {
        HashMap<Integer, Set<DefaultWeightedEdge>> edgeMap = new HashMap<Integer, Set<DefaultWeightedEdge>>();
        for (int i = 0; i < edges.size(); ++i) {
            HashSet<DefaultWeightedEdge> successors = new HashSet<DefaultWeightedEdge>();
            DefaultWeightedEdge edge = edges.get(i);
            Spot target = trackModel.getEdgeTarget(edge);
            for (DefaultWeightedEdge edgeCandidate : edges) {
                Spot source = trackModel.getEdgeSource(edgeCandidate);
                if (source != target) continue;
                successors.add(edgeCandidate);
            }
            if (successors.isEmpty()) continue;
            edgeMap.put(i, successors);
        }
        return edgeMap;
    }

    public int getItemCount(int series) {
        return this.edges.size();
    }

    public String getSeriesKey(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return this.model.getFeatureModel().getEdgeFeatureShortNames().get(this.yFeatures.get(series));
    }

    public Number getX(int series, int item) {
        return this.model.getFeatureModel().getEdgeFeature(this.edges.get(item), this.xFeature);
    }

    public Number getY(int series, int item) {
        return this.model.getFeatureModel().getEdgeFeature(this.edges.get(item), (String)this.yFeatures.get(series));
    }

    @Override
    public XYItemRenderer getRenderer() {
        return new MyXYItemRenderer();
    }

    @Override
    public String getItemLabel(int item) {
        DefaultWeightedEdge edge = this.edges.get(item);
        return this.labelGenerator.apply(edge);
    }

    @Override
    public void setItemLabel(int item, String label) {
    }

    private final class MyXYItemRenderer
    extends XYLineAndShapeRenderer {
        private static final long serialVersionUID = 1L;

        private MyXYItemRenderer() {
        }

        protected void drawPrimaryLine(XYItemRendererState state, Graphics2D g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea) {
            if (EdgeCollectionDataset.this.edgeMap == null || !EdgeCollectionDataset.this.edgeMap.containsKey(item)) {
                return;
            }
            RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
            RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
            PlotOrientation orientation = plot.getOrientation();
            String yFeature = (String)EdgeCollectionDataset.this.yFeatures.get(series);
            DefaultWeightedEdge sourceEdge = EdgeCollectionDataset.this.edges.get(item);
            Set<DefaultWeightedEdge> edges = EdgeCollectionDataset.this.edgeMap.get(item);
            for (DefaultWeightedEdge targetEdge : edges) {
                boolean visible;
                Double x1 = EdgeCollectionDataset.this.model.getFeatureModel().getEdgeFeature(targetEdge, EdgeCollectionDataset.this.xFeature);
                Double y1 = EdgeCollectionDataset.this.model.getFeatureModel().getEdgeFeature(targetEdge, yFeature);
                if (x1 == null || y1 == null || x1.isNaN() || y1.isNaN()) continue;
                Double x0 = EdgeCollectionDataset.this.model.getFeatureModel().getEdgeFeature(sourceEdge, EdgeCollectionDataset.this.xFeature);
                Double y0 = EdgeCollectionDataset.this.model.getFeatureModel().getEdgeFeature(sourceEdge, yFeature);
                if (x0 == null || y0 == null || x0.isNaN() || y0.isNaN()) continue;
                double transX0 = domainAxis.valueToJava2D(x0.doubleValue(), dataArea, xAxisLocation);
                double transY0 = rangeAxis.valueToJava2D(y0.doubleValue(), dataArea, yAxisLocation);
                double transX1 = domainAxis.valueToJava2D(x1.doubleValue(), dataArea, xAxisLocation);
                double transY1 = rangeAxis.valueToJava2D(y1.doubleValue(), dataArea, yAxisLocation);
                if (Double.isNaN(transX0) || Double.isNaN(transY0) || Double.isNaN(transX1) || Double.isNaN(transY1)) continue;
                if (orientation == PlotOrientation.HORIZONTAL) {
                    state.workingLine.setLine(transY0, transX0, transY1, transX1);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    state.workingLine.setLine(transX0, transY0, transX1, transY1);
                }
                if (!(visible = LineUtils.clipLine((Line2D)state.workingLine, (Rectangle2D)dataArea))) continue;
                this.drawFirstPassShape(g2, pass, series, item, state.workingLine);
            }
        }

        public Paint getItemPaint(int series, int item) {
            DefaultWeightedEdge edge = EdgeCollectionDataset.this.edges.get(item);
            if (EdgeCollectionDataset.this.selectionModel != null && EdgeCollectionDataset.this.selectionModel.getEdgeSelection().contains(edge)) {
                return EdgeCollectionDataset.this.ds.getHighlightColor();
            }
            FeatureColorGenerator<DefaultWeightedEdge> edgeColorGenerator = FeatureUtils.createTrackColorGenerator(EdgeCollectionDataset.this.model, EdgeCollectionDataset.this.ds);
            return edgeColorGenerator.color(EdgeCollectionDataset.this.edges.get(item));
        }

        public Stroke getItemStroke(int series, int item) {
            DefaultWeightedEdge edge = EdgeCollectionDataset.this.edges.get(item);
            if (EdgeCollectionDataset.this.selectionModel != null && EdgeCollectionDataset.this.selectionModel.getEdgeSelection().contains(edge)) {
                return EdgeCollectionDataset.this.selectionStroke;
            }
            return EdgeCollectionDataset.this.stroke;
        }

        public LegendItem getLegendItem(int datasetIndex, int series) {
            LegendItem legendItem = super.getLegendItem(datasetIndex, series);
            legendItem.setFillPaint((Paint)Color.BLACK);
            legendItem.setLinePaint((Paint)Color.BLACK);
            legendItem.setOutlinePaint((Paint)Color.BLACK);
            return legendItem;
        }
    }
}

