/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.spot;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.spot.SpotAnalyzer;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.type.numeric.RealType;

public abstract class AbstractSpotFeatureAnalyzer<T extends RealType<T>>
implements SpotAnalyzer<T>,
MultiThreaded,
Benchmark {
    protected String errorMessage;
    private long processingTime;
    private int numThreads;

    public abstract void process(Spot var1);

    public AbstractSpotFeatureAnalyzer() {
        this.setNumThreads();
    }

    @Override
    public void process(Iterable<Spot> spots) {
        long start = System.currentTimeMillis();
        ArrayList<1> tasks = new ArrayList<1>();
        for (final Spot spot : spots) {
            Callable<Void> task = new Callable<Void>(){
                final /* synthetic */ AbstractSpotFeatureAnalyzer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Void call() throws Exception {
                    try {
                        this.this$0.process(spot);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            tasks.add(task);
        }
        ExecutorService executorService = Threads.newFixedThreadPool(this.numThreads);
        try {
            List futures = executorService.invokeAll(tasks);
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        executorService.shutdown();
        this.processingTime = System.currentTimeMillis() - start;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads() {
        this.setNumThreads(Runtime.getRuntime().availableProcessors() / 2);
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }
}

