/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.tracker.JPanelFeaturePenalty;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JPanelFeatureSelectionGui
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JPanel panelButtons;
    private final JButton btnRemove;
    private final JButton btnAdd;
    private final Stack<JPanelFeaturePenalty> featurePanels = new Stack();
    private List<String> features;
    private Map<String, String> featureNames;
    private int index;

    public JPanelFeatureSelectionGui() {
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        this.panelButtons = new JPanel();
        this.add(this.panelButtons);
        this.panelButtons.setPreferredSize(new Dimension(260, 25));
        this.panelButtons.setLayout(null);
        this.btnRemove = new JButton();
        this.panelButtons.add(this.btnRemove);
        this.btnRemove.setIcon(Icons.REMOVE_ICON);
        this.btnRemove.setBounds(48, 5, 21, 22);
        this.btnRemove.addActionListener(e -> this.removeButtonPushed());
        this.btnAdd = new JButton();
        this.panelButtons.add(this.btnAdd);
        this.btnAdd.setIcon(Icons.ADD_ICON);
        this.btnAdd.setBounds(12, 5, 24, 22);
        this.btnAdd.addActionListener(e -> this.addButtonPushed());
        this.index = -1;
    }

    public void setDisplayFeatures(Collection<String> features, Map<String, String> featureNames) {
        this.features = new ArrayList<String>(features);
        this.featureNames = featureNames;
    }

    public void setSelectedFeaturePenalties(Map<String, Double> penalties) {
        while (!this.featurePanels.isEmpty()) {
            JPanelFeaturePenalty panel = this.featurePanels.pop();
            this.remove(panel);
        }
        this.remove(this.panelButtons);
        for (String feature : penalties.keySet()) {
            int localIndex = this.features.indexOf(feature);
            JPanelFeaturePenalty panel = new JPanelFeaturePenalty(this.features, this.featureNames, localIndex);
            panel.setSelectedFeature(feature, penalties.get(feature));
            this.add(panel);
            this.featurePanels.push(panel);
        }
        this.add(this.panelButtons);
    }

    public Map<String, Double> getFeaturePenalties() {
        HashMap<String, Double> weights = new HashMap<String, Double>(this.featurePanels.size());
        for (JPanelFeaturePenalty panel : this.featurePanels) {
            weights.put(panel.getSelectedFeature(), panel.getPenaltyWeight());
        }
        return weights;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ArrayList<JComponent> components = new ArrayList<JComponent>(3 + this.featurePanels.size());
        components.add(this.panelButtons);
        components.add(this.btnAdd);
        components.add(this.btnRemove);
        components.addAll(this.featurePanels);
        for (Component component : components) {
            component.setEnabled(enabled);
        }
    }

    private void addButtonPushed() {
        ++this.index;
        if (this.index >= this.features.size()) {
            this.index = 0;
        }
        JPanelFeaturePenalty panel = new JPanelFeaturePenalty(this.features, this.featureNames, this.index);
        this.featurePanels.push(panel);
        this.remove(this.panelButtons);
        this.add(panel);
        this.add(this.panelButtons);
        Dimension size = this.getSize();
        this.setSize(size.width, size.height + panel.getSize().height);
        this.revalidate();
    }

    private void removeButtonPushed() {
        if (this.featurePanels.isEmpty()) {
            return;
        }
        JPanelFeaturePenalty panel = this.featurePanels.pop();
        this.remove(panel);
        Dimension size = this.getSize();
        this.setSize(size.width, size.height - panel.getSize().height);
        this.revalidate();
    }
}

