/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.tracking.kalman.KalmanTrackerFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;

public class KalmanTrackerConfigPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final JFormattedTextField tfInitSearchRadius;
    private final JFormattedTextField tfSearchRadius;
    private final JFormattedTextField tfMaxFrameGap;

    public KalmanTrackerConfigPanel(String trackerName, String infoText, String spaceUnits) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        JLabel lblTrackerName = new JLabel(trackerName, KalmanTrackerFactory.ICON, 0);
        lblTrackerName.setFont(Fonts.BIG_FONT);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 10;
        this.add((Component)lblTrackerName, gbc);
        JEditorPane lblTrackerDescription = GuiUtils.infoDisplay(infoText.replace("</html>", "") + "<p>Online documentation: <br/><a href='https://imagej.net/plugins/trackmate/trackers/kalman-tracker'>https://imagej.net/plugins/trackmate/trackers/kalman-tracker</a></html>", true);
        lblTrackerDescription.setFont(Fonts.FONT.deriveFont(2));
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        this.add((Component)lblTrackerDescription, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        JLabel lblInitSearchRadius = new JLabel("Initial search radius:");
        lblInitSearchRadius.setFont(Fonts.FONT);
        gbc.gridx = 0;
        this.add((Component)lblInitSearchRadius, gbc);
        this.tfInitSearchRadius = new JFormattedTextField(15.0);
        this.tfInitSearchRadius.setHorizontalAlignment(0);
        this.tfInitSearchRadius.setFont(Fonts.FONT);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.tfInitSearchRadius, gbc);
        JLabel lblSpaceUnits1 = new JLabel(spaceUnits);
        lblSpaceUnits1.setFont(Fonts.FONT);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        this.add((Component)lblSpaceUnits1, gbc);
        gbc.gridy = 3;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        JLabel lblSearchRadius = new JLabel("Search radius:");
        lblSearchRadius.setFont(Fonts.FONT);
        this.add((Component)lblSearchRadius, gbc);
        this.tfSearchRadius = new JFormattedTextField(15.0);
        this.tfSearchRadius.setHorizontalAlignment(0);
        this.tfSearchRadius.setFont(Fonts.FONT);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.tfSearchRadius, gbc);
        JLabel lblSpaceUnits2 = new JLabel(spaceUnits);
        lblSpaceUnits2.setFont(Fonts.FONT);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        this.add((Component)lblSpaceUnits2, gbc);
        gbc.gridy = 4;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        JLabel lblMaxFrameGap = new JLabel("Max frame gap:");
        lblMaxFrameGap.setFont(Fonts.FONT);
        this.add((Component)lblMaxFrameGap, gbc);
        this.tfMaxFrameGap = new JFormattedTextField((Object)2);
        this.tfMaxFrameGap.setHorizontalAlignment(0);
        this.tfMaxFrameGap.setFont(Fonts.FONT);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.tfMaxFrameGap, gbc);
        JLabel lblFrameUnits = new JLabel("frames");
        lblFrameUnits.setFont(Fonts.FONT);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        this.add((Component)lblFrameUnits, gbc);
        gbc.gridy = 5;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        this.add(Box.createVerticalStrut(80), gbc);
        GuiUtils.selectAllOnFocus(this.tfInitSearchRadius);
        GuiUtils.selectAllOnFocus(this.tfMaxFrameGap);
        GuiUtils.selectAllOnFocus(this.tfSearchRadius);
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.tfInitSearchRadius.setValue(settings.get("LINKING_MAX_DISTANCE"));
        this.tfSearchRadius.setValue(settings.get("KALMAN_SEARCH_RADIUS"));
        this.tfMaxFrameGap.setValue(settings.get("MAX_FRAME_GAP"));
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("LINKING_MAX_DISTANCE", ((Number)this.tfInitSearchRadius.getValue()).doubleValue());
        settings.put("KALMAN_SEARCH_RADIUS", ((Number)this.tfSearchRadius.getValue()).doubleValue());
        settings.put("MAX_FRAME_GAP", ((Number)this.tfMaxFrameGap.getValue()).intValue());
        return settings;
    }

    @Override
    public void clean() {
    }
}

