/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.transformation;

import bdv.tools.transformation.ManualSourceTransforms;
import bdv.tools.transformation.TransformedSource;
import bdv.tools.transformation.XmlIoTransformedSources;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Element;

public class ManualTransformation {
    private final XmlIoTransformedSources io;
    private final AbstractViewerPanel viewer;
    private final List<SourceAndConverter<?>> sources;

    public ManualTransformation(List<SourceAndConverter<?>> sources) {
        this.sources = sources;
        this.viewer = null;
        this.io = new XmlIoTransformedSources();
    }

    public ManualTransformation(AbstractViewerPanel viewer) {
        this.viewer = viewer;
        this.sources = null;
        this.io = new XmlIoTransformedSources();
    }

    public Element toXml() {
        ArrayList<TransformedSource<?>> sources = this.getTransformedSources();
        ArrayList<AffineTransform3D> transforms = new ArrayList<AffineTransform3D>(sources.size());
        for (TransformedSource transformedSource : sources) {
            AffineTransform3D t = new AffineTransform3D();
            transformedSource.getFixedTransform(t);
            transforms.add(t);
        }
        return this.io.toXml(new ManualSourceTransforms(transforms));
    }

    public void restoreFromXml(Element parent) {
        Element elem = parent.getChild(this.io.getTagName());
        ArrayList<TransformedSource<?>> sources = this.getTransformedSources();
        List<AffineTransform3D> transforms = this.io.fromXml(elem).getTransforms();
        if (sources.size() != transforms.size()) {
            System.err.println("failed to load <" + this.io.getTagName() + "> source and transform count mismatch");
        } else {
            for (int i = 0; i < sources.size(); ++i) {
                ((TransformedSource)sources.get(i)).setFixedTransform(transforms.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<TransformedSource<?>> getTransformedSources() {
        List<SourceAndConverter<?>> sourceList;
        if (this.sources != null) {
            sourceList = this.sources;
        } else {
            ViewerState state = this.viewer.state();
            ViewerState viewerState = state;
            synchronized (viewerState) {
                sourceList = new ArrayList(state.getSources());
            }
        }
        ArrayList list = new ArrayList();
        for (SourceAndConverter sourceAndConverter : sourceList) {
            Source source = sourceAndConverter.getSpimSource();
            if (!(source instanceof TransformedSource)) continue;
            list.add((TransformedSource)source);
        }
        return list;
    }
}

