/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.convertersetupeditor;

import bdv.tools.brightness.ConverterSetup;
import bdv.ui.convertersetupeditor.BoundedRangePanel;
import bdv.ui.sourcegrouptree.SourceGroupTree;
import bdv.ui.sourcetable.SourceTable;
import bdv.util.BoundedRange;
import bdv.util.Bounds;
import bdv.viewer.ConverterSetupBounds;
import bdv.viewer.ConverterSetups;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

class BoundedRangeEditor {
    private final Supplier<List<ConverterSetup>> selectedConverterSetups;
    private final BoundedRangePanel rangePanel;
    private final ConverterSetupBounds converterSetupBounds;
    private boolean blockUpdates = false;
    private List<ConverterSetup> converterSetups;

    public BoundedRangeEditor(SourceTable table, ConverterSetups converterSetups, BoundedRangePanel rangePanel, ConverterSetupBounds converterSetupBounds) {
        this(table::getSelectedConverterSetups, converterSetups, rangePanel, converterSetupBounds);
        table.getSelectionModel().addListSelectionListener(e -> this.updateSelection());
    }

    public BoundedRangeEditor(SourceGroupTree tree, ConverterSetups converterSetups, BoundedRangePanel rangePanel, ConverterSetupBounds converterSetupBounds) {
        this(() -> converterSetups.getConverterSetups(tree.getSelectedSources()), converterSetups, rangePanel, converterSetupBounds);
        tree.getSelectionModel().addTreeSelectionListener(e -> this.updateSelection());
        tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                BoundedRangeEditor.this.updateSelection();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                BoundedRangeEditor.this.updateSelection();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                BoundedRangeEditor.this.updateSelection();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                BoundedRangeEditor.this.updateSelection();
            }
        });
    }

    private BoundedRangeEditor(Supplier<List<ConverterSetup>> selectedConverterSetups, ConverterSetups converterSetups, BoundedRangePanel rangePanel, ConverterSetupBounds converterSetupBounds) {
        this.selectedConverterSetups = selectedConverterSetups;
        this.rangePanel = rangePanel;
        this.converterSetupBounds = converterSetupBounds;
        rangePanel.changeListeners().add(this::updateConverterSetupRanges);
        converterSetups.listeners().add(s -> this.updateRangePanel());
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.runnableItem("set bounds ...", rangePanel::setBoundsDialog));
        menu.add(this.setBoundsItem("set bounds 0..1", 0.0, 1.0));
        menu.add(this.setBoundsItem("set bounds 0..255", 0.0, 255.0));
        menu.add(this.setBoundsItem("set bounds 0..65535", 0.0, 65535.0));
        menu.add(this.runnableItem("shrink bounds to selection", rangePanel::shrinkBoundsToRange));
        rangePanel.setPopup(() -> menu);
        this.updateRangePanel();
    }

    private JMenuItem setBoundsItem(String text, double min, double max) {
        JMenuItem item = new JMenuItem(text);
        item.addActionListener(e -> this.setBounds(new Bounds(min, max)));
        return item;
    }

    private JMenuItem runnableItem(String text, Runnable action) {
        JMenuItem item = new JMenuItem(text);
        item.addActionListener(e -> action.run());
        return item;
    }

    private synchronized void setBounds(Bounds bounds) {
        if (this.converterSetups == null || this.converterSetups.isEmpty()) {
            return;
        }
        for (ConverterSetup converterSetup : this.converterSetups) {
            this.converterSetupBounds.setBounds(converterSetup, bounds);
        }
        this.updateRangePanel();
    }

    private synchronized void updateConverterSetupRanges() {
        if (this.blockUpdates || this.converterSetups == null || this.converterSetups.isEmpty()) {
            return;
        }
        BoundedRange range = this.rangePanel.getRange();
        for (ConverterSetup converterSetup : this.converterSetups) {
            converterSetup.setDisplayRange(range.getMin(), range.getMax());
            this.converterSetupBounds.setBounds(converterSetup, range.getBounds());
        }
        this.updateRangePanel();
    }

    private synchronized void updateSelection() {
        this.converterSetups = this.selectedConverterSetups.get();
        this.updateRangePanel();
    }

    private synchronized void updateRangePanel() {
        if (this.converterSetups == null || this.converterSetups.isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                this.rangePanel.setEnabled(false);
                this.rangePanel.setConsistent(true);
            });
        } else {
            BoundedRange range = null;
            boolean allRangesEqual = true;
            for (ConverterSetup converterSetup : this.converterSetups) {
                Bounds bounds = this.converterSetupBounds.getBounds(converterSetup);
                double minBound = bounds.getMinBound();
                double maxBound = bounds.getMaxBound();
                double min = converterSetup.getDisplayRangeMin();
                double max = converterSetup.getDisplayRangeMax();
                BoundedRange converterSetupRange = new BoundedRange(minBound, maxBound, min, max);
                if (range == null) {
                    range = converterSetupRange;
                    continue;
                }
                allRangesEqual &= range.equals(converterSetupRange);
                range = range.join(converterSetupRange);
            }
            BoundedRange finalRange = range;
            boolean isConsistent = allRangesEqual;
            SwingUtilities.invokeLater(() -> {
                BoundedRangeEditor boundedRangeEditor = this;
                synchronized (boundedRangeEditor) {
                    this.blockUpdates = true;
                    this.rangePanel.setEnabled(true);
                    this.rangePanel.setRange(finalRange);
                    this.rangePanel.setConsistent(isConsistent);
                    this.blockUpdates = false;
                }
            });
        }
    }
}

