/*
 * Decompiled with CFR 0.152.
 */
package fiji.geom;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Shape_Index_Map
implements PlugInFilter {
    protected ImagePlus image;
    protected static GaussianBlur gaussianBlur;

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 13;
    }

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("Shape index map");
        gd.addNumericField("Gaussian_blur_radius (0 = off)", 0.0, 0);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            Shape_Index_Map.getShapeIndexMap(this.image, gd.getNextNumber()).show();
        }
    }

    public static ImagePlus getShapeIndexMap(ImagePlus image, double gaussianBlurRadius) {
        ImageStack stack = image.getStack();
        ImageStack result = new ImageStack(image.getWidth(), image.getHeight());
        for (int i = 1; i <= stack.getSize(); ++i) {
            ImageProcessor ip = stack.getProcessor(i);
            if (gaussianBlurRadius > 0.0) {
                FloatProcessor fp = (FloatProcessor)(image.getType() != 2 ? ip.convertToFloat() : ip.duplicate());
                if (gaussianBlur == null) {
                    gaussianBlur = new GaussianBlur();
                }
                gaussianBlur.blurFloat(fp, gaussianBlurRadius, gaussianBlurRadius, 0.02);
                ip = fp;
            }
            result.addSlice("", Shape_Index_Map.getShapeIndex(ip));
        }
        return new ImagePlus("Shape index of " + image.getTitle(), result);
    }

    public static ImageProcessor getShapeIndex(ImageProcessor ip) {
        ImageProcessor dx = Shape_Index_Map.deriveX(ip);
        ImageProcessor dy = Shape_Index_Map.deriveY(ip);
        ImageProcessor dxx = Shape_Index_Map.deriveX(dx);
        ImageProcessor dxy = Shape_Index_Map.deriveY(dx);
        ImageProcessor dyx = Shape_Index_Map.deriveX(dy);
        ImageProcessor dyy = Shape_Index_Map.deriveY(dy);
        float factor = 0.63661975f;
        int w = ip.getWidth();
        int h = ip.getHeight();
        FloatProcessor fp = new FloatProcessor(w, h);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                double D;
                float dnx_x = -dxx.getf(i, j);
                float dnx_y = -dxy.getf(i, j);
                float dny_x = -dyx.getf(i, j);
                float dny_y = -dyy.getf(i, j);
                float s = 0.63661975f * (float)Math.atan((double)(dnx_x + dny_y) / (D = Math.sqrt((dnx_x - dny_y) * (dnx_x - dny_y) + 4.0f * dnx_y * dny_x)));
                fp.setf(i, j, Float.isNaN(s) ? 0.0f : s);
            }
        }
        return fp;
    }

    public static ImageProcessor deriveX(ImageProcessor ip) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        FloatProcessor fp = new FloatProcessor(w, h);
        for (int j = 0; j < h; ++j) {
            float previous = 0.0f;
            for (int i = 0; i < w; ++i) {
                float current = ip.getf(i, j);
                fp.setf(i, j, current - previous);
                previous = current;
            }
        }
        return fp;
    }

    public static ImageProcessor deriveY(ImageProcessor ip) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        FloatProcessor fp = new FloatProcessor(w, h);
        for (int i = 0; i < w; ++i) {
            float previous = 0.0f;
            for (int j = 0; j < h; ++j) {
                float current = ip.getf(i, j);
                fp.setf(i, j, current - previous);
                previous = current;
            }
        }
        return fp;
    }
}

