/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import ij.ImageListener;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public abstract class CurrentSlice
implements AdjustmentListener,
ImageListener,
WindowListener {
    protected ImagePlus image;
    protected ImageProcessor ip;
    protected int slice;

    protected void obsolete() {
    }

    protected abstract void changed();

    public CurrentSlice() {
        ImagePlus.addImageListener((ImageListener)this);
        this.handleImages(true);
        this.check(WindowManager.getCurrentImage());
    }

    public void dispose() {
        ImagePlus.removeImageListener((ImageListener)this);
        this.handleImages(false);
    }

    protected void handleImages(boolean addAsListener) {
        int[] ids = WindowManager.getIDList();
        if (ids != null) {
            for (int id : ids) {
                this.handleImage(WindowManager.getImage((int)id), addAsListener);
            }
        }
    }

    protected void handleImage(ImagePlus image, boolean addAsListener) {
        ImageWindow window = image.getWindow();
        for (Component comp : window.getComponents()) {
            if (!(comp instanceof Scrollbar)) continue;
            Scrollbar bar = (Scrollbar)comp;
            if (addAsListener) {
                bar.addAdjustmentListener(this);
                continue;
            }
            bar.removeAdjustmentListener(this);
        }
        if (addAsListener) {
            window.addWindowListener((WindowListener)this);
        } else {
            window.removeWindowListener((WindowListener)this);
        }
    }

    public void check(ImagePlus imp) {
        if (this.image == imp && (this.image == null || this.ip == this.image.getProcessor() && this.slice == this.image.getCurrentSlice())) {
            return;
        }
        if (this.image != null && this.image.getProcessor() == null) {
            this.image = null;
        }
        if (this.image != null) {
            this.obsolete();
        }
        this.image = imp;
        this.ip = this.image == null ? null : this.image.getProcessor();
        this.slice = this.image == null ? 0 : this.image.getCurrentSlice();
        this.changed();
    }

    public void imageOpened(ImagePlus imp) {
        this.handleImage(imp, true);
        this.check(imp);
    }

    public void imageClosed(ImagePlus imp) {
        this.handleImage(imp, false);
        this.check(imp);
    }

    public void imageUpdated(ImagePlus imp) {
        this.check(imp);
    }

    protected void checkWindow(Component window) {
        if (!(window instanceof ImageWindow)) {
            return;
        }
        this.check(((ImageWindow)window).getImagePlus());
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        Scrollbar bar = (Scrollbar)event.getSource();
        this.checkWindow(bar.getParent());
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.checkWindow((Component)e.getSource());
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

