/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public class IJ_Robot
implements PlugIn {
    public void run(String arg) {
        if (!IJ.isJava2()) {
            IJ.error((String)"IJ_Robot", (String)"Java 1.3 or later required");
            return;
        }
        GenericDialog gd = new GenericDialog("IJ_Robot", (Frame)IJ.getInstance());
        gd.addMessage("IJ Robot v 1.0 by G. Landini");
        String[] DisplayOption = new String[]{"Left_Click", "Right_Click", "Middle_Click", "Left_Down", "Left_Up", "Right_Down", "Right_Up", "Middle_Down", "Middle_Up", "Move", "KeyPress", "GetPixel", "CaptureScreen"};
        gd.addChoice("Order", DisplayOption, DisplayOption[0]);
        gd.addMessage("Only 'Clicks' and 'Move' require X, Y coordinates.");
        gd.addNumericField("X_point:", 0.0, 0);
        gd.addNumericField("Y_point:", 0.0, 0);
        gd.addMessage("'Delay' is the time spent in one click.");
        gd.addNumericField("Delay (ms):", 300.0, 0);
        gd.addMessage("KeyPress supports 0-9 a-z A-Z space /.,-\nTo emulate the [enter] key, type '!'\nOther characters are converted to '.'");
        gd.addStringField("KeyPress:", "", 10);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String robotOption = gd.getNextChoice();
        int robotX = (int)gd.getNextNumber();
        int robotY = (int)gd.getNextNumber();
        int robotDelay = (int)gd.getNextNumber();
        String robotText = gd.getNextString();
        try {
            Toolkit toolkit;
            Dimension dimension;
            Rectangle r;
            BufferedImage img;
            Robot robot = new Robot();
            if (robotOption.equals("Left_Click")) {
                robot.mouseMove(robotX, robotY);
                robot.mousePress(16);
                robot.delay(robotDelay);
                robot.mouseRelease(16);
            }
            if (robotOption.equals("Left_Down")) {
                robot.mousePress(16);
            }
            if (robotOption.equals("Left_Up")) {
                robot.mouseRelease(16);
            }
            if (robotOption.equals("Right_Click")) {
                robot.mouseMove(robotX, robotY);
                robot.mousePress(4);
                robot.delay(robotDelay);
                robot.mouseRelease(4);
            }
            if (robotOption.equals("Right_Down")) {
                robot.mousePress(4);
            }
            if (robotOption.equals("Right_Up")) {
                robot.mouseRelease(4);
            }
            if (robotOption.equals("Middle_Down")) {
                robot.mousePress(8);
            }
            if (robotOption.equals("Middle_Up")) {
                robot.mouseRelease(8);
            }
            if (robotOption.equals("Middle_Click")) {
                robot.mouseMove(robotX, robotY);
                robot.mousePress(8);
                robot.delay(robotDelay);
                robot.mouseRelease(8);
            }
            if (robotOption.equals("Move")) {
                robot.mouseMove(robotX, robotY);
            }
            if (robotOption.equals("KeyPress")) {
                robot.mousePress(16);
                robot.delay(robotDelay);
                robot.mouseRelease(16);
                for (int i = 0; i < robotText.length(); ++i) {
                    char c = robotText.charAt(i);
                    int kc = c >= '0' && c <= '9' ? Character.getNumericValue(c) + 48 : (c >= 'a' && c <= 'z' ? Character.getNumericValue(c) + 55 : (c == '/' ? 47 : (c == ' ' ? 32 : (c == '-' ? 45 : (c == '.' ? 46 : (c == ',' ? 44 : (c == '!' ? 10 : (c >= 'A' && c <= 'Z' ? Character.getNumericValue(c) + 55 : 46))))))));
                    if (c >= 'A' && c <= 'Z') {
                        robot.keyPress(16);
                    }
                    robot.keyPress(kc);
                    robot.keyRelease(kc);
                    if (c < 'A' || c > 'Z') continue;
                    robot.keyRelease(16);
                }
            }
            if (robotOption.equals("GetPixel")) {
                Toolkit toolkit2 = Toolkit.getDefaultToolkit();
                IJ.log((String)("Width: " + (int)toolkit2.getScreenSize().getWidth() + "  Height: " + (int)toolkit2.getScreenSize().getHeight()));
                IJ.log((String)("Pixel at x=" + robotX + "  y=" + robotY + " : " + robot.getPixelColor(robotX, robotY)));
            }
            if (robotOption.equals("CaptureScreen") && (img = robot.createScreenCapture(r = new Rectangle(dimension = (toolkit = Toolkit.getDefaultToolkit()).getScreenSize()))) != null) {
                new ImagePlus("Screen", (Image)img).show();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

