/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.BranchGroupRetained;
import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.Group;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Node;
import org.scijava.java3d.PickBounds;
import org.scijava.java3d.PickInfo;
import org.scijava.java3d.PickPoint;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.RestrictedAccessException;
import org.scijava.java3d.SceneGraphPath;

public class BranchGroup
extends Group {
    public static final int ALLOW_DETACH = 17;

    @Override
    void createRetained() {
        this.retained = new BranchGroupRetained();
        this.retained.setSource(this);
    }

    public void compile() {
        if (this.isLive()) {
            throw new RestrictedAccessException(J3dI18N.getString("BranchGroup0"));
        }
        if (!this.isCompiled()) {
            this.checkForCycle();
            ((BranchGroupRetained)this.retained).compile();
        }
    }

    public void detach() {
        if (this.isLiveOrCompiled()) {
            Group parent;
            if (!this.getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("BranchGroup1"));
            }
            if (((BranchGroupRetained)this.retained).parent != null && !(parent = (Group)((BranchGroupRetained)this.retained).parent.source).getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("BranchGroup2"));
            }
        }
        ((BranchGroupRetained)this.retained).detach();
    }

    void validateModeFlagAndPickShape(int mode, int flags, PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("BranchGroup4"));
        }
        if (pickShape instanceof PickPoint && mode == 2) {
            throw new IllegalArgumentException(J3dI18N.getString("BranchGroup5"));
        }
        if ((flags & 0x20) != 0 && (flags & 0x40) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("BranchGroup6"));
        }
        if (mode == 1 && (flags & 0x78) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("BranchGroup7"));
        }
        if (pickShape instanceof PickBounds && (flags & 0x78) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("BranchGroup8"));
        }
    }

    public SceneGraphPath[] pickAll(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return ((BranchGroupRetained)this.retained).pickAll(pickShape);
    }

    public PickInfo[] pickAll(int mode, int flags, PickShape pickShape) {
        this.validateModeFlagAndPickShape(mode, flags, pickShape);
        return ((BranchGroupRetained)this.retained).pickAll(mode, flags, pickShape);
    }

    public SceneGraphPath[] pickAllSorted(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return ((BranchGroupRetained)this.retained).pickAllSorted(pickShape);
    }

    public PickInfo[] pickAllSorted(int mode, int flags, PickShape pickShape) {
        this.validateModeFlagAndPickShape(mode, flags, pickShape);
        return ((BranchGroupRetained)this.retained).pickAllSorted(mode, flags, pickShape);
    }

    public SceneGraphPath pickClosest(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return ((BranchGroupRetained)this.retained).pickClosest(pickShape);
    }

    public PickInfo pickClosest(int mode, int flags, PickShape pickShape) {
        this.validateModeFlagAndPickShape(mode, flags, pickShape);
        return ((BranchGroupRetained)this.retained).pickClosest(mode, flags, pickShape);
    }

    public SceneGraphPath pickAny(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return ((BranchGroupRetained)this.retained).pickAny(pickShape);
    }

    public PickInfo pickAny(int mode, int flags, PickShape pickShape) {
        this.validateModeFlagAndPickShape(mode, flags, pickShape);
        return ((BranchGroupRetained)this.retained).pickAny(mode, flags, pickShape);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        BranchGroup bg = new BranchGroup();
        bg.duplicateNode(this, forceDuplicate);
        return bg;
    }
}

