/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.jclipboardhelper.examples;

import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class BufferedImageExample {
    public static void main(String[] args) throws Exception {
        if (!ClipboardHelper.canPasteImageFromClipboard()) {
            System.out.println("No image on the clipboard, we'll just add one ourselves!");
            BufferedImage img = new BufferedImage(400, 300, 1);
            Graphics2D g = img.createGraphics();
            g.drawString("Hello jclipboardhelper!", 50, 150);
            g.dispose();
            ClipboardHelper.copyToClipboard(img);
            System.out.println("Try pasting into a word processor and press enter after pasting to end program.");
            System.in.read();
        } else {
            BufferedImage img = ClipboardHelper.pasteImageFromClipboard();
            if (img == null) {
                System.err.println("Failed to obtain image from clipboard, unfortunately.");
            } else {
                File outfile = new File(System.getProperty("java.io.tmpdir") + File.separator + "jclipboardhelper" + System.currentTimeMillis() + ".png");
                ImageIO.write((RenderedImage)img, "png", outfile);
                System.out.println("The image that we found on the clipboard has been saved as:");
                System.out.println(outfile);
            }
        }
    }
}

