/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.display.ColorTable;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, initializer="initAxes", menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Axes", mnemonic=97), @Menu(label="Reorder Axis")}, headless=true, attrs={@Attr(name="no-legacy")})
public class ReorderAxis
extends DynamicCommand {
    private static final String AXIS = "axis";
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter(persist=false)
    private String order;
    private int axisNum = 0;
    private boolean channelsCase = false;
    private ArrayList<String> choices = new ArrayList();
    private Dataset dataset;

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setAxis(int d) {
        this.internalSetAxis(d);
    }

    public int getAxis() {
        return this.axisNum;
    }

    public void setOrder(String order) {
        if (!this.valid(this.dataset, order)) {
            throw new IllegalArgumentException("Order string invalid: all axis indices should be separated by commasand specified once and only once");
        }
        this.order = order;
    }

    public String getOrder() {
        return this.order;
    }

    public void run() {
        if (!this.valid(this.dataset, this.order)) {
            this.cancel("Invalid axis order specification: all axis indices should be separated by commas and specified once and only once");
        }
        ImgPlus<? extends RealType<?>> newData = this.newData();
        this.dataset.setImgPlus(newData);
        this.imageDisplayService.getActiveDatasetView(this.display).rebuild();
    }

    protected void initAxes() {
        this.dataset = this.imageDisplayService.getActiveDataset(this.display);
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            AxisType type = ((CalibratedAxis)this.dataset.axis(i)).type();
            this.choices.add(type.getLabel());
        }
        DefaultMutableModuleItem axisItem = new DefaultMutableModuleItem((Module)this, AXIS, String.class);
        axisItem.setChoices(this.choices);
        axisItem.setPersisted(false);
        this.internalSetAxis(this.defaultAxis(this.dataset));
        axisItem.setValue((Module)this, (Object)((CalibratedAxis)this.dataset.axis(this.axisNum)).type().getLabel());
        axisItem.setCallback("axisChanged");
        this.addInput((ModuleItem)axisItem);
        this.defaultOrderString(this.dataset, this.axisNum);
    }

    protected void axisChanged() {
        String axisVal = (String)this.getInput(AXIS);
        for (int i = 0; i < this.choices.size(); ++i) {
            if (!axisVal.equals(this.choices.get(i))) continue;
            this.internalSetAxis(i);
            break;
        }
        this.defaultOrderString(this.dataset, this.axisNum);
    }

    private void internalSetAxis(int d) {
        this.axisNum = d;
        this.channelsCase = ((CalibratedAxis)this.dataset.axis(this.axisNum)).type().equals(Axes.CHANNEL);
    }

    private int defaultAxis(Dataset ds) {
        for (int i = 0; i < ds.numDimensions(); ++i) {
            AxisType type = ((CalibratedAxis)ds.axis(i)).type();
            if (type == Axes.X || type == Axes.Y || type == Axes.Z) continue;
            return i;
        }
        return 0;
    }

    private boolean valid(Dataset ds, String orderString) {
        String[] terms = orderString.split(",");
        if ((long)terms.length != ds.dimension(this.axisNum)) {
            return false;
        }
        int[] numbers = new int[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            int num;
            try {
                num = Integer.parseInt(terms[i].trim());
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (num <= 0) {
                return false;
            }
            if ((long)num > ds.dimension(this.axisNum)) {
                return false;
            }
            numbers[i] = num;
        }
        for (int num = 1; num <= numbers.length; ++num) {
            if (this.occurrences(numbers, num) == 1) continue;
            return false;
        }
        return true;
    }

    private int occurrences(int[] numbers, int num) {
        int count = 0;
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] != num) continue;
            ++count;
        }
        return count;
    }

    private void defaultOrderString(Dataset ds, int axis) {
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while ((long)i <= ds.dimension(axis)) {
            if (i != 1) {
                builder.append(", ");
            }
            builder.append(i);
            ++i;
        }
        this.order = builder.toString();
    }

    private ImgPlus<? extends RealType<?>> newData() {
        DatasetView view = this.imageDisplayService.getActiveDatasetView(this.display);
        ColorTable[] origTable = this.origViewTables(view);
        double[] origMin = this.origDisplayMins(view);
        double[] origMax = this.origDisplayMaxes(view);
        Dataset newData = this.dataset.duplicate();
        int[] positions = this.newPositions();
        int tableCount = this.dataset.getColorTableCount();
        for (int i = 0; i < positions.length; ++i) {
            this.copyHypersliceData(this.axisNum, this.dataset, positions[i], newData, i);
            if (!this.channelsCase) continue;
            ColorTable table = this.dataset.getColorTable(positions[i]);
            if (i < tableCount) {
                newData.setColorTable(table, i);
            }
            view.setColorTable(origTable[positions[i]], i);
            view.setChannelRange(i, origMin[positions[i]], origMax[positions[i]]);
        }
        return newData.getImgPlus();
    }

    private int[] newPositions() {
        String[] terms = this.order.split(",");
        int[] numbers = new int[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            int num = Integer.parseInt(terms[i].trim());
            numbers[i] = num - 1;
        }
        return numbers;
    }

    private double[] origDisplayMins(DatasetView view) {
        if (this.channelsCase) {
            int d = this.dataset.dimensionIndex(Axes.CHANNEL);
            int channels = (int)this.dataset.dimension(d);
            double[] ranges = new double[channels];
            for (int c = 0; c < channels; ++c) {
                ranges[c] = view.getChannelMin(c);
            }
            return ranges;
        }
        return null;
    }

    private ColorTable[] origViewTables(DatasetView view) {
        if (this.channelsCase) {
            List origTables = view.getColorTables();
            int d = this.dataset.dimensionIndex(Axes.CHANNEL);
            int channels = (int)this.dataset.dimension(d);
            ColorTable[] tables = new ColorTable[channels];
            for (int c = 0; c < channels; ++c) {
                tables[c] = (ColorTable)origTables.get(c);
            }
            return tables;
        }
        return null;
    }

    private double[] origDisplayMaxes(DatasetView view) {
        if (this.channelsCase) {
            int d = this.dataset.dimensionIndex(Axes.CHANNEL);
            int channels = (int)this.dataset.dimension(d);
            double[] ranges = new double[channels];
            for (int c = 0; c < channels; ++c) {
                ranges[c] = view.getChannelMax(c);
            }
            return ranges;
        }
        return null;
    }

    private void copyHypersliceData(int axis, Dataset origData, int origPos, Dataset newData, int newPos) {
        IntervalView origHyperSlice = Views.hyperSlice((RandomAccessibleInterval)origData.getImgPlus(), (int)axis, (long)origPos);
        IntervalView newHyperSlice = Views.hyperSlice((RandomAccessibleInterval)newData.getImgPlus(), (int)axis, (long)newPos);
        Cursor origCursor = Views.iterable((RandomAccessibleInterval)origHyperSlice).localizingCursor();
        RandomAccess newAccessor = newHyperSlice.randomAccess();
        while (origCursor.hasNext()) {
            double origValue = ((RealType)origCursor.next()).getRealDouble();
            newAccessor.setPosition((Localizable)origCursor);
            ((RealType)newAccessor.get()).setReal(origValue);
        }
    }
}

