/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.gauss;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.math.ImageConverter;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.util.Util;

public class GaussianConvolution3<A extends Type<A>, B extends NumericType<B>, C extends Type<C>>
implements MultiThreaded,
OutputAlgorithm<C>,
Benchmark {
    Image<A> image;
    final ImageFactory<B> factoryProcess;
    final ImageFactory<C> factoryOut;
    Image<C> convolved;
    Image<B> temp1;
    Image<B> temp2;
    final Converter<A, B> converterIn;
    final Converter<B, C> converterOut;
    final OutOfBoundsStrategyFactory<B> outOfBoundsFactory;
    int numDimensions;
    final double[] sigma;
    final double[][] kernel;
    long processingTime;
    int numThreads;
    String errorMessage = "";

    public GaussianConvolution3(Image<A> image, ImageFactory<B> factoryProcess, ImageFactory<C> factoryOut, OutOfBoundsStrategyFactory<B> outOfBoundsFactory, Converter<A, B> converterIn, Converter<B, C> converterOut, double[] sigma) {
        this.image = image;
        this.factoryProcess = factoryProcess;
        this.factoryOut = factoryOut;
        this.converterIn = converterIn;
        this.converterOut = converterOut;
        this.sigma = sigma;
        this.processingTime = -1L;
        this.outOfBoundsFactory = outOfBoundsFactory;
        this.numDimensions = image.getNumDimensions();
        this.kernel = new double[this.numDimensions][];
        this.setNumThreads();
        this.computeKernel();
    }

    public GaussianConvolution3(Image<A> image, ImageFactory<B> factoryProcess, ImageFactory<C> factoryOut, OutOfBoundsStrategyFactory<B> outOfBoundsFactory, Converter<A, B> converterIn, Converter<B, C> converterOut, double sigma) {
        this(image, factoryProcess, factoryOut, outOfBoundsFactory, converterIn, converterOut, GaussianConvolution3.createArray(image, sigma));
    }

    protected static double[] createArray(Image<?> image, double sigma) {
        double[] sigmas = new double[image.getNumDimensions()];
        for (int d = 0; d < image.getNumDimensions(); ++d) {
            sigmas[d] = sigma;
        }
        return sigmas;
    }

    protected void computeKernel() {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.kernel[d] = Util.createGaussianKernel1DDouble(this.sigma[d], true);
        }
    }

    public void setSigma(double sigma) {
        this.setSigma(GaussianConvolution3.createArray(this.image, sigma));
    }

    public void setSigma(double[] sigma) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.sigma[d] = sigma[d];
        }
        this.computeKernel();
    }

    public double[] getSigma() {
        return (double[])this.sigma.clone();
    }

    public void setImage(Image<A> image) {
        this.image = image;
        this.numDimensions = image.getNumDimensions();
    }

    public Image<A> getImage() {
        return this.image;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    public double[] getSigmas() {
        return this.sigma;
    }

    public int getKernelSize(int dim) {
        return this.kernel[dim].length;
    }

    @Override
    public Image<C> getResult() {
        return this.convolved;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "GaussianConvolution: [Image<T> img] is null.";
            return false;
        }
        if (this.outOfBoundsFactory == null) {
            this.errorMessage = "GaussianConvolution: [OutOfBoundsStrategyFactory<T>] is null.";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected Image<B> getInputImage() {
        ImageConverter<A, B> convIn = new ImageConverter<A, B>(this.image, this.factoryProcess, this.converterIn);
        if (!convIn.checkInput() || !convIn.process()) {
            this.errorMessage = "Cannot convert from A->B: " + convIn.getErrorMessage();
            return null;
        }
        return convIn.getResult();
    }

    protected Image<B> getTempImage1(int currentDim) {
        if (currentDim == 0) {
            this.temp1 = this.getInputImage();
        }
        return this.temp1;
    }

    protected Image<B> getTempImage2(int currentDim) {
        if (currentDim == 0) {
            this.temp2 = this.temp1.createNewImage();
        }
        return this.temp2;
    }

    protected LocalizableByDimCursor<B> getInputIterator(Image<B> temp1, Image<B> temp2, int currentDim) {
        if (currentDim % 2 == 0) {
            return temp1.createLocalizableByDimCursor(this.outOfBoundsFactory);
        }
        return temp2.createLocalizableByDimCursor(this.outOfBoundsFactory);
    }

    protected LocalizableCursor<B> getOutputIterator(Image<B> temp1, Image<B> temp2, int currentDim) {
        if (currentDim % 2 == 0) {
            return temp2.createLocalizableCursor();
        }
        return temp1.createLocalizableCursor();
    }

    protected Image<C> getConvolvedImage() {
        Image<B> outputSource;
        if (this.numDimensions % 2 == 0) {
            outputSource = this.temp1;
            this.temp2.close();
        } else {
            outputSource = this.temp2;
            if (this.numDimensions > 1) {
                this.temp1.close();
            }
        }
        ImageConverter<B, C> convOut = new ImageConverter<B, C>(outputSource, this.factoryOut, this.converterOut);
        if (!convOut.checkInput() || !convOut.process()) {
            this.errorMessage = "Cannot convert from B->C: " + convOut.getErrorMessage();
            return null;
        }
        if (this.numDimensions % 2 == 0) {
            if (this.numDimensions > 1) {
                this.temp1.close();
            }
        } else {
            this.temp2.close();
        }
        return convOut.getResult();
    }

    protected boolean processWithOptimizedMethod() {
        return false;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        if (this.processWithOptimizedMethod()) {
            this.processingTime = System.currentTimeMillis() - startTime;
            return this.errorMessage.length() == 0;
        }
        long imageSize = this.image.getNumPixels();
        final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(imageSize, this.numThreads);
        for (int dim = 0; dim < this.numDimensions; ++dim) {
            final int currentDim = dim;
            final Image<B> temp1 = this.getTempImage1(currentDim);
            if (temp1 == null) {
                return false;
            }
            final Image<B> temp2 = this.getTempImage2(currentDim);
            if (temp2 == null) {
                return false;
            }
            final AtomicInteger ai = new AtomicInteger(0);
            Thread[] threads = SimpleMultiThreading.newThreads(this.numThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                        LocalizableByDimCursor inputIterator = GaussianConvolution3.this.getInputIterator(temp1, temp2, currentDim);
                        LocalizableCursor outputIterator = GaussianConvolution3.this.getOutputIterator(temp1, temp2, currentDim);
                        GaussianConvolution3.this.convolveDim(inputIterator, outputIterator, currentDim, myChunk.getStartPosition(), myChunk.getLoopSize());
                        inputIterator.close();
                        outputIterator.close();
                    }
                });
            }
            SimpleMultiThreading.startAndJoin(threads);
        }
        this.convolved = this.getConvolvedImage();
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected void convolveDim(LocalizableByDimCursor<B> inputIterator, LocalizableCursor<B> outputIterator, int currentDim, long startPos, long loopSize) {
        this.convolve(inputIterator, outputIterator, currentDim, this.kernel[currentDim], startPos, loopSize);
    }

    protected void convolve(LocalizableByDimCursor<B> inputIterator, LocalizableCursor<B> outputIterator, int dim, double[] kernel, long startPos, long loopSize) {
        outputIterator.fwd(startPos);
        int filterSize = kernel.length;
        int filterSizeMinus1 = filterSize - 1;
        int filterSizeHalf = filterSize / 2;
        int filterSizeHalfMinus1 = filterSizeHalf - 1;
        int numDimensions = inputIterator.getImage().getNumDimensions();
        int iteratorPosition = filterSizeHalf;
        double lastKernelEntry = kernel[filterSizeMinus1];
        int[] to = new int[numDimensions];
        NumericType sum = (NumericType)((NumericType)inputIterator.getType()).createVariable();
        NumericType tmp = (NumericType)((NumericType)inputIterator.getType()).createVariable();
        for (long j = 0L; j < loopSize; ++j) {
            outputIterator.fwd();
            sum.setZero();
            outputIterator.getPosition(to);
            int n = dim;
            to[n] = to[n] - iteratorPosition;
            inputIterator.setPosition(to);
            for (int f = -filterSizeHalf; f <= filterSizeHalfMinus1; ++f) {
                tmp.set(inputIterator.getType());
                tmp.mul(kernel[f + filterSizeHalf]);
                sum.add(tmp);
                inputIterator.fwd(dim);
            }
            tmp.set(inputIterator.getType());
            tmp.mul(lastKernelEntry);
            sum.add(tmp);
            ((NumericType)outputIterator.getType()).set(sum);
        }
    }
}

