/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.imglib2.roi.labeling.SortedInts;
import net.imglib2.type.numeric.IntegerType;

public class LabelingMapping<T> {
    private final int maxNumLabelSets;
    private final ArrayList<InternedSet<T>> setsByIndex = new ArrayList();
    private final Map<SortedInts, InternedSet<T>> internedSets = new ConcurrentHashMap<SortedInts, InternedSet<T>>();
    private LabelIdBimap<T> labelIdBimap = new LabelIdBimap();
    private InternedSet<T> theEmptySet;
    private final Set<Reference<AddRemoveCacheMap>> cacheMaps = new HashSet<Reference<AddRemoveCacheMap>>();
    private final ReferenceQueue<AddRemoveCacheMap> cacheMapReferenceQueue = new ReferenceQueue();

    public LabelingMapping(IntegerType<?> indexType) {
        this((int)indexType.getMaxValue());
    }

    private LabelingMapping(int maxNumLabelSets) {
        this.maxNumLabelSets = maxNumLabelSets;
        this.theEmptySet = this.intern(SortedInts.emptyList());
    }

    LabelingMapping<T> newInstance() {
        return new LabelingMapping<T>(this.maxNumLabelSets);
    }

    void clear() {
        this.clearCacheMaps();
        this.setsByIndex.clear();
        this.internedSets.clear();
        this.theEmptySet = this.intern(SortedInts.emptyList());
    }

    public InternedSet<T> emptySet() {
        return this.theEmptySet;
    }

    InternedSet<T> setAtIndex(int index) {
        return this.setsByIndex.get(index);
    }

    public Set<T> labelsAtIndex(int index) {
        return this.setAtIndex(index);
    }

    public InternedSet<T> intern(Set<T> src) {
        return this.intern(this.asElementIds(src));
    }

    private InternedSet<T> intern(SortedInts labelIds) {
        return this.internedSets.computeIfAbsent(labelIds, this::create);
    }

    public int numSets() {
        return this.setsByIndex.size();
    }

    public Set<T> getLabels() {
        return this.labelIdBimap.getLabels();
    }

    public List<Set<T>> getLabelSets() {
        ArrayList<Set<T>> labelSets = new ArrayList<Set<T>>(this.numSets());
        labelSets.addAll(this.setsByIndex);
        return labelSets;
    }

    public void setLabelSets(List<Set<T>> labelSets) {
        if (labelSets.isEmpty()) {
            throw new IllegalArgumentException("expected non-empty list of label-sets");
        }
        if (!labelSets.get(0).isEmpty()) {
            throw new IllegalArgumentException("label-set at index 0 expected to be the empty label set");
        }
        this.clear();
        int numLabelSets = labelSets.size();
        for (int i = 1; i < numLabelSets; ++i) {
            SortedInts set = this.asElementIds(labelSets.get(i));
            if (this.internedSets.get(set) != null) {
                throw new IllegalArgumentException("no duplicates allowed in list of label-sets");
            }
            this.intern(set);
        }
        this.setsByIndex.trimToSize();
    }

    private synchronized InternedSet<T> create(SortedInts labelIds) {
        int index = this.setsByIndex.size();
        if (index > this.maxNumLabelSets) {
            throw new AssertionError((Object)String.format("Too many labels (or types of multiply-labeled pixels): %d maximum", index));
        }
        InternedSet internedSet = new InternedSet(this, labelIds, index);
        this.setsByIndex.add(internedSet);
        return internedSet;
    }

    private SortedInts asElementIds(Set<T> labelSet) {
        int[] values = new int[labelSet.size()];
        Iterator<T> iterator = labelSet.iterator();
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.labelIdBimap.getId(iterator.next());
        }
        Arrays.sort(values);
        return SortedInts.wrapSortedValues(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCacheMaps() {
        Set<Reference<AddRemoveCacheMap>> set = this.cacheMaps;
        synchronized (set) {
            this.cacheMaps.forEach(ref -> {
                AddRemoveCacheMap cacheMap = (AddRemoveCacheMap)ref.get();
                if (cacheMap != null) {
                    cacheMap.clear();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AddRemoveCacheMap createAddRemoveCacheMap() {
        Set<Reference<AddRemoveCacheMap>> set = this.cacheMaps;
        synchronized (set) {
            this.clearWeakReferences();
            AddRemoveCacheMap cacheMap = new AddRemoveCacheMap();
            this.cacheMaps.add(new WeakReference<AddRemoveCacheMap>(cacheMap, this.cacheMapReferenceQueue));
            return cacheMap;
        }
    }

    private void clearWeakReferences() {
        Reference<AddRemoveCacheMap> reference;
        while ((reference = this.cacheMapReferenceQueue.poll()) != null) {
            this.cacheMaps.remove(reference);
        }
    }

    @Deprecated
    public static class SerialisationAccess<T> {
        private final LabelingMapping<T> labelingMapping;

        protected SerialisationAccess(LabelingMapping<T> labelingMapping) {
            this.labelingMapping = labelingMapping;
        }

        @Deprecated
        protected List<Set<T>> getLabelSets() {
            return this.labelingMapping.getLabelSets();
        }

        @Deprecated
        protected void setLabelSets(List<Set<T>> labelSets) {
            this.labelingMapping.setLabelSets(labelSets);
        }
    }

    class AddRemoveCacheMap {
        private static final int CACHE_BITS = 8;
        private static final int CACHE_SIZE = 256;
        private static final int CACHE_MASK = 255;
        final CachedTriple<T>[] addCache = new CachedTriple[256];
        final CachedTriple<T>[] removeCache = new CachedTriple[256];

        AddRemoveCacheMap() {
            this.clear();
        }

        void clear() {
            Arrays.setAll(this.addCache, i -> new CachedTriple());
            Arrays.setAll(this.removeCache, i -> new CachedTriple());
        }

        public int addLabelToSetAtIndex(T label, int index) {
            int labelId;
            CachedTriple triple = this.addCache[this.getTripleIndex(label, index)];
            if (triple.fromIndex == index && triple.label.equals(label)) {
                return triple.toIndex;
            }
            SortedInts labelIds = LabelingMapping.this.setAtIndex(index).labelIds;
            SortedInts newLabelIds = labelIds.copyAndAdd(labelId = LabelingMapping.this.labelIdBimap.getId(label));
            int toIndex = newLabelIds == labelIds ? index : ((LabelingMapping)LabelingMapping.this).intern((SortedInts)newLabelIds).index;
            triple.fromIndex = index;
            triple.label = label;
            triple.toIndex = toIndex;
            return toIndex;
        }

        public int removeLabelFromSetAtIndex(T label, int index) {
            int labelId;
            CachedTriple triple = this.removeCache[this.getTripleIndex(label, index)];
            if (triple.fromIndex == index && triple.label.equals(label)) {
                return triple.toIndex;
            }
            SortedInts labelIds = LabelingMapping.this.setAtIndex(index).labelIds;
            SortedInts newLabelIds = labelIds.copyAndRemove(labelId = LabelingMapping.this.labelIdBimap.getId(label));
            int toIndex = newLabelIds == labelIds ? index : ((LabelingMapping)LabelingMapping.this).intern((SortedInts)newLabelIds).index;
            triple.fromIndex = index;
            triple.label = label;
            triple.toIndex = toIndex;
            return toIndex;
        }

        private int getTripleIndex(T label, int index) {
            return index * 37 + label.hashCode() * 31 & 0xFF;
        }
    }

    static class CachedTriple<T> {
        int fromIndex = -1;
        T label = null;
        int toIndex = -1;

        CachedTriple() {
        }
    }

    public static class InternedSet<T>
    extends AbstractCollection<T>
    implements Set<T> {
        private final LabelingMapping<T> container;
        private final SortedInts labelIds;
        final int index;

        private InternedSet(LabelingMapping<T> container, SortedInts labelIds, int index) {
            this.container = container;
            this.labelIds = labelIds;
            this.index = index;
        }

        @Override
        public int size() {
            return this.labelIds.size();
        }

        @Override
        public boolean isEmpty() {
            return this.labelIds.isEmpty();
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            for (T element : this) {
                hashCode += element.hashCode();
            }
            return hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof InternedSet && ((InternedSet)obj).container == this.container) {
                return obj == this;
            }
            return this.equalsSet(obj);
        }

        private boolean equalsSet(Object obj) {
            if (!(obj instanceof Set)) {
                return false;
            }
            Set other = (Set)obj;
            if (other.size() != this.size()) {
                return false;
            }
            for (Object elem : other) {
                if (this.contains(elem)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            int labelId = ((LabelingMapping)this.container).labelIdBimap.getIdIfExists(o);
            if (labelId == -1) {
                return false;
            }
            return this.labelIds.contains(labelId);
        }

        @Override
        public Iterator<T> iterator() {
            return new Iter();
        }

        class Iter
        implements Iterator<T> {
            private int i = 0;

            Iter() {
            }

            @Override
            public boolean hasNext() {
                return this.i < InternedSet.this.labelIds.size();
            }

            @Override
            public T next() {
                return InternedSet.this.container.labelIdBimap.getLabel(InternedSet.this.labelIds.get(this.i++));
            }
        }
    }

    private static class LabelIdBimap<T> {
        public static final int NO_ENTRY_VALUE = -1;
        private final List<T> labels = new ArrayList<T>();
        private final TObjectIntMap<T> labelToId = new TObjectIntHashMap(10, 0.5f, -1);

        private LabelIdBimap() {
        }

        T getLabel(int id) {
            return this.labels.get(id);
        }

        synchronized int getId(T label) {
            int id = this.labelToId.get(label);
            if (id != -1) {
                return id;
            }
            id = this.labels.size();
            this.labels.add(label);
            this.labelToId.put(label, id);
            return id;
        }

        synchronized int getIdIfExists(Object label) {
            return this.labelToId.get(label);
        }

        synchronized Set<T> getLabels() {
            return new HashSet<T>(this.labels);
        }
    }
}

