/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.axes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;

public class AxisSlicer {
    private final AxisMetadata axes;
    private HashMap<Integer, Integer> sliceMap;

    public AxisSlicer(AxisMetadata axes) {
        this.axes = axes;
        this.sliceMap = new HashMap();
    }

    public AxisSlicer slice(String label) {
        return this.slice(this.axes.indexOf(label), 0);
    }

    public AxisSlicer slice(String label, int position) {
        return this.slice(this.axes.indexOf(label), position);
    }

    public AxisSlicer sliceOverride(String label, int position) {
        return this.slice(this.axes.indexOf(label), position);
    }

    public AxisSlicer sliceType(String type, int position) {
        return this.sliceType(type, 0, position);
    }

    public AxisSlicer sliceType(String type, int typeIndex, int position) {
        assert (typeIndex >= 0);
        int[] idxs = this.axes.indexesOfType(type);
        if (typeIndex < idxs.length) {
            return this.slice(idxs[typeIndex], position);
        }
        return this;
    }

    public AxisSlicer slice(int dimension, int position) {
        if (!this.sliceMap.containsKey(dimension)) {
            this.sliceMap.put(dimension, position);
        }
        return this;
    }

    public AxisSlicer sliceOverride(int dimension, int position) {
        this.sliceMap.put(dimension, position);
        return this;
    }

    public <T> RandomAccessibleInterval<T> apply(RandomAccessibleInterval<T> img) {
        TreeSet<Integer> indexes = new TreeSet<Integer>(this.sliceMap.keySet());
        IntervalView out = img;
        Iterator<Integer> dit = indexes.descendingIterator();
        while (dit.hasNext()) {
            int d = dit.next();
            out = Views.hyperSlice(out, (int)d, (long)this.sliceMap.get(d).intValue());
        }
        return out;
    }
}

