/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.utils;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.Current;
import org.renjin.parser.NumericLiterals;
import org.renjin.primitives.io.connections.Connections;
import org.renjin.primitives.io.connections.PushbackBufferedReader;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Tables {
    public static StringVector readtablehead(@Current Context context, SEXP conn, double nLines, String commentChar, boolean blankLinesSkip, String quote, String sep, boolean skipNul) throws IOException {
        String line;
        PushbackBufferedReader reader = Connections.getConnection((Context)context, (SEXP)conn).getReader();
        StringVector.Builder head = new StringVector.Builder();
        while (nLines > 0.0 && (line = reader.readLine()) != null) {
            head.add(line);
            nLines -= 1.0;
        }
        return head.build();
    }

    public static Vector typeconvert(StringVector vector, StringVector naStrings, boolean asIs, String dec, String numerals) {
        Set<String> naSet = Tables.createHashSet(naStrings);
        Converter<?> converter = Tables.getConverter(vector, naSet);
        if (converter != null) {
            return converter.build(vector, naSet);
        }
        if (asIs) {
            return vector;
        }
        return Tables.buildFactor(vector, naSet);
    }

    private static Set<String> createHashSet(StringVector strings) {
        HashSet set = Sets.newHashSet();
        for (int i = 0; i < strings.length(); ++i) {
            String element = strings.getElementAsString(i);
            if (Strings.isNullOrEmpty((String)element)) continue;
            set.add(element);
        }
        return set;
    }

    private static Vector buildFactor(StringVector vector, Set<String> naStrings) {
        HashMap codes = Maps.newHashMap();
        IntArrayVector.Builder factor = new IntArrayVector.Builder(vector.length());
        for (int i = 0; i != vector.length(); ++i) {
            String element = vector.getElementAsString(i);
            if (Tables.isNa(element, naStrings)) continue;
            Integer code = (Integer)codes.get(element);
            if (code == null) {
                code = codes.size() + 1;
                codes.put(element, code);
            }
            factor.set(i, code.intValue());
        }
        StringVector.Builder levels = StringVector.newBuilder();
        for (Map.Entry level : codes.entrySet()) {
            levels.set((Integer)level.getValue() - 1, (String)level.getKey());
        }
        factor.setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf((String)"factor"));
        factor.setAttribute(Symbols.LEVELS, (SEXP)levels.build());
        return factor.build();
    }

    private static boolean isNa(String string, Set<String> naStrings) {
        return Strings.isNullOrEmpty((String)string) || naStrings.contains(string);
    }

    private static Converter<?> getConverter(StringVector vector, Set<String> naStrings) {
        Converter[] converters;
        for (Converter converter : converters = new Converter[]{new LogicalConverter(), new IntConverter(), new DoubleConverter()}) {
            if (!converter.accept(vector, naStrings)) continue;
            return converter;
        }
        return null;
    }

    private static class DoubleConverter
    extends Converter<DoubleArrayVector.Builder> {
        private DoubleConverter() {
        }

        @Override
        public boolean accept(String string) {
            try {
                return !DoubleVector.isNA((double)NumericLiterals.parseDouble((CharSequence)string));
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public void set(DoubleArrayVector.Builder builder, int index, String string) {
            builder.set(index, NumericLiterals.parseDouble((CharSequence)string));
        }

        @Override
        DoubleArrayVector.Builder newBuilder(int length) {
            return new DoubleArrayVector.Builder(length);
        }
    }

    private static class IntConverter
    extends Converter<IntArrayVector.Builder> {
        private IntConverter() {
        }

        @Override
        public boolean accept(String string) {
            try {
                double doubleValue = NumericLiterals.parseDouble((CharSequence)string);
                int intValue = (int)doubleValue;
                return (double)intValue == doubleValue;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public void set(IntArrayVector.Builder builder, int index, String string) {
            builder.set(index, NumericLiterals.parseInt((CharSequence)string));
        }

        @Override
        public IntArrayVector.Builder newBuilder(int length) {
            return new IntArrayVector.Builder(length);
        }
    }

    private static class LogicalConverter
    extends Converter<LogicalArrayVector.Builder> {
        private LogicalConverter() {
        }

        @Override
        public boolean accept(String string) {
            return string.equals("T") || string.equals("F") || string.equals("TRUE") || string.equals("FALSE");
        }

        @Override
        public void set(LogicalArrayVector.Builder builder, int index, String string) {
            if (string.equals("T") || string.equals("TRUE")) {
                builder.set(index, true);
            } else {
                builder.set(index, false);
            }
        }

        @Override
        LogicalArrayVector.Builder newBuilder(int length) {
            return new LogicalArrayVector.Builder(length);
        }
    }

    private static abstract class Converter<BuilderT extends Vector.Builder> {
        private Converter() {
        }

        abstract boolean accept(String var1);

        abstract BuilderT newBuilder(int var1);

        abstract void set(BuilderT var1, int var2, String var3);

        public boolean accept(StringVector vector, Set<String> naStrings) {
            for (int i = 0; i != vector.length(); ++i) {
                String element = vector.getElementAsString(i);
                if (Tables.isNa(element, naStrings) || this.accept(element)) continue;
                return false;
            }
            return true;
        }

        public Vector build(StringVector vector, Set<String> naStrings) {
            BuilderT builder = this.newBuilder(vector.length());
            for (int i = 0; i != vector.length(); ++i) {
                String element = vector.getElementAsString(i);
                if (Tables.isNa(element, naStrings)) continue;
                this.set(builder, i, element);
            }
            return builder.build();
        }
    }
}

