/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser.function;

import fiji.expressionparser.function.ImgLibFunction;
import java.util.Stack;
import net.imglib2.Cursor;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public abstract class SingleOperandPixelBasedAbstractFunction<T extends RealType<T>>
extends PostfixMathCommand
implements ImgLibFunction<T> {
    public final void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        FloatType result = null;
        if (param instanceof Img) {
            result = this.evaluate((Img)param);
        } else if (param instanceof RealType) {
            FloatType t = (FloatType)param;
            result = new FloatType(this.evaluate(t));
        } else {
            throw new ParseException("In function '" + this.getFunctionString() + "': Bad type of operand: " + param.getClass().getSimpleName());
        }
        inStack.push(result);
    }

    public final Img<FloatType> evaluate(Img<T> img) throws ParseException {
        long[] dimensions = new long[img.numDimensions()];
        img.dimensions(dimensions);
        ArrayImg result = new ArrayImgFactory().create(dimensions, (NativeType)new FloatType());
        Cursor ic = img.cursor();
        Cursor rc = result.cursor();
        while (rc.hasNext()) {
            rc.fwd();
            ic.fwd();
            ((FloatType)rc.get()).set(this.evaluate((RealType)ic.get()));
        }
        return result;
    }

    public abstract <R extends RealType<R>> float evaluate(R var1) throws ParseException;
}

