/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.imagemoments.centralmoments;

import net.imagej.ops.Ops;
import net.imagej.ops.imagemoments.AbstractImageMomentOp;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.ImageMoments.CentralMoment11.class, label="Image Moment: CentralMoment11")
public class DefaultCentralMoment11<I extends RealType<I>, O extends RealType<O>>
extends AbstractImageMomentOp<I, O>
implements Ops.ImageMoments.CentralMoment11 {
    private UnaryFunctionOp<IterableInterval<I>, O> moment00Func;
    private UnaryFunctionOp<IterableInterval<I>, O> moment01Func;
    private UnaryFunctionOp<IterableInterval<I>, O> moment10Func;
    private UnaryFunctionOp<IterableInterval<I>, O> moment11Func;

    @Override
    public void initialize() {
        this.moment00Func = RTs.function(this.ops(), Ops.ImageMoments.Moment00.class, this.in(), new Object[0]);
        this.moment01Func = RTs.function(this.ops(), Ops.ImageMoments.Moment01.class, this.in(), new Object[0]);
        this.moment10Func = RTs.function(this.ops(), Ops.ImageMoments.Moment10.class, this.in(), new Object[0]);
        this.moment11Func = RTs.function(this.ops(), Ops.ImageMoments.Moment11.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(IterableInterval<I> input, O output) {
        double moment00 = ((RealType)this.moment00Func.calculate(input)).getRealDouble();
        double moment01 = ((RealType)this.moment01Func.calculate(input)).getRealDouble();
        double moment10 = ((RealType)this.moment10Func.calculate(input)).getRealDouble();
        double moment11 = ((RealType)this.moment11Func.calculate(input)).getRealDouble();
        double centerX = moment10 / moment00;
        output.setReal(moment11 - centerX * moment01);
    }
}

